---
generated_at: 2026-02-01 10:02:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-430.status-uptime.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/430.status-uptime`（バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf`（デフォルト設定ファイル）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | daily_status_uptime_enableのデフォルトはYES | E-02 (L153) | ○ |
| C-02 | /var/rwho/*のファイル存在でruptime/uptimeを切り替え | E-01 (L15-L25) | ○ |
| C-03 | rwhoファイルあり時ruptimeを使用 | E-01 (L20) | ○ |
| C-04 | rwhoファイルなし時uptimeを使用 | E-01 (L24) | ○ |
| C-05 | tee /dev/stderrで出力しwc -lで行数カウント | E-01 (L26) | ○ |
| C-06 | 行数が1より大きい場合rc=1 | E-01 (L29) | ○ |
| C-07 | コマンド失敗時rc=3 | E-01 (L31) | ○ |
| C-08 | periodic.confを読み込む | E-01 (L7-L11) | ○ |
| C-09 | ヘッダ"Local system status:"を出力（uptimeの場合） | E-01 (L23) | ○ |
| C-10 | ヘッダ"Local network system status:"を出力（ruptimeの場合） | E-01 (L19) | ○ |
| C-11 | rwho判定は最初のファイルに対する-fテスト | E-01 (L16) | ○ |
| C-12 | 読み取り専用処理 | E-01 (全体) | ○ |
| C-13 | 無効時はrc=0で終了 | E-01 (L34) | ○ |
| C-14 | バッチ一覧でカテゴリはdaily/ステータス確認 | E-03 (L24) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] rwhoデータが存在する環境でruptimeが正しく動作するか確認
- [ ] tee /dev/stderrによる出力の二重表示が問題にならないか確認
