---
generated_at: 2026-02-01 10:03:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-440.status-mailq.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/440.status-mailq`（バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf`（デフォルト設定ファイル）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | daily_status_mailq_enableのデフォルトはYES | E-02 (L156) | ○ |
| C-02 | daily_status_mailq_shortenのデフォルトはNO | E-02 (L157) | ○ |
| C-03 | daily_status_include_submit_mailqのデフォルトはYES | E-02 (L158) | ○ |
| C-04 | /usr/bin/mailqの実行可能性を-xで確認 | E-01 (L15) | ○ |
| C-05 | 実行不可時にrc=2を返す | E-01 (L19) | ○ |
| C-06 | shorten=YES時にegrep+sort+uniq -c+sort -fnrで集計 | E-01 (L26-L31) | ○ |
| C-07 | キュー空の判定にegrep -vを使用 | E-01 (L35) | ○ |
| C-08 | "Mail queue is empty"/"mqueue is empty"/"Total requests"を除外 | E-01 (L35) | ○ |
| C-09 | サブミットキューは/etc/mail/submit.cf存在時のみ確認 | E-01 (L40) | ○ |
| C-10 | サブミットキューはmailq -Acで取得 | E-01 (L47, L54) | ○ |
| C-11 | ヘッダ"Mail in local queue:"を出力 | E-01 (L22) | ○ |
| C-12 | ヘッダ"Mail in submit queue:"を出力 | E-01 (L43) | ○ |
| C-13 | キューにメールあり時rc=1 | E-01 (L36) | ○ |
| C-14 | キュー空時rc=0 | E-01 (L36) | ○ |
| C-15 | periodic.confを読み込む | E-01 (L7-L11) | ○ |
| C-16 | バッチ一覧でカテゴリはdaily/ステータス確認 | E-03 (L25) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] shorten=YES時の出力フォーマットが期待通りか確認
- [ ] sendmail以外のMTA（postfix等）でmailqコマンドの互換性を確認
