---
generated_at: 2026-02-01 10:04:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-450.status-security.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/450.status-security`（バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf`（デフォルト設定ファイル）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | daily_status_security_enableのデフォルトはYES | E-02 (L161) | ○ |
| C-02 | daily_status_security_inlineのデフォルトはNO | E-02 (L163) | ○ |
| C-03 | daily_status_security_outputのデフォルトはroot | E-02 (L164) | ○ |
| C-04 | inline=YES時にsecurity_outputを空文字に設定 | E-01 (L19-L21) | ○ |
| C-05 | security_outputを環境変数としてエクスポート | E-01 (L23) | ○ |
| C-06 | 出力先空文字時に一時ファイルを作成 | E-01 (L27) | ○ |
| C-07 | 一時ファイル名パターンは450.status-security.XXXXXX | E-01 (L27) | ○ |
| C-08 | periodic securityを実行 | E-01 (L29, L38, L41) | ○ |
| C-09 | 一時ファイルにデータあり時rc=3 | E-01 (L30-L33) | ○ |
| C-10 | 一時ファイルを削除 | E-01 (L34) | ○ |
| C-11 | /で始まるパス時"output logged separately"を表示 | E-01 (L37) | ○ |
| C-12 | その他の場合"output mailed separately"を表示 | E-01 (L40) | ○ |
| C-13 | ヘッダ"Security check:"を出力 | E-01 (L16) | ○ |
| C-14 | periodic.confを読み込む | E-01 (L7-L11) | ○ |
| C-15 | 無効時はrc=0で終了 | E-01 (L43) | ○ |
| C-16 | periodic security失敗時rc=3 | E-01 (L29, L38, L41) | ○ |
| C-17 | バッチ一覧でカテゴリはdaily/セキュリティ | E-03 (L26) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] periodic securityが呼び出すセキュリティスクリプトの一覧が最新か確認
- [ ] 一時ファイルのクリーンアップが確実に行われるか確認（異常終了時含む）
- [ ] security_outputの各モード（インライン/ファイル/メール）の動作を確認
