---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-460.status-mail-rejects.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/460.status-mail-rejects`（バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf`（デフォルト設定ファイル）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | daily_status_mail_rejects_enableのデフォルトはYES | E-02 (L167) | ○ |
| C-02 | daily_status_mail_rejects_logsのデフォルトは3 | E-02 (L168) | ○ |
| C-03 | daily_status_mail_rejects_shortenのデフォルトはNO | E-02 (L169) | ○ |
| C-04 | shorten=YES時はcut -d" " -f2,3を使用 | E-01 (L14) | ○ |
| C-05 | /etc/mailの存在を確認 | E-01 (L20) | ○ |
| C-06 | /var/log/maillogの存在を確認 | E-01 (L25) | ○ |
| C-07 | logs <= 0 の場合エラー | E-01 (L30) | ○ |
| C-08 | RFC 3164形式のタイムスタンプ対応 | E-01 (L40) | ○ |
| C-09 | RFC 5424形式のタイムスタンプ対応 | E-01 (L41-L42) | ○ |
| C-10 | 圧縮ログ対応: .gz, .bz2, .xz, .zst | E-01 (L55-L67) | ○ |
| C-11 | check_relay、check_rcptルールセットの解析 | E-01 (L72-L76) | ○ |
| C-12 | sort -f → uniq -ic → sort -fnr で集計 | E-01 (L78) | ○ |
| C-13 | リジェクトあり時rc=1 | E-01 (L79) | ○ |
| C-14 | ヘッダ"Checking for rejected mail hosts:"を出力 | E-01 (L37) | ○ |
| C-15 | periodic.confを読み込む | E-01 (L7-L11) | ○ |
| C-16 | 無効時はrc=0で終了 | E-01 (L82) | ○ |
| C-17 | 前日のログ行を対象とし当日で停止 | E-01 (L71) | ○ |
| C-18 | バッチ一覧でカテゴリはdaily/ステータス確認 | E-03 (L27) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] sed正規表現が実環境のmaillogフォーマットと一致するか確認
- [ ] RFC 5424形式のsyslogが使用されている環境でのタイムスタンプ解析精度を確認
- [ ] zstd圧縮ログファイルの展開が実環境で正常動作するか確認
