---
generated_at: 2026-02-01 10:06:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：27-480.leapfile-ntpd.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **leapfileの出力パス**：ntpdの設定に依存しスクリプトから直接確認不可
  2. **外部サーバへのHTTP/HTTPS接続**：プロトコルはntpdのfetchサブコマンドの実装に依存

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/480.leapfile-ntpd`（バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf`（デフォルト設定ファイル）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | daily_ntpd_leapfile_enableのデフォルトはYES | E-02 (L172) | ○ |
| C-02 | anticongestion_sleeptimeのデフォルトは3600 | E-02 (L34) | ○ |
| C-03 | service ntpd enabledで有効性確認 | E-01 (L15) | ○ |
| C-04 | service ntpd needfetchで必要性確認 | E-01 (L15) | ○ |
| C-05 | anticongestion関数でランダムスリープ | E-01 (L16), E-02 (L349-L355) | ○ |
| C-06 | service ntpd fetchでleapfile取得 | E-01 (L17) | ○ |
| C-07 | periodic.confを読み込む | E-01 (L7-L11) | ○ |
| C-08 | YES/NO判定は大文字小文字不問 | E-01 (L14) | ○ |
| C-09 | exit $rcで終了 | E-01 (L22) | ○ |
| C-10 | rc変数が明示設定されないケースがある | E-01 (全体) | ○ |
| C-11 | anticongestionは対話実行時スリープスキップ | E-02 (L350) | ○ |
| C-12 | PERIODIC_ANTICONGESTION_FILE存在時のみスリープ | E-02 (L351-L353) | ○ |
| C-13 | leapfileの出力パスは/var/db/ntpd.leap-seconds.list等 | **根拠なし** | △ |
| C-14 | 外部サーバへのHTTP/HTTPS接続が発生 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- leapfileの実際の保存パスはntpd(8)のrc.dスクリプトおよびntp.confの設定に依存
  - 候補：/etc/rc.d/ntpd / ntp.conf / ntpd(8)マニュアル
- fetchで使用されるプロトコル・URLはntpdのサービススクリプトに実装されている
  - 候補：/etc/rc.d/ntpd / ntpd(8)マニュアル

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - leapfileの出力パスと通信プロトコルの詳細がスクリプト内から確認できない

## 6) レビュアーチェックリスト（最小）
- [ ] leapfileの実際の保存パスを/etc/rc.d/ntpdで確認
- [ ] service ntpd fetchが使用するURLとプロトコルを確認
- [ ] anticongestionのランダムスリープが運用上許容範囲か確認（最大3600秒）
