---
generated_at: 2026-02-01 10:07:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-480.status-ntpd.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/480.status-ntpd`（バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf`（デフォルト設定ファイル）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | daily_status_ntpd_enableのデフォルトはNO | E-02 (L175) | ○ |
| C-02 | ntpq -pnでNTPピア一覧を取得 | E-01 (L20) | ○ |
| C-03 | tee /dev/stderrで標準出力へ表示 | E-01 (L20) | ○ |
| C-04 | grep '^\*'で同期サーバを検索 | E-01 (L20) | ○ |
| C-05 | 同期サーバなし時rc=1 | E-01 (L22) | ○ |
| C-06 | rc=0を初期化 | E-01 (L13) | ○ |
| C-07 | periodic.confを読み込む | E-01 (L7-L11) | ○ |
| C-08 | ヘッダ"NTP status:"を出力 | E-01 (L18) | ○ |
| C-09 | YES/NO判定は大文字小文字不問 | E-01 (L16) | ○ |
| C-10 | 読み取り専用処理 | E-01 (全体) | ○ |
| C-11 | バッチ一覧でカテゴリはdaily/NTP | E-03 (L29) | ○ |
| C-12 | 同期サーバあり時rc=0のまま | E-01 (L13, L20-L23) | ○ |
| C-13 | -pフラグはピア一覧、-nフラグはDNS逆引き無効 | E-01 (L20) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] ntpqコマンドがntpdが停止している場合のエラーハンドリングを確認
- [ ] ntpq -pnの出力フォーマットがNTPバージョンにより異なるか確認
