---
generated_at: 2026-02-01 12:02:00
metrics:
  claims_total: 13
  claims_with_evidence: 11
  claims_without_evidence: 2
confidence_derived: 0.85
---

# 根拠レポート：3-120.clean-preserve バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：11 / 13、根拠なし：2
- 優先レビュー（高）
  1. **/var/preserveの業務目的（vi/exリカバリファイル）**：根拠不足
  2. **実行時刻の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/120.clean-preserve` （バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf` （periodic設定ファイル、66-68行目: 120.clean-preserve設定）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、4行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチの目的は/var/preserveの古いファイル削除 | E-01 (L4), E-03 | ○ |
| C-02 | デフォルトは有効（daily_clean_preserve_enable=YES） | E-02 (L66) | ○ |
| C-03 | デフォルト日数は7 | E-02 (L67) | ○ |
| C-04 | days未設定時はrc=2 | E-01 (L17-20) | ○ |
| C-05 | /var/preserve未存在時はrc=2 | E-01 (L22-25) | ○ |
| C-06 | cd /var/preserve失敗時はrc=3 | E-01 (L44-45) | ○ |
| C-07 | find . ! -name . -mtime +N -delete で削除 | E-01 (L40-41) | ○ |
| C-08 | verbose時にprint付き | E-01 (L33-38) | ○ |
| C-09 | 削除判定はmtimeのみ | E-01 (L40) | ○ |
| C-10 | periodic.confの読み込み | E-01 (L9-13) | ○ |
| C-11 | verbose設定のデフォルトはYES | E-02 (L68) | ○ |
| C-12 | /var/preserveはvi/exのリカバリファイル保存先 | **根拠なし** | △ |
| C-13 | 実行時刻はデフォルト毎日深夜 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- /var/preserveの用途（vi/exリカバリ）はFreeBSDの慣例的な知識であり、スクリプト内には記載されていない。
  - 候補：FreeBSD Handbook / hier(7) manページ / vi(1) manページ
- 実行時刻はcrontab設定に依存する。
  - 候補：/etc/crontab / periodic(8) manページ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードから直接確認可能
- 1: 中リスク - /var/preserveの用途記載は外部文献に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] /var/preserveの用途説明が正確か（hier(7)等で確認）
- [ ] 終了コードの分岐条件がソースコードと一致しているか
- [ ] mtimeのみの判定であることが正確か
