---
generated_at: 2026-02-01 10:09:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-510.status-world-kernel.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/510.status-world-kernel`（バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf`（デフォルト設定ファイル）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | daily_status_world_kernelのデフォルトはYES | E-02 (L182) | ○ |
| C-02 | 設定変数名は末尾に_enableがない | E-02 (L182), E-01 (L14) | ○ |
| C-03 | /usr/bin/uname -Uでユーザランドバージョン取得 | E-01 (L17) | ○ |
| C-04 | /usr/bin/uname -Kでカーネルバージョン取得 | E-01 (L18) | ○ |
| C-05 | いずれかが空の場合exit 0 | E-01 (L19) | ○ |
| C-06 | バージョン一致時"Userland and kernel are in sync."を出力 | E-01 (L28) | ○ |
| C-07 | バージョン不一致時"Userland and kernel are not in sync"を出力 | E-01 (L23) | ○ |
| C-08 | 不一致時に各バージョン値を表示 | E-01 (L24-L25) | ○ |
| C-09 | 不一致時rc=1 | E-01 (L26) | ○ |
| C-10 | 一致時rc=0（初期値） | E-01 (L16) | ○ |
| C-11 | periodic.confを読み込む | E-01 (L8-L12) | ○ |
| C-12 | ヘッダ"Checking userland and kernel versions:"を出力 | E-01 (L21) | ○ |
| C-13 | 無効時はrc=0で終了 | E-01 (L32) | ○ |
| C-14 | 2>/dev/nullでunameのエラーを抑制 | E-01 (L17-L18) | ○ |
| C-15 | バッチ一覧でカテゴリはdaily/ステータス確認 | E-03 (L31) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] uname -Uおよび-Kが実環境で正常に動作するか確認
- [ ] バージョン番号の形式が想定通りか確認
