---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：31-800.scrub-zfs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **実行時刻のデフォルト値（03:01）**：periodic.confの標準設定に依存するが、ソースコード内に明示的な記載なし
  2. **パフォーマンスへの影響記述**：一般的なZFS知識に基づく記述であり、本スクリプト固有の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `usr.sbin/periodic/etc/daily/800.scrub-zfs` （ソースコード、行1-109）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、行32）
- E-03: ソースコード内の変数定義 `daily_scrub_zfs_default_threshold=35`（行17）
- E-04: ソースコード内のcase文 `daily_scrub_zfs_enable`（行19）
- E-05: ソースコード内のプール状態チェック（行30-49）
- E-06: ソースコード内の閾値計算ロジック（行52-78）
- E-07: ソースコード内のスクラブ進行中チェック（行80-98）
- E-08: ソースコード内の終了コード定義（行28, 33, 43, 47, 91, 95, 105）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチはZFSプールのスクラブを実行する | E-01, E-02 | ○ |
| C-02 | デフォルト無効（daily_scrub_zfs_enable=NO） | E-02, E-04 | ○ |
| C-03 | デフォルト閾値は35日 | E-03 | ○ |
| C-04 | プール一覧はdaily_scrub_zfs_poolsまたはzpool listから取得 | E-01（行24-26） | ○ |
| C-05 | FAULTEDプールはスキップされる（rc=3） | E-05（行41-44） | ○ |
| C-06 | UNAVAILプールはスキップされる（rc=4） | E-05（行45-48） | ○ |
| C-07 | プール名の.:-は_に変換されて個別閾値が参照される | E-06（行52） | ○ |
| C-08 | 最終スクラブ日時はzpool historyから取得される | E-06（行57-64） | ○ |
| C-09 | 経過日数が閾値未満の場合はスキップされる | E-06（行74-78） | ○ |
| C-10 | スクラブ進行中の場合はスキップされる | E-07（行82-83） | ○ |
| C-11 | リシルバリング進行中の場合はスキップされる | E-07（行85-86） | ○ |
| C-12 | zpool scrubでスクラブを開始する | E-07（行90, 95） | ○ |
| C-13 | 存在しないプールはWARNING出力してrc=2 | E-05（行32-37） | ○ |
| C-14 | スクラブ未実行時はプール作成日時を代替使用する | E-06（行61-64） | ○ |
| C-15 | 終了コードは0,1,2,3,4を使用する | E-08 | ○ |
| C-16 | periodic.confとsource_periodic_confsで設定を読み込む | E-01（行11-14） | ○ |
| C-17 | 実行時刻はデフォルト03:01 | **根拠なし** | △ |
| C-18 | スクラブはバックグラウンドで実行されI/O負荷に影響する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: periodic dailyの実行時刻はcrontab設定に依存し、ソースコード内には記載されていない
  - 候補：/etc/crontab / /etc/defaults/periodic.conf / FreeBSD Handbook
- C-18: I/O負荷への影響はZFSの一般的な特性であり、本スクリプト固有の情報ではない
  - 候補：ZFSドキュメント / zpool(8) manページ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書全体としてソースコードとの整合性は高い
- 1: 中リスク - 実行時刻のデフォルト値は環境依存であり、確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] daily_scrub_zfs_default_threshold=35 がソースコードと一致するか確認
- [ ] プール状態チェック（FAULTED/UNAVAIL）の終了コードがソースコードと一致するか確認
- [ ] 閾値計算ロジック（プール名の変換規則含む）の記述が正確か確認
- [ ] 実行時刻のデフォルト値を実環境のcrontab設定で確認
