---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：34-310.locate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **週次実行の曜日（土曜日デフォルト）**：ソースコード内には曜日情報なし、crontab設定依存

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/weekly/310.locate` （ソースコード、行1-32）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、行35）
- E-03: ソースコード内のcase文 `weekly_locate_enable`（行12）
- E-04: ソースコード内のlocate.rc読み込み（行17）
- E-05: ソースコード内のFCODESデフォルト設定（行18）
- E-06: ソースコード内のファイル操作（touch/chown/chmod）（行21-23）
- E-07: ソースコード内のlocate.updatedb実行（行26）
- E-08: ソースコード内のchmod 444（行27）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | locateデータベースを再構築する | E-01, E-02 | ○ |
| C-02 | デフォルト有効（weekly_locate_enable=YES） | E-02, E-03 | ○ |
| C-03 | /etc/locate.rcから設定を読み込む | E-04 | ○ |
| C-04 | FCODESのデフォルトは/var/db/locate.database | E-05 | ○ |
| C-05 | touchでファイル作成し、chown nobodyで所有者変更 | E-06 | ○ |
| C-06 | chmod 644で書き込み可能に設定 | E-06（行23） | ○ |
| C-07 | nobody権限でnice -n 5でlocate.updatedbを実行 | E-07 | ○ |
| C-08 | 完了後にchmod 444で読み取り専用に設定 | E-08 | ○ |
| C-09 | 失敗時はrc=3 | E-06, E-07（行21-27の||演算子） | ○ |
| C-10 | periodic.confとsource_periodic_confsで設定を読み込む | E-01（行7-10） | ○ |
| C-11 | ルートディレクトリからスキャンが行われる | E-07（行25: cd /） | ○ |
| C-12 | su -fm nobodyで権限を切り替えて実行 | E-07 | ○ |
| C-13 | 実行曜日は土曜日がデフォルト | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: 週次periodicの実行曜日はcrontab設定に依存し、ソースコード内には記載されていない
  - 候補：/etc/crontab / periodic(8) manページ / FreeBSD Handbook

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い
- 1: 中リスク - locate.rcの内容によりスキャン範囲が変わるため、環境依存の動作がありうる

## 6) レビュアーチェックリスト（最小）
- [ ] FCODESのデフォルト値がソースコードと一致するか確認
- [ ] nobody権限での実行方法（su -fm nobody）がソースコードと一致するか確認
- [ ] nice値（5）がソースコードと一致するか確認
- [ ] パーミッション変更の手順（644→実行→444）がソースコードと一致するか確認
