---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：35-320.whatis

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **出力ファイルがバイナリとしているが形式の詳細は未確認**：makewhatis.localの出力形式はソースコード外の情報

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/weekly/320.whatis` （ソースコード、行1-50）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、行36）
- E-03: ソースコード内のcase文 `weekly_whatis_enable`（行13）
- E-04: ソースコード内のMANPATH取得（行18）
- E-05: ソースコード内のMANPATH空チェック（行21-23）
- E-06: ソースコード内のman_locales取得（行26）
- E-07: ソースコード内のmakewhatis.local実行（行31）
- E-08: ソースコード内のロケール別実行ループ（行34-41）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | whatisデータベースを再構築する | E-01, E-02 | ○ |
| C-02 | デフォルト有効（weekly_whatis_enable=YES） | E-02, E-03 | ○ |
| C-03 | manpath -qでMANPATHを取得する | E-04 | ○ |
| C-04 | MANPATHが空の場合はrc=3でエラー | E-05 | ○ |
| C-05 | manpathコマンドの失敗時はrc=3 | E-01（行19, 43-44） | ○ |
| C-06 | makewhatis.localでデフォルトDBを構築する | E-07 | ○ |
| C-07 | manpath -qLでロケール一覧を取得する | E-06 | ○ |
| C-08 | 各ロケールについてLC_ALL設定でmakewhatis.local -a -Lを実行 | E-08 | ○ |
| C-09 | ロケール別は-a（追記）オプションで実行される | E-08（行38） | ○ |
| C-10 | 失敗時はrc=3 | E-07, E-08（||演算子） | ○ |
| C-11 | periodic.confとsource_periodic_confsで設定を読み込む | E-01（行7-11） | ○ |
| C-12 | MANPATHはmanpath(1)により自動決定される | E-04 | ○ |
| C-13 | whatisデータベースの出力形式 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: whatisデータベースのファイル形式（バイナリか否か）はmakewhatis.localの実装に依存し、本スクリプト内では確認できない
  - 候補：makewhatis.local のソースコード / whatis(1) manページ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] manpath -q と manpath -qL の使い分けがソースコードと一致するか確認
- [ ] makewhatis.localの-a -Lオプションの使用がソースコードと一致するか確認
- [ ] ロケールループのLC_ALL設定方法がソースコードと一致するか確認
- [ ] エラーコードの割り当てがソースコードと一致するか確認
