---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：36-340.noid

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティリスクの説明（同一UID/GID再利用による意図しないアクセス）**：一般的なセキュリティ知識であり、スクリプト固有の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/weekly/340.noid` （ソースコード、行1-57）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、行37）
- E-03: ソースコード内のcase文 `weekly_noid_enable`（行13）
- E-04: ソースコード内のjail判定（行23）
- E-05: ソースコード内のjail除外リスト構築（行26-45）
- E-06: ソースコード内のfindコマンド（行47-50）
- E-07: ソースコード内の結果カウント処理（行50-51）
- E-08: ソースコード内のweekly_noid_dirs参照（行47）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 所有者不明ファイルを検索・報告する | E-01, E-02 | ○ |
| C-02 | デフォルト無効（weekly_noid_enable=NO） | E-02, E-03 | ○ |
| C-03 | sysctl security.jail.jailedでjail内判定を行う | E-04 | ○ |
| C-04 | jail外の場合、jail設定からpathを取得し除外リストを構築 | E-05 | ○ |
| C-05 | jail -f "$jail_conf" -e でjailパラメータを取得 | E-05（行31） | ○ |
| C-06 | find -H で-nouserと-nogroupのファイルを検索 | E-06 | ○ |
| C-07 | ! -fstype localでリモートファイルシステムを除外 | E-06（行48） | ○ |
| C-08 | weekly_noid_dirsのデフォルトは/ | E-08 | ○ |
| C-09 | 検出件数が1より大きい場合rc=1 | E-07 | ○ |
| C-10 | /etc/rc.subrを読み込みjail設定を取得 | E-05（行25-26） | ○ |
| C-11 | 出力はsed 's/^/ /'で先頭にスペース2個を追加 | E-06（行49） | ○ |
| C-12 | tee /dev/stderrで標準出力と標準エラーの両方に出力 | E-07（行50） | ○ |
| C-13 | periodic.confとsource_periodic_confsで設定を読み込む | E-01（行7-11） | ○ |
| C-14 | UID/GID再利用による意図しないアクセスのリスク | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: セキュリティリスクの記述は一般的なUNIXセキュリティ知識に基づくもので、本スクリプト内には記載されていない
  - 候補：FreeBSD Security Advisory / UNIX セキュリティベストプラクティス文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い
- 1: 中リスク - jail除外ロジックは複雑であり、jail_confの設定内容によって動作が変わる

## 6) レビュアーチェックリスト（最小）
- [ ] jail判定ロジック（sysctl security.jail.jailed）がソースコードと一致するか確認
- [ ] jail除外リストの構築方法がソースコードと一致するか確認
- [ ] findコマンドのオプション（-H, -nouser, -nogroup, ! -fstype local）がソースコードと一致するか確認
- [ ] 終了コード判定（$rc -gt 1 の場合 rc=1）がソースコードと一致するか確認
