---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：37-450.status-security

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **securityカテゴリが呼び出すスクリプト群（No.42-55）の範囲**：periodic securityの実行範囲はperiodic(8)の設定に依存し、本スクリプト内では特定できない

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/weekly/450.status-security` （ソースコード、行1-46）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、行38）
- E-03: ソースコード内のcase文 `weekly_status_security_enable`（行13）
- E-04: ソースコード内のinline設定処理（行18-21）
- E-05: ソースコード内のsecurity_outputエクスポート（行23）
- E-06: ソースコード内の出力モード分岐（行25-42）
- E-07: ソースコード内の一時ファイル処理（行27-35）
- E-08: ソースコード内のperiodic security実行（行29, 38, 41）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 週次セキュリティチェックスクリプト群を実行する | E-01, E-02 | ○ |
| C-02 | デフォルト有効（weekly_status_security_enable=YES） | E-02, E-03 | ○ |
| C-03 | inline=YESの場合、outputを空に設定する | E-04 | ○ |
| C-04 | security_output環境変数をエクスポートする | E-05 | ○ |
| C-05 | output空の場合、一時ファイルに出力しcatで標準出力に転送 | E-07 | ○ |
| C-06 | outputが/で始まる場合、"output logged separately"と表示 | E-06（行37-38） | ○ |
| C-07 | outputがその他の場合、"output mailed separately"と表示 | E-06（行40-41） | ○ |
| C-08 | periodic securityを実行する | E-08 | ○ |
| C-09 | 一時ファイルに内容がある場合rc=3 | E-07（行30-33） | ○ |
| C-10 | 一時ファイルはmktempで作成される | E-07（行27） | ○ |
| C-11 | 一時ファイルは処理後に削除される | E-07（行34） | ○ |
| C-12 | periodic.confとsource_periodic_confsで設定を読み込む | E-01（行7-11） | ○ |
| C-13 | securityカテゴリがNo.42-55のスクリプトを実行する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: periodic securityが呼び出す具体的なスクリプト群は本スクリプト外の設定に依存する。バッチ一覧からNo.42-55がsecurityカテゴリであることは確認できるが、periodic securityの実行範囲との対応は別途確認が必要
  - 候補：periodic(8) manページ / /etc/periodic/security/ ディレクトリの内容

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ラッパースクリプトとしてはシンプルで、設計書との整合性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] inline/output設定の優先順位がソースコードと一致するか確認
- [ ] 一時ファイルの作成・削除フローがソースコードと一致するか確認
- [ ] periodic securityの呼び出し方法がソースコードと一致するか確認
- [ ] 出力モードの3パターン分岐がソースコードと一致するか確認
