---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：38-999.local

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **No.33（daily/999.local）と同一ロジックであるとの記述**：両スクリプトのソース比較で確認可能だが、明示的な文書根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/weekly/999.local` （ソースコード、行1-39）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、行39）
- E-03: ソースコード内の$weekly_localループ（行14-37）
- E-04: ソースコード内の絶対パス判定（行18）
- E-05: ソースコード内の実行可能ファイル判定（行19-22）
- E-06: ソースコード内のshによる実行（行23-28）
- E-07: ソースコード内のエラー処理（行29-35）
- E-08: `usr.sbin/periodic/etc/daily/999.local` （比較対象ソースコード）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 週次ローカルカスタムスクリプトを実行するフレームワーク | E-01, E-02 | ○ |
| C-02 | $weekly_local変数でスクリプトパスを指定する | E-03 | ○ |
| C-03 | 絶対パスでない場合はエラー（rc=2） | E-04, E-07（行34-35） | ○ |
| C-04 | 実行可能ファイルは直接実行する | E-05 | ○ |
| C-05 | 通常ファイルはshで実行する | E-06 | ○ |
| C-06 | ファイル不在時はエラー出力（rc=2） | E-07（行30-31） | ○ |
| C-07 | スクリプト実行失敗時はrc=3 | E-05（行22）, E-06（行28） | ○ |
| C-08 | 有効/無効の制御変数はない | E-01（全体構造） | ○ |
| C-09 | 1つのスクリプト失敗でも残りは実行される | E-03（ループ構造） | ○ |
| C-10 | periodic.confとsource_periodic_confsで設定を読み込む | E-01（行7-11） | ○ |
| C-11 | No.33（daily/999.local）と同一のロジック構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-11: daily/999.localとweekly/999.localのソースコードを比較すると、変数名（daily_local vs weekly_local）以外は同一構造であることが確認できるが、これを公式に記述したドキュメントは存在しない
  - 候補：E-08のソースコード比較で実質的に確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなスクリプトであり、設計書との整合性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] $weekly_local変数の参照方法がソースコードと一致するか確認
- [ ] エラーコード（rc=2, rc=3）の割り当てがソースコードと一致するか確認
- [ ] daily/999.localとの差異が変数名のみであることを確認
