---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：39-200.accounting

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **utx.log.0が前月のデータを含むとの記述**：newsyslog(8)のローテーションタイミングに依存し、本スクリプト内では保証されない

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/monthly/200.accounting` （ソースコード、行1-64）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、行40）
- E-03: ソースコード内のcase文 `monthly_accounting_enable`（行15）
- E-04: ソースコード内のumask設定（行13, 63）
- E-05: ソースコード内のutx.logパス定義（行17）
- E-06: ソースコード内の圧縮ファイル判定（行23-43）
- E-07: ソースコード内のac -p -w実行（行55）
- E-08: ソースコード内のsort -nr -k 2（行55）
- E-09: ソースコード内の一時ファイル処理（行26, 58）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログインアカウンティング情報を集計・報告する | E-01, E-02 | ○ |
| C-02 | デフォルト有効（monthly_accounting_enable=YES） | E-02, E-03 | ○ |
| C-03 | umask 066を設定する | E-04（行13） | ○ |
| C-04 | /var/log/utx.log.0を入力として使用する | E-05 | ○ |
| C-05 | gzip圧縮版に対応（zcat） | E-06（行29-30） | ○ |
| C-06 | bzip2圧縮版に対応（bzcat） | E-06（行31-32） | ○ |
| C-07 | xz圧縮版に対応（xzcat） | E-06（行33-34） | ○ |
| C-08 | zstd圧縮版に対応（zstdcat） | E-06（行35-36） | ○ |
| C-09 | ac -p -wで各ユーザの接続時間を集計する | E-07 | ○ |
| C-10 | sort -nr -k 2で接続時間の降順でソートする | E-08 | ○ |
| C-11 | tee /dev/stderrで標準出力と標準エラーの両方に出力 | E-07（行55） | ○ |
| C-12 | 一時ファイルはmktempで作成し処理後に削除 | E-09 | ○ |
| C-13 | utx.log.0が存在しない場合はrc=2 | E-06（行45-47） | ○ |
| C-14 | umaskを処理後に元に戻す | E-04（行63） | ○ |
| C-15 | utx.log.0が前月のデータを含む | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: utx.log.0のローテーションタイミングはnewsyslog(8)の設定に依存し、本スクリプト内では「前月のデータ」であることを保証する記述はない
  - 候補：/etc/newsyslog.conf / newsyslog(8) manページ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い
- 1: 中リスク - 4種類の圧縮形式対応は正確だが、圧縮ツールの存在が前提となる

## 6) レビュアーチェックリスト（最小）
- [ ] umask 066の設定と復元がソースコードと一致するか確認
- [ ] 4種類の圧縮形式（gz/bz2/xz/zst）の処理順序がソースコードと一致するか確認
- [ ] ac -p -wコマンドのオプションがソースコードと一致するか確認
- [ ] ソート順序（-nr -k 2）がソースコードと一致するか確認
- [ ] 終了コードの割り当て（rc=0, 1, 2）がソースコードと一致するか確認
