---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：42-100.chksetuid バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の処理時間見積り**：「数分〜数十分」は推定値

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/security/100.chksetuid`（ソースコード）
- E-02: `usr.sbin/periodic/etc/security/security.functions`（共通関数ライブラリ）
- E-03: `usr.sbin/periodic/periodic.conf`（設定ファイル: 278-279行目）
- E-04: `usr.sbin/periodic/periodic.conf`（設定ファイル: 265-266行目、logdir/diff_flags）
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧: 43行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | check_yesno_periodで有効/無効判定を行う | E-01（41行目） | ○ |
| C-02 | デフォルトでYES、periodはdaily | E-03（278-279行目） | ○ |
| C-03 | security.functionsを読み込む | E-01（37行目） | ○ |
| C-04 | mount -t ufs,zfsでマウントポイント取得 | E-01（46行目） | ○ |
| C-05 | nosuid/noexecのマウントポイントを除外 | E-01（47行目: `$0 !~ /no(suid|exec)/`） | ○ |
| C-06 | find -sxでsetuid/setgidファイルを検索 | E-01（52-54行目） | ○ |
| C-07 | 実行権限とsetuid/setgidビットの組み合わせで検索 | E-01（53-54行目: `-perm -u+x -or -perm -g+x -or -perm -o+x` と `-perm -u+s -or -perm -g+s`） | ○ |
| C-08 | ls -lid -D "%FT%T"で詳細情報を出力 | E-01（54行目） | ○ |
| C-09 | check_diff関数で前回結果と比較 | E-01（55行目: `check_diff setuid - "${host} setuid diffs:"`) | ○ |
| C-10 | ログファイルはsetuid.today/setuid.yesterday | E-02（check_diff関数のlabel="setuid"から推定）, E-01 | ○ |
| C-11 | ログディレクトリのデフォルトは/var/log | E-04（265行目） | ○ |
| C-12 | diff_flagsのデフォルトは-b -U 0 | E-04（266行目） | ○ |
| C-13 | IFS=$'\n'でスペース含むマウントポイントを処理 | E-01（45行目） | ○ |
| C-14 | ! -fstype localで非ローカルFSを除外 | E-01（52行目） | ○ |
| C-15 | 処理時間はファイルシステムサイズに依存し数分〜数十分 | **根拠なし**（一般的な知識に基づく推定） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はベンチマーク結果が必要
  - 候補：実環境でのfindコマンド実行時間計測 / ファイルシステムサイズ情報

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードと完全に一致
- 0: 低リスク - 設定パラメータはperiodic.confと完全に一致
- 0: 低リスク - check_diff関数の動作はsecurity.functionsのソースで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] findコマンドのオプションがソースコードと一致しているか
- [ ] check_diff関数の動作（ファイルローテーション）がsecurity.functionsと一致しているか
- [ ] periodic.confのデフォルト値が最新のソースと一致しているか
