---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：43-110.neggrpperm バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の処理時間見積り**：「数分〜数十分」は推定値

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/security/110.neggrpperm`（ソースコード）
- E-02: `usr.sbin/periodic/periodic.conf`（設定ファイル: 282-283行目）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧: 44行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | check_yesno_periodで有効/無効判定を行う | E-01（39行目） | ○ |
| C-02 | デフォルトでYES、periodはdaily | E-02（282-283行目） | ○ |
| C-03 | mount -t ufs,zfsでマウントポイント取得 | E-01（44行目） | ○ |
| C-04 | nosuid/noexecのマウントポイントを除外 | E-01（45行目） | ○ |
| C-05 | グループ実行なしかつother実行ありを検出 | E-01（51行目: `! -perm +010 -and -perm +001`） | ○ |
| C-06 | グループ書込なしかつother書込ありを検出 | E-01（52行目: `! -perm +020 -and -perm +002`） | ○ |
| C-07 | グループ読取なしかつother読取ありを検出 | E-01（53行目: `! -perm +040 -and -perm +004`） | ○ |
| C-08 | ls -lid -D "%FT%T"で詳細情報を出力 | E-01（54行目） | ○ |
| C-09 | tee /dev/stderrで標準エラー出力にも出力 | E-01（54行目） | ○ |
| C-10 | wc -lで件数をカウントしrc判定 | E-01（55行目） | ○ |
| C-11 | check_diff関数は使用しない | E-01（security.functionsのソース読み込みなし） | ○ |
| C-12 | バッチ一覧との記載が一致 | E-03（44行目） | ○ |
| C-13 | 処理時間はファイルシステムサイズに依存し数分〜数十分 | **根拠なし**（推定） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はベンチマーク結果が必要
  - 候補：実環境でのfindコマンド実行時間計測

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードと完全に一致
- 0: 低リスク - パーミッション検査条件はソースコードから正確に抽出
- 0: 低リスク - check_diffを使用しないことをソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] findコマンドのパーミッション検査条件がソースコードと一致しているか
- [ ] check_diffを使用しないという記述が正しいか（security.functionsのソース参照なし）
- [ ] periodic.confのデフォルト値が最新のソースと一致しているか
