---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-200.chkmounts バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/security/200.chkmounts`（ソースコード）
- E-02: `usr.sbin/periodic/etc/security/security.functions`（共通関数ライブラリ）
- E-03: `usr.sbin/periodic/periodic.conf`（設定ファイル: 286-290行目）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧: 45行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | check_yesno_periodで有効/無効判定を行う | E-01（45行目） | ○ |
| C-02 | デフォルトでYES、periodはdaily | E-03（286-287行目） | ○ |
| C-03 | security.functionsを読み込む | E-01（40行目） | ○ |
| C-04 | security_status_chkmounts_ignore変数で除外パターンを設定 | E-01（42行目）, E-03（288行目） | ○ |
| C-05 | security_status_noamd=YESでamdマウントを除外 | E-01（47-50行目）, E-03（290行目） | ○ |
| C-06 | /etc/fstabが存在しない場合PATH_FSTAB=/dev/null | E-01（52-54行目） | ○ |
| C-07 | mount -pでfstab形式のマウント情報を取得 | E-01（55行目） | ○ |
| C-08 | sort でソートする | E-01（55行目） | ○ |
| C-09 | egrep -vで除外パターンを適用 | E-01（51行目） | ○ |
| C-10 | check_diff mount で前回結果と比較 | E-01（56行目） | ○ |
| C-11 | ログファイルはmount.today/mount.yesterday | E-02（check_diff関数のlabel="mount"から推定）, E-01 | ○ |
| C-12 | 差分検出時のメッセージ | E-01（56行目: `"${host} changes in mounted filesystems:"`) | ○ |
| C-13 | 除外パターンが空の場合はcatでフィルタなし | E-01（51行目: `cmd=cat`） | ○ |
| C-14 | バッチ一覧との記載が一致 | E-04（45行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 全主張に根拠が存在するため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードと完全に一致
- 0: 低リスク - 設定パラメータはperiodic.confと完全に一致
- 0: 低リスク - check_diff関数の動作はsecurity.functionsで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] mount -pの出力形式とフィルタリングロジックがソースと一致しているか
- [ ] /etc/fstab不在時のフォールバック処理が正しく記述されているか
- [ ] periodic.confのデフォルト値が最新のソースと一致しているか
