---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：47-410.logincheck バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **正常時の期待所有権**：root:wheelが期待されるという記述はソースコードから直接確認不可

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/security/410.logincheck`（ソースコード）
- E-02: `usr.sbin/periodic/periodic.conf`（設定ファイル: 301-302行目）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧: 48行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | check_yesno_periodで有効/無効判定を行う | E-01（39行目） | ○ |
| C-02 | デフォルトでYES、periodはdaily | E-02（301-302行目） | ○ |
| C-03 | -Gテストでグループ所有権を検証 | E-01（43行目: `-G /etc/login.conf`） | ○ |
| C-04 | -Oテストでユーザ所有権を検証 | E-01（43行目: `-O /etc/login.conf`） | ○ |
| C-05 | 両テスト合格でn=0、不合格でn=1 | E-01（43-48行目） | ○ |
| C-06 | 不合格時に "Bad ownership of /etc/login.conf" を出力 | E-01（46行目） | ○ |
| C-07 | n > 0 でrc=1 | E-01（49行目） | ○ |
| C-08 | 開始メッセージ "Checking login.conf permissions:" | E-01（42行目） | ○ |
| C-09 | バッチ一覧との記載が一致 | E-03（48行目） | ○ |
| C-10 | 正常時の所有権はroot:wheelが期待される | **根拠なし**（FreeBSDの一般的な知識に基づく推定） | △ |

## 4) 不足情報（Unknown / Missing）
- /etc/login.confの標準的な所有権はFreeBSDインストール仕様に依存
  - 候補：FreeBSD installation scripts / mtree manifest / pkg-plist

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードと完全に一致
- 1: 中リスク - 期待される所有権の具体値（root:wheel）は環境確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] -G/-Oテストの動作がソースコードと一致しているか
- [ ] /etc/login.confの期待される所有権がターゲット環境で正しいか
- [ ] periodic.confのデフォルト値が最新のソースと一致しているか
