---
generated_at: 2026-02-01 12:04:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：5-140.clean-rwho バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **rwho(1)/rwhod(8)の業務目的説明**：根拠不足
  2. **rwhoのセキュリティ上の推奨事項**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/140.clean-rwho` （バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf` （periodic設定ファイル、75-77行目: 140.clean-rwho設定）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、6行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチの目的は/var/rwhoの古いファイル削除 | E-01 (L4), E-03 | ○ |
| C-02 | デフォルトは有効（daily_clean_rwho_enable=YES） | E-02 (L75) | ○ |
| C-03 | デフォルト日数は7 | E-02 (L76) | ○ |
| C-04 | verbose設定のデフォルトはYES | E-02 (L77) | ○ |
| C-05 | days未設定時はrc=2 | E-01 (L17-20) | ○ |
| C-06 | /var/rwho未存在時はrc=2 | E-01 (L22-25) | ○ |
| C-07 | cd /var/rwho失敗時はrc=3 | E-01 (L45-46) | ○ |
| C-08 | find . ! -name . -mtime +N -delete で削除 | E-01 (L40-41) | ○ |
| C-09 | verbose時にprint付き | E-01 (L31-36) | ○ |
| C-10 | 削除判定はmtimeのみ | E-01 (L40) | ○ |
| C-11 | periodic.confの読み込み | E-01 (L9-13) | ○ |
| C-12 | 構造は120.clean-preserveとほぼ同一 | E-01全体 | ○ |
| C-13 | rwho(1)はLAN上のユーザログイン状況を共有する仕組み | **根拠なし** | △ |
| C-14 | rwhoはセキュリティ上使用が推奨されない場合がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- rwho(1)/rwhod(8)の用途説明はスクリプト内には記載されていない。
  - 候補：rwho(1) manページ / rwhod(8) manページ / FreeBSD Handbook
- rwhoのセキュリティ上の推奨事項はFreeBSDコミュニティの一般的知識に基づく。
  - 候補：セキュリティガイドライン / FreeBSD Security Advisory

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードから直接確認可能
- 1: 中リスク - rwhoの業務説明・セキュリティ記載は外部文献に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] rwho(1)の用途説明が正確か
- [ ] 120.clean-preserveとの構造的類似性の記載が正確か
- [ ] 終了コードの分岐条件がソースコードと一致しているか
