---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-520.pfdenied バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/security/520.pfdenied`（ソースコード）
- E-02: `usr.sbin/periodic/etc/security/security.functions`（共通関数ライブラリ）
- E-03: `usr.sbin/periodic/periodic.conf`（設定ファイル: 313-315行目）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧: 51行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | check_yesno_periodで有効/無効判定を行う | E-01（41行目） | ○ |
| C-02 | デフォルトでYES、periodはdaily | E-03（313-314行目） | ○ |
| C-03 | security.functionsを読み込む | E-01（37行目） | ○ |
| C-04 | mktemp -t securityで一時ファイル作成 | E-01（43行目） | ○ |
| C-05 | メインルールセットとアンカーをループで処理 | E-01（44行目: `for _a in "" $(pfctl ...) ...`） | ○ |
| C-06 | blacklistdアンカーのサブアンカーを列挙 | E-01（44行目: `pfctl -a "blacklistd" -sA`） | ○ |
| C-07 | blocklistdアンカーのサブアンカーを列挙 | E-01（44行目: `pfctl -a "blocklistd" -sA`） | ○ |
| C-08 | security_status_pfdenied_additionalanchorsで追加アンカー指定 | E-01（44行目）, E-03（315行目） | ○ |
| C-09 | pfctl -a -sr -v -zでルール取得しカウンタリセット | E-01（46行目） | ○ |
| C-10 | nawkでblockルールのヒットカウント>0を抽出 | E-01（47行目） | ○ |
| C-11 | nawkの処理: blockルール行を検出し次行の第5フィールドを確認 | E-01（47行目: `if (/^block/) {buf=$0; getline; gsub(...); if ($5 > 0) print buf$0;}`) | ○ |
| C-12 | -sでファイルサイズ確認してからcheck_diff | E-01（49行目: `if [ -s ${TMP} ]`） | ○ |
| C-13 | check_diff new_only pfで差分検出 | E-01（50行目） | ○ |
| C-14 | 一時ファイルは処理完了後に削除 | E-01（53行目: `rm -f ${TMP}`） | ○ |
| C-15 | -zオプションによりカウンタがリセットされる | E-01（46行目: `-z`フラグ） | ○ |
| C-16 | バッチ一覧との記載が一致 | E-04（51行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 全主張に根拠が存在するため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードと完全に一致
- 1: 中リスク - -zオプションによるカウンタリセットの副作用に注意（他の監視ツールとの競合可能性）
- 0: 低リスク - blacklistd/blocklistd両方のアンカー対応を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] pfctlコマンドのオプションとnawkの抽出条件がソースと一致しているか
- [ ] blacklistd/blocklistdの両アンカー対応が正しく記述されているか
- [ ] -zオプションによるカウンタリセットの影響が適切に記述されているか
- [ ] periodic.confのデフォルト値が最新のソースと一致しているか
