---
generated_at: 2026-02-01 12:05:00
metrics:
  claims_total: 19
  claims_with_evidence: 17
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：52-610.ipf6denied

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：17 / 19、根拠なし：2
- 優先レビュー（高）
  1. **ipfstat -nhio6 のオプション説明**：man ページ未参照
  2. **パフォーマンス要件の処理時間**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/security/610.ipf6denied`（ソースコード）
- E-02: `usr.sbin/periodic/periodic.conf`（設定ファイル、321-323行）
- E-03: `usr.sbin/periodic/etc/security/security.functions`（共通関数）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧、53行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IPv6 向け ipf の拒否パケットログを確認・報告する | E-01（コメント行なし、44行目処理）、E-04 | ○ |
| C-02 | デフォルト有効（security_status_ipf6denied_enable=YES） | E-02（322行目） | ○ |
| C-03 | 実行期間はデフォルト daily | E-02（323行目） | ○ |
| C-04 | check_yesno_period で有効/無効を判定 | E-01（41行目） | ○ |
| C-05 | security.functions を読み込む | E-01（37行目） | ○ |
| C-06 | ipfstat -nhio6 で統計情報を取得 | E-01（44行目） | ○ |
| C-07 | grep block で拒否ルールをフィルタ | E-01（44行目） | ○ |
| C-08 | check_diff new_only ipf6 で差分検出 | E-01（45行目） | ○ |
| C-09 | 一時ファイルを mktemp で作成 | E-01（43行目） | ○ |
| C-10 | 一時ファイルを処理後に rm -f で削除 | E-01（48行目） | ○ |
| C-11 | /var/log/ipf6.today に最新結果を保存 | E-03（check_diff 関数、68-78行目） | ○ |
| C-12 | /var/log/ipf6.yesterday に前回結果を退避 | E-03（check_diff 関数、77行目） | ○ |
| C-13 | 終了コード 3 はファイル操作エラー | E-03（check_diff 関数、68行目、78行目） | ○ |
| C-14 | check_diff new_only は新規追加分のみ表示 | E-03（49-54行目、filter="grep '^[>+][^+]'"） | ○ |
| C-15 | security_status_logdir のデフォルトは /var/log | E-02（265行目） | ○ |
| C-16 | security_status_diff_flags のデフォルトは "-b -U 0" | E-02（266行目） | ○ |
| C-17 | ipfstat 失敗時は stderr を /dev/null にリダイレクト | E-01（44行目、`2>/dev/null`） | ○ |
| C-18 | ipfstat のオプション -n,-h,-i,-o,-6 の意味 | **根拠なし** | △ |
| C-19 | 処理時間は数秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: ipfstat のオプション説明は man ページ（ipfstat(8)）から確認すべきだが、本プロジェクト内に man ページソースは検索対象外とした
  - 候補：ipfstat(8) man ページ / ipf(8) ドキュメント
- C-19: パフォーマンス要件は明示的な定義が存在しない
  - 候補：運用実績データ / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のセキュリティ監査スクリプト。ファイル更新は状態管理用のみ

## 6) レビュアーチェックリスト（最小）
- [ ] ipfstat -nhio6 の各オプションの意味が正しいか man ページで確認
- [ ] check_diff 関数のファイルローテーション（today/yesterday）が正しく動作するか確認
- [ ] ipf 未ロード時のフォールバック動作（stderr 抑制 + grep 空出力）が適切か確認
