---
generated_at: 2026-02-01 12:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：54-800.loginfail

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **SSH ブルートフォース攻撃への有効性の記載**：一般的な用途の推定
  2. **パフォーマンス要件の処理時間**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/security/800.loginfail`（ソースコード）
- E-02: `usr.sbin/periodic/periodic.conf`（設定ファイル、265行、329-331行）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧、55行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン失敗を確認・報告する | E-01（29行目コメント）、E-03 | ○ |
| C-02 | デフォルト有効（security_status_loginfail_enable=YES） | E-02（330行目） | ○ |
| C-03 | 実行期間はデフォルト daily | E-02（331行目） | ○ |
| C-04 | check_yesno_period で有効/無効を判定 | E-01（63行目） | ○ |
| C-05 | LOG 変数に security_status_logdir を設定 | E-01（40行目） | ○ |
| C-06 | RFC 3164 形式の日付パターンを生成 | E-01（43-44行目） | ○ |
| C-07 | RFC 5424 形式の日付パターンを生成 | E-01（46-47行目） | ○ |
| C-08 | 両形式を OR 結合した正規表現パターンを構成 | E-01（49行目） | ○ |
| C-09 | catmsgs 関数で auth.log.* を mtime -2 で検索 | E-01（52行目） | ○ |
| C-10 | sort -t. -r -n -k 2,2 で番号降順ソート | E-01（53行目） | ○ |
| C-11 | zcat -f で圧縮ファイルも含めて展開 | E-01（56行目） | ○ |
| C-12 | auth.log が存在すれば cat で出力 | E-01（58行目） | ○ |
| C-13 | egrep -ia でログイン失敗キーワードを検索 | E-01（67行目） | ○ |
| C-14 | 失敗キーワード: fail, failures, failed, invalid, bad, illegal, auth.*error | E-01（67行目） | ○ |
| C-15 | tee /dev/stderr で結果表示と wc -l でカウント | E-01（68行目） | ○ |
| C-16 | 件数 > 0 で rc=1、それ以外で rc=0 | E-01（69行目） | ○ |
| C-17 | "{host} login failures:" ヘッダを出力 | E-01（66行目） | ○ |
| C-18 | date -v-1d は前日の日付を生成する | E-01（43行目、46行目） | ○ |
| C-19 | security_status_logdir のデフォルトは /var/log | E-02（265行目） | ○ |
| C-20 | 空行を出力してからヘッダを表示 | E-01（65行目） | ○ |
| C-21 | SSH ブルートフォース攻撃の検出に有効 | **根拠なし** | △ |
| C-22 | 処理時間は数秒〜数十秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-21: SSH ブルートフォース攻撃への有効性は、egrep パターンが "fail" 等のキーワードを含むことから推定したものであり、本バッチのドキュメントに明示的な記載はない
  - 候補：FreeBSD セキュリティドキュメント / periodic.conf(5) man ページ
- C-22: 処理時間はログサイズに依存するが、明示的なパフォーマンス要件は定義されていない
  - 候補：運用実績データ / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のセキュリティ監査スクリプト。ログファイルの読み取りのみ

## 6) レビュアーチェックリスト（最小）
- [ ] egrep パターンがすべてのログイン失敗形式（SSH, login, su, sudo 等）を適切に捕捉するか確認
- [ ] RFC 5424 形式の正規表現パターンが実際の syslog 出力と一致するか確認
- [ ] ログローテーション（auth.log.* の mtime -2）で前日分のログが漏れなく取得できるか確認
- [ ] tee /dev/stderr の出力が periodic レポートに正しく含まれるか確認
