---
generated_at: 2026-02-01 12:05:00
metrics:
  claims_total: 13
  claims_with_evidence: 11
  claims_without_evidence: 2
confidence_derived: 0.85
---

# 根拠レポート：6-150.clean-hoststat バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：11 / 13、根拠なし：2
- 優先レビュー（高）
  1. **sendmailホストステータスキャッシュの業務説明**：根拠不足
  2. **purgestatの内部排他制御に関する記載**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/150.clean-hoststat` （バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf` （periodic設定ファイル、80-81行目: 150.clean-hoststat設定）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、7行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチの目的はsendmailホストステータスキャッシュのパージ | E-01 (L4), E-03 | ○ |
| C-02 | デフォルトは有効（daily_clean_hoststat_enable=YES） | E-02 (L80) | ○ |
| C-03 | /etc/mail/mailer.confにpurgestatが定義されているか確認 | E-01 (L16) | ○ |
| C-04 | purgestat未定義時はrc=3 | E-01 (L17) | ○ |
| C-05 | hoststatの出力が空の場合はrc=2 | E-01 (L18-19) | ○ |
| C-06 | purgestatコマンドで削除実行 | E-01 (L24) | ○ |
| C-07 | purgestat成功時rc=0、失敗時rc=1 | E-01 (L23-24) | ○ |
| C-08 | periodic.confの読み込み | E-01 (L9-12) | ○ |
| C-09 | case文でYES判定 | E-01 (L14-15) | ○ |
| C-10 | 開始ログ "Removing stale entries from sendmail host status cache:" | E-01 (L22) | ○ |
| C-11 | sendmail以外のMTA使用環境ではrc=3で正常スキップ | E-01 (L16-17) | ○ |
| C-12 | ホストステータスキャッシュの業務説明（配送再試行最適化） | **根拠なし** | △ |
| C-13 | purgestat/hoststatコマンド内部でsendmailとの排他制御が行われる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ホストステータスキャッシュの動作と業務上の目的はsendmailの仕様に基づく知識であり、スクリプト内には記載されていない。
  - 候補：sendmail(8) manページ / sendmail Configuration Documentation
- purgestat/hoststatの内部動作（排他制御含む）はスクリプトからは確認できない。
  - 候補：sendmail(8) manページ / sendmailソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードから直接確認可能
- 1: 中リスク - sendmailの業務説明・排他制御記載は外部文献に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] sendmailホストステータスキャッシュの説明が正確か
- [ ] purgestat/hoststatの動作説明が正確か
- [ ] grep -qの使い方が正確に記載されているか
- [ ] sendmail以外のMTA環境での挙動が正確か
