---
generated_at: 2026-02-01 12:06:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：7-200.backup-passwd バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **passwd/groupの不正変更によるセキュリティリスクの説明**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/200.backup-passwd` （バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf` （periodic設定ファイル、83-84行目: 200.backup-passwd設定、43行目: daily_diff_flags）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、8行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチの目的はpasswd/groupのバックアップと差分検出 | E-01, E-03 | ○ |
| C-02 | デフォルトは有効（daily_backup_passwd_enable=YES） | E-02 (L84) | ○ |
| C-03 | daily_diff_flagsのデフォルトは -b -U 0 | E-02 (L43) | ○ |
| C-04 | /etc/master.passwd未存在時はrc=2 | E-01 (L15-19) | ○ |
| C-05 | /etc/group未存在時はrc=2 | E-01 (L20-24) | ○ |
| C-06 | バックアップ先は/var/backups | E-01 (L26) | ○ |
| C-07 | master.passwd.bak未存在時は新規作成 | E-01 (L32-37) | ○ |
| C-08 | cmpで差分比較 | E-01 (L39) | ○ |
| C-09 | 差分ありの場合diff出力、ローテーション、新規バックアップ | E-01 (L41-47) | ○ |
| C-10 | パスワードフィールドのマスク処理（sedで (password) に置換） | E-01 (L44) | ○ |
| C-11 | コメント行の変更はdiffから除外（-I '^#'） | E-01 (L43) | ○ |
| C-12 | group.bakについても同様の処理 | E-01 (L49-63) | ○ |
| C-13 | chkgrpによるgroup構文検証 | E-01 (L66-70) | ○ |
| C-14 | バックアップは2世代保持（.bak, .bak2） | E-01 (L45-46, L61-62) | ○ |
| C-15 | cp -p でパーミッション保持 | E-01 (L36, L46, L53, L63) | ○ |
| C-16 | periodic.confの読み込み | E-01 (L7-11) | ○ |
| C-17 | 差分検出時のメッセージ "$host passwd diffs:" / "$host group diffs:" | E-01 (L43, L60) | ○ |
| C-18 | passwd/groupの不正変更がセキュリティインシデントにつながる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティインシデントへのリスク説明は一般的なセキュリティ知識に基づくものであり、スクリプト内には記載されていない。
  - 候補：FreeBSD Security Guide / CIS Benchmark

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードから詳細に確認可能
- 0: 低リスク - パスワードマスク処理もソースから確認可能
- 0: 低リスク - セキュリティに関する記載は一般的知識の範囲

## 6) レビュアーチェックリスト（最小）
- [ ] パスワードマスク処理のsed式が正確に記載されているか
- [ ] -I '^#' によるコメント行除外が正確か
- [ ] chkgrpコマンドの動作説明が正確か
- [ ] バックアップローテーションのロジックが正確か
