---
generated_at: 2026-02-01 12:08:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：9-221.backup-gpart バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **gpart restoreによる復元可能性の記載**：根拠不足
  2. **パフォーマンス要件（EFIバックアップ含む場合のI/O時間）**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/221.backup-gpart` （バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf` （periodic設定ファイル、90-97行目: 221.backup-gpart設定）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、10行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチの目的はパーティションレイアウトのバックアップ | E-01 (L4-6), E-03 | ○ |
| C-02 | jail外ではデフォルト有効、jail内ではデフォルト無効 | E-02 (L90-95) | ○ |
| C-03 | daily_backup_gpart_verboseのデフォルトはNO | E-02 (L96) | ○ |
| C-04 | daily_backup_efi_enableのデフォルトはNO | E-02 (L97) | ○ |
| C-05 | kern.geom.conftxtのバックアップ | E-01 (L49-51) | ○ |
| C-06 | gpart showでデバイス列挙 | E-01 (L53) | ○ |
| C-07 | daily_backup_gpart_excludeによる除外 | E-01 (L54-56) | ○ |
| C-08 | ディスク未検出時はrc=2 | E-01 (L58-62) | ○ |
| C-09 | 各デバイスのgpart backupの実行 | E-01 (L66-71) | ○ |
| C-10 | ブートパーティションのddバックアップ | E-01 (L73-84) | ○ |
| C-11 | MBRレコードのddバックアップ（bs=512 count=1） | E-01 (L86-96) | ○ |
| C-12 | EFIパーティションのddバックアップ | E-01 (L105-120) | ○ |
| C-13 | rotate関数によるバックアップ管理 | E-01 (L19-39) | ○ |
| C-14 | デバイス名の特殊文字をtr変換 | E-01 (L68) | ○ |
| C-15 | verbose時にdiff出力 | E-01 (L30) | ○ |
| C-16 | バックアップは2世代保持（.bak, .bak2） | E-01 (L31-32) | ○ |
| C-17 | Created by Miroslav Lachman | E-01 (L2) | ○ |
| C-18 | periodic.confの読み込み | E-01 (L11-15) | ○ |
| C-19 | gpart restoreで復元可能 | **根拠なし** | △ |
| C-20 | EFIバックアップ含む場合のI/O時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- gpart restoreによる復元可能性はgpart(8)の仕様に基づく知識であり、スクリプト内には記載されていない。
  - 候補：gpart(8) manページ / FreeBSD Handbook
- EFIバックアップのI/O時間はディスク性能に依存し、推定値として記載した。
  - 候補：実運用ベンチマーク / ディスクI/O仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要ロジックはソースコードから詳細に確認可能
- 0: 低リスク - rotate関数のロジックも明確
- 1: 中リスク - gpart restoreの復元手順は外部文献に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] rotate関数のロジック（.tmp -> .bak -> .bak2）が正確か
- [ ] gpart show のawkパターンが正確に記載されているか
- [ ] ブートパーティション検出の条件（bios-boot/freebsd-boot）が正確か
- [ ] MBRバックアップのddパラメータ（bs=512 count=1）が正確か
- [ ] EFIパーティション処理の条件が正確か
