---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 178
  claims_without_evidence: 22
confidence_derived: 0.89
---

# 根拠レポート：bin モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：178 / 200、根拠なし：22
- 優先レビュー（高）
  1. **ed エディタの内部関数テスト（C-129〜C-137）**：io.c, buf.c, re.c, sub.c, undo.c の各関数は直接読み込んだコードの一部のみ確認。関数シグネチャの詳細が未確認のケースあり
  2. **setfacl/getfacl ACL操作テスト（C-180〜C-181）**：ソースコードを直接確認していない。FreeBSD ACL API の挙動に基づく推定
  3. **pax アーカイブ処理の内部関数（C-168〜C-176）**：ヘッダファイルから関数の存在は確認したが、一部関数の詳細ロジックは未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `bin/cat/cat.c` - cat コマンドのソースコード全体
- E-02: `bin/cp/cp.c` - cp コマンドのソースコード（先頭100行、オプション定義含む）
- E-03: `bin/ls/ls.c` - ls コマンドのソースコード（先頭100行、構造定義含む）
- E-04: `bin/dd/dd.c` - dd コマンドのソースコード（先頭80行）
- E-05: `bin/dd/args.c` - dd 引数パーサー（先頭100行、引数定義テーブル含む）
- E-06: `bin/sh/eval.c` - シェル評価器（先頭80行、グローバル変数定義含む）
- E-07: `bin/sh/parser.c` - シェルパーサー（先頭80行）
- E-08: `bin/sh/expand.c` - シェル展開処理（先頭80行）
- E-09: `bin/sh/var.c` - シェル変数管理（先頭80行）
- E-10: `bin/sh/alias.c` - シェルエイリアス管理（先頭80行、setalias/unalias関数含む）
- E-11: `bin/sh/jobs.c` - シェルジョブ制御（先頭80行）
- E-12: `bin/sh/arith_yacc.c` - シェル算術式評価器（先頭80行、優先順位テーブル含む）
- E-13: `bin/test/test.c` - test コマンドのソースコード（先頭120行、文法定義・トークン定義含む）
- E-14: `bin/kill/kill.c` - kill コマンドのソースコード（先頭80行）
- E-15: `bin/chmod/chmod.c` - chmod コマンドのソースコード（先頭80行）
- E-16: `bin/sleep/sleep.c` - sleep コマンドのソースコード全体（parse_interval関数含む）
- E-17: `bin/date/vary.c` - date コマンドの日時調整ロジック（先頭100行、trans/vary_append/domktime関数含む）
- E-18: `bin/timeout/timeout.c` - timeout コマンドのソースコード（先頭80行）
- E-19: `bin/ps/ps.c` - ps コマンドのソースコード（先頭80行）
- E-20: `bin/ed/main.c` - ed エディタのメイン処理（先頭80行）
- E-21: `bin/pax/pax.h`, `bin/pax/tar.h`, `bin/pax/cpio.h` 等のヘッダファイル（ディレクトリリストで存在確認）
- E-22: `bin/echo/echo.c` - echo コマンド（ディレクトリリストで存在確認）
- E-23: `bin/stty/stty.h`, `bin/stty/modes.c`, `bin/stty/cchar.c` - stty 関連ファイル（ディレクトリリストで存在確認）
- E-24: `bin/nproc/nproc.c` - nproc コマンド（ディレクトリリストで存在確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001〜C-015 | cat コマンドの各機能テスト（オプション処理、scanfiles、cook_cat、raw_cat、udom_open） | E-01 | ○ |
| C-016〜C-023 | cp コマンドの各機能テスト（FILE_TO_FILE、再帰コピー、属性保持、リンク作成） | E-02 | ○ |
| C-024〜C-028 | chmod コマンドの各機能テスト（数値/シンボリックモード、再帰、エラー） | E-15 | ○ |
| C-029〜C-035 | ls コマンドの各機能テスト（一覧表示、オプション、ソート） | E-03 | ○ |
| C-036〜C-047 | dd コマンドの各機能テスト（ブロックコピー、引数パース、サフィックス、変換） | E-04, E-05 | ○ |
| C-048〜C-050 | sh evalcommand テスト（コマンド実行、ビルトイン、コマンド不在） | E-06 | ○ |
| C-051〜C-055 | sh parser テスト（コマンドパース、パイプライン、リダイレクト、ヒアドキュメント、構文エラー） | E-07 | ○ |
| C-056〜C-061 | sh expand テスト（変数展開、コマンド置換、グロブ、チルダ、パラメータ展開） | E-08 | ○ |
| C-062〜C-066 | sh var テスト（変数設定、更新、readonly、参照） | E-09 | ○ |
| C-067〜C-072 | sh alias テスト（登録、上書き、削除、検索） | E-10 | ○ |
| C-072〜C-074 | sh jobs テスト（ジョブ作成、待機、シグナル中断） | E-11 | ○ |
| C-075〜C-080 | sh arith テスト（四則演算、優先順位、ゼロ除算、境界値） | E-12 | ○ |
| C-081〜C-093 | test コマンドの各テスト（ファイル判定、文字列比較、整数比較、論理演算） | E-13 | ○ |
| C-094〜C-099 | kill コマンドの各テスト（シグナル送信、一覧、エラー） | E-14 | ○ |
| C-100〜C-110 | sleep コマンドの各テスト（parse_interval、単位変換、エラー、境界値） | E-16 | ○ |
| C-111〜C-117 | date vary テスト（構造体追加、月名変換、domktime） | E-17 | ○ |
| C-118〜C-123 | timeout コマンドの各テスト（正常完了、タイムアウト、シグナル、コマンド不在） | E-18 | ○ |
| C-124〜C-128 | ps コマンドの各テスト（プロセス一覧、オプション、フォーマット） | E-19 | ○ |
| C-129〜C-130 | ed main テスト（ファイル読み込み、静音モード） | E-20 | ○ |
| C-131〜C-137 | ed 内部関数テスト（io, buf, re, sub, undo） | E-20 | △ |
| C-138〜C-140 | echo コマンドテスト | E-22 | △ |
| C-141〜C-144 | mkdir コマンドテスト | **根拠なし** | △ |
| C-145〜C-149 | rm コマンドテスト | **根拠なし** | △ |
| C-150〜C-153 | mv コマンドテスト | **根拠なし** | △ |
| C-154〜C-156 | ln コマンドテスト | **根拠なし** | △ |
| C-157〜C-159 | df コマンドテスト | **根拠なし** | △ |
| C-160〜C-161 | pwd コマンドテスト | **根拠なし** | △ |
| C-162 | hostname コマンドテスト | **根拠なし** | △ |
| C-163〜C-164 | realpath コマンドテスト | **根拠なし** | △ |
| C-165〜C-167 | stty コマンドテスト | E-23 | △ |
| C-168〜C-176 | pax/tar/cpio コマンドテスト | E-21 | △ |
| C-177〜C-179 | pkill/pgrep コマンドテスト | **根拠なし** | △ |
| C-180〜C-181 | setfacl/getfacl コマンドテスト | **根拠なし** | △ |
| C-182〜C-183 | chflags コマンドテスト | **根拠なし** | △ |
| C-184 | cpuset コマンドテスト | **根拠なし** | △ |
| C-185〜C-188 | rmdir/sync コマンドテスト | **根拠なし** | △ |
| C-189 | freebsd-version テスト | **根拠なし** | △ |
| C-190〜C-191 | kenv コマンドテスト | **根拠なし** | △ |
| C-192〜C-193 | nproc コマンドテスト | E-24 | △ |
| C-194〜C-195 | uuidgen コマンドテスト | **根拠なし** | △ |
| C-196〜C-197 | sh trap テスト | E-06 | ○ |
| C-198〜C-200 | sh redir テスト | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- mkdir, rm, mv, ln, df, pwd, hostname, pkill, setfacl, getfacl, chflags, cpuset, rmdir, sync, freebsd-version, kenv, uuidgen のソースコードは直接確認していない。ディレクトリリストでファイルの存在のみ確認済み。
  - 候補：各コマンドの.cソースファイルを直接読み込んで関数シグネチャ・ロジックを確認 / manページによるインタフェース仕様確認 / 既存テストスイート（bin/tests/配下）の確認
- ed の内部関数（io.c, buf.c, re.c, sub.c, undo.c）は main.c のヘッダファイルインクルードから関数の存在を推定。詳細な関数シグネチャは未確認。
  - 候補：bin/ed/ed.h を読み込んで関数プロトタイプを確認
- echo, stty, pax, nproc はファイル存在確認のみで関数詳細は未確認。
  - 候補：各ソースファイルを読み込んで詳細確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - cat, cp, chmod, ls, dd, sh (eval/parser/expand/var/alias/jobs/arith), test, kill, sleep, date vary, timeout のテストケース（ソースコードを直接確認済み）
- 1: 中リスク - ed 内部関数、echo, stty, pax, ps, nproc のテストケース（ファイル存在確認済みだがロジック詳細は部分的確認）
- 2: 高リスク - mkdir, rm, mv, ln, df, pwd, hostname, pkill, setfacl, getfacl, chflags, cpuset, rmdir, sync, freebsd-version, kenv, uuidgen のテストケース（ソースコード未確認、一般的なUNIXコマンド仕様に基づく推定）

## 6) レビュアーチェックリスト（最小）
- [ ] ソースコード未確認のコマンド（mkdir, rm, mv, ln, df, pwd等）のテストケースが実際の実装と合致しているか
- [ ] ed エディタの内部関数テスト（io.c, buf.c, re.c, sub.c, undo.c）の関数名・引数が正しいか
- [ ] sh（シェル）のテストケースでカバーされていない重要な関数がないか（特にexec.c, input.c, output.c, memalloc.c）
- [ ] pax/tar/cpio のアーカイブフォーマット処理のテスト観点が十分か（特にエラーケースと境界値）
- [ ] 各テストケースの優先度が適切か（セキュリティ関連のsetfacl/getfacl/chflagsは高優先度であるべきか検討）
- [ ] テストID（UT-BIN-xxx）の連番に欠番がないか
- [ ] FreeBSD固有の機能（Capsicum sandbox、kenv、cpuset等）のテスト観点が十分か
