---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 180
  claims_with_evidence: 168
  claims_without_evidence: 12
confidence_derived: 0.93
---

# 根拠レポート：bootloader 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：168 / 180、根拠なし：12
- 優先レビュー（高）
  1. **UT-BLD-167 (md_getboothowto)**: ブートフラグ解析の網羅性は要確認。boot_parse_cmdlineとboot_env_to_howtoの内部実装が別ファイル
  2. **UT-BLD-168 (md_load)**: md_load_dualの内部処理が複雑で、FDTサポートやGELIサポートの条件分岐を全てカバーできていない可能性
  3. **EFI/kboot固有テスト**: stand/efi/, stand/kboot/配下のEFI固有コードはテストケースに含まれていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `stand/common/boot.c` - ブートコマンド、オートブート、getbootfile、getrootmount、loadakernelの実装
- E-02: `stand/common/bcache.c` - ブロックキャッシュの初期化、割り当て、解放、読み書き戦略の実装
- E-03: `stand/common/commands.c` - help, show, set, unset, echo, read, more, lsdev, readtest, quitコマンドの実装
- E-04: `stand/common/console.c` - コンソールプローブ、入出力、コンソール切替、twiddle設定の実装
- E-05: `stand/common/module.c` - ファイル/モジュールのロード、検索、メタデータ管理、PNPマッチング、モジュールディレクトリ管理の実装
- E-06: `stand/common/disk.c` - ディスクオープン/クローズ、読み書き、ioctl、デバイス名フォーマット/解析の実装
- E-07: `stand/common/part.c` - パーティションテーブル(GPT/MBR/BSD/ISO9660)解析、パーティション検索の実装
- E-08: `stand/common/interp.c` - コマンドインタプリタ、ビルトインコマンド実行、プロンプト出力の実装
- E-09: `stand/libsa/environment.c` - 環境変数の取得、設定、削除、フック処理の実装
- E-10: `stand/libsa/open.c` - ファイルオープン、ファイルディスクリプタ管理の実装
- E-11: `stand/common/devopen.c` - デバイスオープン/クローズの実装
- E-12: `stand/libsa/zalloc.c` - メモリプール割り当て(znalloc)、解放(zfree)、プール拡張(zextendPool)の実装
- E-13: `stand/common/metadata.c` - カーネルメタデータ構成(md_getboothowto, md_load_dual)の実装
- E-14: `stand/common/load_elf.c` - ELFローダーの実装（一部参照）
- E-15: `stand/common/bootstrap.h` - ブートストラップ共通ヘッダー（関数宣言、構造体定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-BLD-001~004: command_bootの正常系/異常系テスト | E-01 (boot.c L53-119) | ○ |
| C-02 | UT-BLD-005~007: command_autobootの引数解析テスト | E-01 (boot.c L129-155) | ○ |
| C-03 | UT-BLD-008~009: autoboot_maybeの条件分岐テスト | E-01 (boot.c L161-169) | ○ |
| C-04 | UT-BLD-010~011: autobootのタイムアウトとカーネル名テスト | E-01 (boot.c L171-262) | ○ |
| C-05 | UT-BLD-012~015: getbootfileのブートファイル名解析テスト | E-01 (boot.c L267-307) | ○ |
| C-06 | UT-BLD-016~019: getrootmountのfstab解析とZFSフォールバックテスト | E-01 (boot.c L319-414) | ○ |
| C-07 | UT-BLD-020~021: bcache_init/bcache_add_devの初期化テスト | E-02 (bcache.c L97-117) | ○ |
| C-08 | UT-BLD-022~024: bcache_allocateのメモリ割り当てテスト | E-02 (bcache.c L119-168) | ○ |
| C-09 | UT-BLD-025~026: bcache_freeの解放テスト | E-02 (bcache.c L170-180) | ○ |
| C-10 | UT-BLD-027~031: bcache_strategyのキャッシュ読み書きテスト | E-02 (bcache.c L210-456) | ○ |
| C-11 | UT-BLD-032~039: commands.cのset/unset/show/echoテスト | E-03 (commands.c L258-446) | ○ |
| C-12 | UT-BLD-040~054: console.cのプローブ/入出力/切替テスト | E-04 (console.c L92-372) | ○ |
| C-13 | UT-BLD-055~084: module.cのファイル/モジュール管理テスト | E-05 (module.c) | ○ |
| C-14 | UT-BLD-085~100: disk.cのディスク操作テスト | E-06 (disk.c) | ○ |
| C-15 | UT-BLD-101~122: part.cのパーティションテーブル解析テスト | E-07 (part.c) | ○ |
| C-16 | UT-BLD-123~128: interp.cのコマンドインタプリタテスト | E-08 (interp.c) | ○ |
| C-17 | UT-BLD-129~145: environment.cの環境変数管理テスト | E-09 (environment.c) | ○ |
| C-18 | UT-BLD-146~153: open.cのファイルオープンテスト | E-10 (open.c) | ○ |
| C-19 | UT-BLD-154~157: devopen.cのデバイスオープンテスト | E-11 (devopen.c) | ○ |
| C-20 | UT-BLD-158~166: zalloc.cのメモリ管理テスト | E-12 (zalloc.c) | ○ |
| C-21 | UT-BLD-167~168: metadata.cのメタデータ構成テスト | E-13 (metadata.c) | ○ |
| C-22 | UT-BLD-169~174: module.cのPNP値抽出テスト | E-05 (module.c L1252-1326) | ○ |
| C-23 | UT-BLD-175~180: moduledir管理テスト | E-05 (module.c L1696-1797) | ○ |
| C-24 | EFIローダー固有のテストケース | **根拠なし** | △ |
| C-25 | stand/efi/loader/のEFI固有ブート処理テスト | **根拠なし** | △ |
| C-26 | stand/i386/libi386/のBIOSインターフェーステスト | **根拠なし** | △ |
| C-27 | stand/lua/のLuaインタプリタ連携テスト | **根拠なし** | △ |
| C-28 | stand/forth/のForthインタプリタ連携テスト | **根拠なし** | △ |
| C-29 | stand/kboot/のkbootローダーテスト | **根拠なし** | △ |
| C-30 | stand/libsa/geli/のGELI暗号化サポートテスト | **根拠なし** | △ |
| C-31 | stand/common/gfx_fb.cのフレームバッファ描画テスト | **根拠なし** | △ |
| C-32 | stand/libsa/nfs.cのNFSブートテスト | **根拠なし** | △ |
| C-33 | stand/libsa/tftp.cのTFTPブートテスト | **根拠なし** | △ |
| C-34 | stand/libsa/ufs.cのUFSファイルシステムテスト | **根拠なし** | △ |
| C-35 | stand/common/load_elf.cのELFローダー詳細テスト | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **EFI固有コード (stand/efi/)**: EFIブートローダーのプラットフォーム固有処理は今回のテストケースで網羅していない。EFI環境でのみ動作するコードのため、テスト環境の構築が課題
  - 候補：stand/efi/loader/main.c / stand/efi/loader/framebuffer.c / stand/efi/libefi/
- **BIOS固有コード (stand/i386/)**: i386 BIOS環境固有の処理（biosdisk, comconsole等）は含まれていない
  - 候補：stand/i386/libi386/biosdisk.c / stand/i386/libi386/comconsole.c
- **インタプリタ固有コード**: Lua/Forthインタプリタとの連携部分は含まれていない
  - 候補：stand/lua/lutils.c / stand/common/interp_lua.c / stand/common/interp_forth.c
- **ネットワークブート**: NFS, TFTP, BOOTPなどのネットワークブート関連コードは含まれていない
  - 候補：stand/libsa/nfs.c / stand/libsa/tftp.c / stand/libsa/bootp.c
- **ファイルシステム**: UFS, ext2fs, dosfs, cd9660, ZFS等のファイルシステム実装の詳細テストは含まれていない
  - 候補：stand/libsa/ufs.c / stand/libsa/ext2fs.c / stand/libsa/dosfs.c
- **ELFローダー詳細**: load_elf.cの詳細なELFパース/リロケーション処理のテストは限定的
  - 候補：stand/common/load_elf.c / stand/common/load_elf_obj.c

## 5) リスクフラグ（レビュー観点）
- **リスク2 (高)**: EFIブートパス未網羅 - 現代のシステムの大半がEFIブートを使用するため、stand/efi/配下のテストケース追加が必要
- **リスク1 (中)**: ネットワークブート未網羅 - PXEブートやネットワークインストールのシナリオがカバーされていない
- **リスク1 (中)**: ELFローダー詳細未網羅 - カーネルロードの中核であるELF解析の境界値テストが不足
- **リスク1 (中)**: GELI暗号化サポート未網羅 - セキュリティに関わるGELI復号化処理のテストが不足
- **リスク0 (低)**: グラフィックフレームバッファ - gfx_fb.cの描画機能はブート動作の本質ではないが、表示不具合の原因になる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] ブートプロセスの中核(command_boot, autoboot)のテストケースが十分か確認
- [ ] ディスク/パーティション操作(disk_open, ptable_open)のエラーパスが網羅されているか確認
- [ ] 環境変数管理(env_setenv, getenv)のメモリリーク観点のテストが含まれているか確認
- [ ] モジュールロード(mod_loadkld, file_load)の依存関係解決テストが十分か確認
- [ ] EFI固有のブートパスに関するテストケースの追加要否を判断
- [ ] セキュリティ関連(GELI, VERIEXEC)のテストケース追加要否を判断
- [ ] ブロックキャッシュ(bcache_strategy)のリードアヘッド調整ロジックのテストが十分か確認
- [ ] パーティションテーブル解析(GPT CRC検証, MBR magic検証)の境界値テストを確認
