---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 105
  claims_with_evidence: 99
  claims_without_evidence: 6
confidence_derived: 0.94
---

# 根拠レポート：cam-storage 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：99 / 105、根拠なし：6
- 優先レビュー（高）
  1. **UT-CAM-045 (camq_resize メモリ確保失敗)**：カーネルのmalloc失敗パスの具体的挙動の検証根拠が不足
  2. **UT-CAM-049/054 (cam_devq_alloc/cam_ccbq_alloc メモリ確保失敗)**：malloc(M_NOWAIT)の失敗パスの検証方法が要確認
  3. **UT-CAM-067 (cam_sim_alloc メモリ確保失敗)**：同上
  4. **UT-CAM-095/096 (periphdriver_register)**：実装の一部のみ読み取り、レース条件処理の検証が不十分
  5. **UT-CAM-070 (cam_sim_free refcount待機)**：msleepの挙動は実行環境依存のため検証困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sys/cam/cam.c` - CAM共通ユーティリティ関数群（cam_strvis, cam_strmatch, cam_quirkmatch, cam_fetch_status_entry, cam_calc_geometry, cam_error_string, memdesc_ccb, bus_dmamap_load_ccb）
- E-02: `sys/cam/cam.h` - CAMデータ構造・ステータス定義（cam_status enum, cam_pinfo struct, cam_init_pinfo）
- E-03: `sys/cam/cam_queue.c` - キュー管理関数（camq_init, camq_fini, camq_resize, camq_insert, camq_remove, camq_change_priority, cam_devq_alloc/init/free/resize, cam_ccbq_alloc/init/free/fini/resize）
- E-04: `sys/cam/cam_queue.h` - キュー構造体・インライン関数（camq struct, cam_ccbq struct, cam_devq struct, cam_ccbq_insert_ccb, cam_ccbq_remove_ccb, cam_ccbq_send_ccb, cam_ccbq_ccb_done, cam_ccbq_pending_ccb_count, cam_ccbq_take_opening, cam_ccbq_release_opening, cam_ccbq_peek_ccb）
- E-05: `sys/cam/cam_sim.c` - SIM管理関数（cam_simq_alloc, cam_sim_alloc, cam_sim_free, cam_sim_release, cam_sim_hold, cam_sim_set_path）
- E-06: `sys/cam/cam_sim.h` - SIM構造体・アクセサ関数（cam_sim struct, cam_sim_path, cam_sim_name, cam_sim_softc, cam_sim_unit, cam_sim_bus, cam_sim_pollable）
- E-07: `sys/cam/cam_periph.h` - ペリフェラルドライバ構造体・関数宣言（cam_periph struct, periph_driver struct, cam_periph_mtx, cam_periph_acquire_first, cam_periph_acquire_next）
- E-08: `sys/cam/cam_periph.c` - ペリフェラルドライバ実装（periphdriver_register）
- E-09: `sys/cam/cam_iosched.h` - IOスケジューラインライン関数（cam_iosched_now, cam_iosched_delta_t, cam_iosched_sbintime_t）
- E-10: `sys/cam/cam_ccb.h` - CCB構造体定義・フラグ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-CAM-001: cam_strvisがASCII文字列を正しくコピーする | E-01 (cam.c:129-134) | ○ |
| C-02 | UT-CAM-002: cam_strvisが先頭・末尾スペースをトリムする | E-01 (cam.c:153-157) | ○ |
| C-03 | UT-CAM-003: cam_strvisがsrclen=0で空文字列を返す | E-01 (cam.c:159) | ○ |
| C-04 | UT-CAM-004: cam_strvisがdstlen=1でNUL終端のみ | E-01 (cam.c:142-144) | ○ |
| C-05 | UT-CAM-005: cam_strvis_flagがNONASCII_ESCで8進エスケープ | E-01 (cam.c:164-168) | ○ |
| C-06 | UT-CAM-006: cam_strvis_flagがNONASCII_RAWでそのまま出力 | E-01 (cam.c:170-178) | ○ |
| C-07 | UT-CAM-007: cam_strvis_flagがNONASCII_SPCでスペース置換 | E-01 (cam.c:180-181) | ○ |
| C-08 | UT-CAM-008: cam_strvis_flagがNONASCII_TRIMで除去 | E-01 (cam.c:182-185) | ○ |
| C-09 | UT-CAM-009: NUL文字がRAWモードでスペースに変換 | E-01 (cam.c:175-178) | ○ |
| C-10 | UT-CAM-010: cam_strmatchが完全一致で0を返す | E-01 (cam.c:210-284) | ○ |
| C-11 | UT-CAM-011: cam_strmatchが*ワイルドカードでマッチ | E-01 (cam.c:214-224) | ○ |
| C-12 | UT-CAM-012: cam_strmatchが?ワイルドカードでマッチ | E-01 (cam.c:251-255) | ○ |
| C-13 | UT-CAM-013: cam_strmatchが文字クラス[...]でマッチ | E-01 (cam.c:225-250) | ○ |
| C-14 | UT-CAM-014: cam_strmatchが否定文字クラス[^...]でマッチ | E-01 (cam.c:234) | ○ |
| C-15 | UT-CAM-015: cam_strmatchが範囲指定[a-z]でマッチ | E-01 (cam.c:237-241) | ○ |
| C-16 | UT-CAM-016: cam_strmatchが不一致で非0を返す | E-01 (cam.c:260-261) | ○ |
| C-17 | UT-CAM-017: cam_strmatchが末尾スペースを許容 | E-01 (cam.c:278-282) | ○ |
| C-18 | UT-CAM-018: cam_strmatchがstr_len=0で動作 | E-01 (cam.c:213, 269-275) | ○ |
| C-19 | UT-CAM-019: cam_strmatchが*単独で全マッチ | E-01 (cam.c:216-217) | ○ |
| C-20 | UT-CAM-020: cam_quirkmatchが一致エントリを返す | E-01 (cam.c:287-295) | ○ |
| C-21 | UT-CAM-021: cam_quirkmatchが不一致でNULLを返す | E-01 (cam.c:294) | ○ |
| C-22 | UT-CAM-022: cam_quirkmatchがnum_entries=0でNULL | E-01 (cam.c:290) | ○ |
| C-23 | UT-CAM-023: cam_fetch_status_entryが有効ステータスでエントリ返却 | E-01 (cam.c:297-305) | ○ |
| C-24 | UT-CAM-024: cam_fetch_status_entryが無効ステータスでNULL | E-01 (cam.c:301) | ○ |
| C-25 | UT-CAM-025: cam_fetch_status_entryがマスクを適用 | E-01 (cam.c:300) | ○ |
| C-26 | UT-CAM-026: cam_calc_geometryが小容量でheads=64 | E-01 (cam.c:596-597) | ○ |
| C-27 | UT-CAM-027: cam_calc_geometryが大容量でheads=255 | E-01 (cam.c:593-595) | ○ |
| C-28 | UT-CAM-028: cam_calc_geometryがextended=0でheads=64 | E-01 (cam.c:593) | ○ |
| C-29 | UT-CAM-029: cam_calc_geometryがblock_size=0でエラー | E-01 (cam.c:583-585) | ○ |
| C-30 | UT-CAM-030: cam_error_stringがccb=NULLでNULL返却 | E-01 (cam.c:334-337) | ○ |
| C-31 | UT-CAM-031: cam_error_stringがstr=NULLでNULL返却 | E-01 (cam.c:335-337) | ○ |
| C-32 | UT-CAM-032: cam_error_stringがstr_len<=0でNULL返却 | E-01 (cam.c:336-337) | ○ |
| C-33 | UT-CAM-033: cam_error_stringがESF_NONEでNULL返却 | E-01 (cam.c:339-340) | ○ |
| C-34 | UT-CAM-034: camq_initがsize=64で正常初期化 | E-03 (cam_queue.c:51-68) | ○ |
| C-35 | UT-CAM-035: camq_initがsize=0で空キュー初期化 | E-03 (cam_queue.c:55-66) | ○ |
| C-36 | UT-CAM-036: camq_finiがメモリ解放 | E-03 (cam_queue.c:77-82) | ○ |
| C-37 | UT-CAM-037: camq_insertが要素を挿入しヒープ維持 | E-03 (cam_queue.c:118-130) | ○ |
| C-38 | UT-CAM-038: camq_insertが優先度順を維持 | E-03 (cam_queue.c:118-130, heap_up:328-343) | ○ |
| C-39 | UT-CAM-039: camq_insertが同優先度で世代順 | E-03 (cam_queue.c:297-305) queue_cmp関数 | ○ |
| C-40 | UT-CAM-040: camq_removeが先頭要素を正しく削除 | E-03 (cam_queue.c:138-157) | ○ |
| C-41 | UT-CAM-041: camq_removeが中間要素を正しく削除 | E-03 (cam_queue.c:138-157) | ○ |
| C-42 | UT-CAM-042: camq_removeがindex<=0でpanic | E-03 (cam_queue.c:143-146) | ○ |
| C-43 | UT-CAM-043: camq_removeがindex>entriesでpanic | E-03 (cam_queue.c:143-146) | ○ |
| C-44 | UT-CAM-044: camq_resizeが正常にリサイズ | E-03 (cam_queue.c:85-111) | ○ |
| C-45 | UT-CAM-045: camq_resizeがメモリ失敗でCAM_RESRC_UNAVAIL | E-03 (cam_queue.c:94-97) | △ |
| C-46 | UT-CAM-046: camq_change_priorityが上昇時にheap_up | E-03 (cam_queue.c:165-176) | ○ |
| C-47 | UT-CAM-047: camq_change_priorityが下降時にheap_down | E-03 (cam_queue.c:168-170) | ○ |
| C-48 | UT-CAM-048: cam_devq_allocが正常に確保 | E-03 (cam_queue.c:178-193) | ○ |
| C-49 | UT-CAM-049: cam_devq_allocがmalloc失敗でNULL | E-03 (cam_queue.c:183-186) | △ |
| C-50 | UT-CAM-050: cam_devq_initが正常に初期化 | E-03 (cam_queue.c:196-206) | ○ |
| C-51 | UT-CAM-051: cam_devq_freeが正常に解放 | E-03 (cam_queue.c:209-215) | ○ |
| C-52 | UT-CAM-052: cam_devq_resizeが正常にリサイズ | E-03 (cam_queue.c:218-224) | ○ |
| C-53 | UT-CAM-053: cam_ccbq_allocが正常に確保 | E-03 (cam_queue.c:226-242) | ○ |
| C-54 | UT-CAM-054: cam_ccbq_allocがmalloc失敗でNULL | E-03 (cam_queue.c:231-234) | △ |
| C-55 | UT-CAM-055: cam_ccbq_initが正常に初期化 | E-03 (cam_queue.c:270-279) | ○ |
| C-56 | UT-CAM-056: cam_ccbq_resizeがopenings調整 | E-03 (cam_queue.c:254-267) | ○ |
| C-57 | UT-CAM-057: cam_ccbq_resizeがarray_size十分で不要 | E-03 (cam_queue.c:263-266) | ○ |
| C-58 | UT-CAM-058: cam_ccbq_pending_ccb_countが正しく計算 | E-04 (cam_queue.h:144-147) | ○ |
| C-59 | UT-CAM-059: cam_ccbq_insert_ccbが正常挿入 | E-04 (cam_queue.h:157-181) | ○ |
| C-60 | UT-CAM-060: cam_ccbq_insert_ccbがオーバーフロー処理 | E-04 (cam_queue.h:171-178) | ○ |
| C-61 | UT-CAM-061: cam_ccbq_remove_ccbが正常削除 | E-04 (cam_queue.h:184-221) | ○ |
| C-62 | UT-CAM-062: cam_ccbq_remove_ccbがEXTRAQから削除 | E-04 (cam_queue.h:191-197) | ○ |
| C-63 | UT-CAM-063: cam_ccbq_remove_ccbがEXTRAQ昇格 | E-04 (cam_queue.h:208-220) | ○ |
| C-64 | UT-CAM-064: cam_ccbq_send_ccbがカウンタ更新 | E-04 (cam_queue.h:230-236) | ○ |
| C-65 | UT-CAM-065: cam_ccbq_ccb_doneがカウンタ更新 | E-04 (cam_queue.h:239-244) | ○ |
| C-66 | UT-CAM-066: cam_sim_allocが正常に確保 | E-05 (cam_sim.c:99-125) | ○ |
| C-67 | UT-CAM-067: cam_sim_allocがmalloc失敗でNULL | E-05 (cam_sim.c:108-109) | △ |
| C-68 | UT-CAM-068: cam_sim_freeがdevq含め解放 | E-05 (cam_sim.c:140-166) | ○ |
| C-69 | UT-CAM-069: cam_sim_freeがdevqなしで解放 | E-05 (cam_sim.c:163-164) | ○ |
| C-70 | UT-CAM-070: cam_sim_freeがrefcount>1でmsleep | E-05 (cam_sim.c:155-158) | △ |
| C-71 | UT-CAM-071: cam_sim_holdがrefcount++ | E-05 (cam_sim.c:189-206) | ○ |
| C-72 | UT-CAM-072: cam_sim_releaseがrefcount-- | E-05 (cam_sim.c:168-187) | ○ |
| C-73 | UT-CAM-073: cam_sim_releaseがrefcount=0でwakeup | E-05 (cam_sim.c:183-184) | ○ |
| C-74 | UT-CAM-074: cam_sim_set_pathがpath_id設定 | E-05 (cam_sim.c:209-212) | ○ |
| C-75 | UT-CAM-075: cam_simq_allocが正常確保 | E-05 (cam_sim.c:52-55) | ○ |
| C-76 | UT-CAM-076: cam_sim_pathがpath_id返却 | E-06 (cam_sim.h:97-101) | ○ |
| C-77 | UT-CAM-077: cam_sim_nameがsim_name返却 | E-06 (cam_sim.h:103-107) | ○ |
| C-78 | UT-CAM-078: cam_sim_softcがsoftcポインタ返却 | E-06 (cam_sim.h:109-113) | ○ |
| C-79 | UT-CAM-079: cam_sim_unitがunit_number返却 | E-06 (cam_sim.h:115-119) | ○ |
| C-80 | UT-CAM-080: cam_sim_busがbus_id返却 | E-06 (cam_sim.h:121-125) | ○ |
| C-81 | UT-CAM-081: cam_sim_pollableがsim_poll非NULLでtrue | E-06 (cam_sim.h:127-131) | ○ |
| C-82 | UT-CAM-082: cam_sim_pollableがsim_poll NULLでfalse | E-06 (cam_sim.h:127-131) | ○ |
| C-83 | UT-CAM-083: cam_init_pinfoが正しく初期化 | E-02 (cam.h:433-437) | ○ |
| C-84 | UT-CAM-084: cam_iosched_nowが非0値返却 | E-09 (cam_iosched.h:57-63) | ○ |
| C-85 | UT-CAM-085: cam_iosched_delta_tが正しい差分計算 | E-09 (cam_iosched.h:65-71) | ○ |
| C-86 | UT-CAM-086: cam_iosched_delta_tのラップアラウンド | E-09 (cam_iosched.h:69-70) | ○ |
| C-87 | UT-CAM-087: cam_iosched_sbintime_tが正しく変換 | E-09 (cam_iosched.h:73-79) | ○ |
| C-88 | UT-CAM-088: cam_periph_mtxが非NULLのmtx返却 | E-07 (cam_periph.h:213-220) | ○ |
| C-89 | UT-CAM-089: cam_periph_mtxがperiph=NULLでNULL | E-07 (cam_periph.h:216-219) | ○ |
| C-90 | UT-CAM-090: cam_periph_acquire_firstが有効periph取得 | E-07 (cam_periph.h:237-250) | ○ |
| C-91 | UT-CAM-091: cam_periph_acquire_firstがINVALIDスキップ | E-07 (cam_periph.h:244-245) | ○ |
| C-92 | UT-CAM-092: cam_periph_acquire_firstが空リストでNULL | E-07 (cam_periph.h:243) | ○ |
| C-93 | UT-CAM-093: cam_periph_acquire_nextが次periph取得 | E-07 (cam_periph.h:252-267) | ○ |
| C-94 | UT-CAM-094: cam_periph_acquire_nextが末尾でNULL | E-07 (cam_periph.h:260-266) | ○ |
| C-95 | UT-CAM-095: periphdriver_registerがドライバ登録 | E-08 (cam_periph.c:112-147) | △ |
| C-96 | UT-CAM-096: periphdriver_registerが追加登録 | E-08 (cam_periph.c:132-134) | ○ |
| C-97 | UT-CAM-097: memdesc_ccbがSCSI IOで正しく生成 | E-01 (cam.c:620-628) | ○ |
| C-98 | UT-CAM-098: memdesc_ccbがATA IOで正しく生成 | E-01 (cam.c:638-645) | ○ |
| C-99 | UT-CAM-099: memdesc_ccbがNVMe IOで正しく生成 | E-01 (cam.c:647-655) | ○ |
| C-100 | UT-CAM-100: memdesc_ccbがCAM_DATA_BIOでbio返却 | E-01 (cam.c:672-673) | ○ |
| C-101 | UT-CAM-101: memdesc_ccbがCAM_DATA_SGでSGリスト返却 | E-01 (cam.c:668-669) | ○ |
| C-102 | UT-CAM-102: bus_dmamap_load_ccbがDIR_NONEでcallback即時呼出 | E-01 (cam.c:688-691) | ○ |
| C-103 | UT-CAM-103: cam_ccbq_take_openingがallocated++ | E-04 (cam_queue.h:150-154) | ○ |
| C-104 | UT-CAM-104: cam_ccbq_release_openingがallocated-- | E-04 (cam_queue.h:247-251) | ○ |
| C-105 | UT-CAM-105: cam_ccbq_peek_ccbが指定indexのCCB返却 | E-04 (cam_queue.h:224-227) | ○ |

## 4) 不足情報（Unknown / Missing）
- **malloc失敗パス（C-45, C-49, C-54, C-67）**: カーネルのmallocがM_NOWAITフラグで失敗する状況をユニットテストで再現する具体的な方法が不明。FreeBSDのカーネルテストフレームワークでのmalloc失敗注入の仕組みを要調査。
  - 候補：fault injection framework / テスト用mallocラッパー / KASSERTベースの検証
- **msleep待機パス（C-70）**: cam_sim_freeのrefcount>1時のmsleep待機は、マルチスレッド環境でのテストが必要であり、単体テストでの検証方法が要検討。
  - 候補：kthread_createによる並行テスト / sleepqueueのモック
- **periphdriver_registerのレース条件（C-95）**: xpt_lock_buses/xpt_unlock_busesによるレース条件処理のgoto againパスは、並行実行テストが必要。
  - 候補：競合条件テストフレームワーク / ロック取得順序の静的解析

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - SIMアクセサ関数群（UT-CAM-076 ~ UT-CAM-082）: 単純なフィールド参照のみで実装が自明
- **0: 低リスク** - cam_init_pinfo（UT-CAM-083）: 初期化のみの単純な関数
- **1: 中リスク** - cam_strmatch（UT-CAM-010 ~ UT-CAM-019）: パターンマッチングの再帰処理があり、エッジケースの網羅性に注意
- **1: 中リスク** - ヒープ操作（UT-CAM-037 ~ UT-CAM-047）: ヒープの整合性検証にはプロパティベーステストが有効
- **2: 高リスク** - cam_calc_geometry（UT-CAM-026 ~ UT-CAM-029）: ディスクジオメトリ計算はストレージ整合性に直結、整数オーバーフローの追加テストを推奨
- **2: 高リスク** - CCBキュー操作（UT-CAM-059 ~ UT-CAM-065）: I/Oパスの正確性に直結、データ整合性の観点から重要

## 6) レビュアーチェックリスト（最小）
- [ ] cam_strmatchの再帰深度制限に関するテストケースが必要か確認（パターン内の*の数に比例して再帰が発生）
- [ ] cam_calc_geometryの整数オーバーフロー境界値テスト（volume_sizeがUINT32_MAX付近）を追加すべきか検討
- [ ] malloc失敗パスのテスト方法（fault injection等）について実現可能性を確認
- [ ] cam_ccbq_insert_ccbのオーバーフロー時のTAILQ操作における優先度逆転のテストケースが十分か確認
- [ ] cam_sim_free/cam_sim_releaseの参照カウント競合テストの実現方法を検討
- [ ] cam_periph_acquire_first/nextのイテレーション中のperiphの無効化（CAM_PERIPH_INVALID）シナリオが十分にカバーされているか確認
- [ ] scsi/ata/nvme/mmc各サブシステム固有のテストケースは本cam-storageモジュールの範囲外だが、統合テストで補完されるか確認
