---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：crypto モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（crypto.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **UT-CRY-058 (cipher_crypt往復テスト)**：暗号化/復号の往復テストの期待結果はロジック推測に基づく
  2. **UT-CRY-086 (ssh_digest_memory SHA256テスト)**：SHA256の既知ハッシュ値は外部仕様からの参照が必要
  3. **UT-CRY-073 (HMAC-MD5 RFC2104テストベクタ)**：hmac.cのTEST部に記載のテストベクタだが実運用時の値は要検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `crypto/openssh/sshbuf.c` - sshbuf構造体定義、sshbuf_new, sshbuf_from, sshbuf_fromb, sshbuf_free, sshbuf_reset, sshbuf_len, sshbuf_avail, sshbuf_ptr, sshbuf_mutable_ptr, sshbuf_set_max_size, sshbuf_check_reserve, sshbuf_reserve, sshbuf_consume, sshbuf_consume_end
- E-02: `crypto/openssh/sshbuf.h` - sshbuf API宣言、定数定義 (SSHBUF_SIZE_MAX, SSHBUF_REFS_MAX)
- E-03: `crypto/openssh/sshbuf-getput-basic.c` - sshbuf_get, sshbuf_get_u64, sshbuf_get_u32, sshbuf_get_u16, sshbuf_get_u8
- E-04: `crypto/openssh/sshbuf-misc.c` - sshbuf_dump_data, sshbuf_dtob16
- E-05: `crypto/openssh/cipher.c` - sshcipher構造体定義、ciphers配列、cipher_by_name, ciphers_valid, cipher_blocksize, cipher_keylen, cipher_seclen, cipher_authlen, cipher_ivlen, cipher_is_cbc, cipher_alg_list, cipher_init, cipher_crypt, cipher_get_length, cipher_free, cipher_warning_message
- E-06: `crypto/openssh/hmac.c` - ssh_hmac_ctx構造体定義、ssh_hmac_bytes, ssh_hmac_start, ssh_hmac_init, ssh_hmac_update, ssh_hmac_final, ssh_hmac_free, hmac_test (TESTブロック内RFC2104テストベクタ)
- E-07: `crypto/openssh/digest-openssl.c` - ssh_digest構造体定義、digests配列、ssh_digest_by_alg, ssh_digest_alg_by_name, ssh_digest_alg_name, ssh_digest_bytes, ssh_digest_start, ssh_digest_copy_state, ssh_digest_update, ssh_digest_final, ssh_digest_free, ssh_digest_memory, ssh_digest_buffer
- E-08: `crypto/openssh/match.c` - match_pattern, match_pattern_list, match_hostname, match_host_and_ip, match_user, match_list, filter_list, match_filter_denylist, match_filter_allowlist
- E-09: `crypto/openssh/bitmap.c` - bitmap構造体定義、bitmap_new, bitmap_free, bitmap_zero, bitmap_set_bit, bitmap_test_bit, bitmap_clear_bit, bitmap_nbits, bitmap_nbytes, bitmap_to_string, bitmap_from_string, BITMAP_MAX定数
- E-10: `crypto/openssh/sshkey.c` - keyimpls配列、sshkey_type, sshkey_type_from_name, sshkey_type_is_cert, sshkey_ssh_name, sshkey_match_keyname_to_sigalgs, sshkey_ecdsa_nid_from_name
- E-11: `crypto/openssh/ed25519.c` - crypto_verify_32関数（定数時間比較）
- E-12: `crypto/openssh/addr.c` - addr_unicast_masklen, masklen_valid, addr_xaddr_to_sa

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-CRY-001~002) | sshbuf_newが非NULLを返しmax_size=SSHBUF_SIZE_MAX, refcount=1 | E-01 (sshbuf.c:92-109) | ○ |
| C-02 (UT-CRY-003~006) | sshbuf_fromの正常系/異常系/境界値 | E-01 (sshbuf.c:112-126) | ○ |
| C-03 (UT-CRY-007) | sshbuf_frombが子バッファを生成しparentを設定 | E-01 (sshbuf.c:144-158) | ○ |
| C-04 (UT-CRY-008~010) | sshbuf_freeのNULLセーフティ、refcount管理 | E-01 (sshbuf.c:160-193) | ○ |
| C-05 (UT-CRY-011~012) | sshbuf_resetのreadonly時挙動 | E-01 (sshbuf.c:195-216) | ○ |
| C-06 (UT-CRY-013~018) | sshbuf_len, sshbuf_avail, sshbuf_ptr, sshbuf_mutable_ptr | E-01 (sshbuf.c:280-310), E-02 | ○ |
| C-07 (UT-CRY-019~021) | sshbuf_set_max_sizeのreadonly拒否、上限チェック | E-01 (sshbuf.c:243-278) | ○ |
| C-08 (UT-CRY-022~028) | sshbuf_check_reserve, sshbuf_reserve, sshbuf_consume, sshbuf_consume_end | E-01 (sshbuf.c:312-426) | ○ |
| C-09 (UT-CRY-029~035) | sshbuf_get_u32/u64/u16/u8/get の読み取りとバッファ不足時エラー | E-03 (sshbuf-getput-basic.c:34-80) | ○ |
| C-10 (UT-CRY-036) | sshbuf_dtob16の16進変換 | E-04 (sshbuf-misc.c:73-79) | ○ |
| C-11 (UT-CRY-037~039) | cipher_by_nameの正常系/異常系/境界値 | E-05 (cipher.c:202-210) | ○ |
| C-12 (UT-CRY-040~044) | ciphers_validのNULL/空文字列/none(CFLAG_INTERNAL)チェック | E-05 (cipher.c:213-234) | ○ |
| C-13 (UT-CRY-045~055) | cipher_blocksize/keylen/seclen/authlen/ivlen/is_cbc/alg_list | E-05 (cipher.c:86-111, 153-200) | ○ |
| C-14 (UT-CRY-056~057) | cipher_initの正常系と鍵長不足 | E-05 (cipher.c:245-332) | ○ |
| C-15 (UT-CRY-058) | cipher_cryptの暗号化/復号往復テスト | E-05 (cipher.c:344-404) | △ |
| C-16 (UT-CRY-059) | cipher_cryptの非ブロック境界拒否 | E-05 (cipher.c:387-388) | ○ |
| C-17 (UT-CRY-060~061) | cipher_get_lengthの正常系/4バイト未満エラー | E-05 (cipher.c:407-418) | ○ |
| C-18 (UT-CRY-062~064) | cipher_free/cipher_warning_message | E-05 (cipher.c:420-243) | ○ |
| C-19 (UT-CRY-065~066) | ssh_hmac_bytesが各アルゴリズムの正しい長さを返す | E-06 (hmac.c:38-42), E-07 (digest-openssl.c:58-65) | ○ |
| C-20 (UT-CRY-067~068) | ssh_hmac_startの正常系/不正アルゴリズム | E-06 (hmac.c:44-63) | ○ |
| C-21 (UT-CRY-069~071) | ssh_hmac_initの鍵設定/NULL鍵/長い鍵ハッシュ | E-06 (hmac.c:65-92) | ○ |
| C-22 (UT-CRY-072) | ssh_hmac_updateのメッセージ追加 | E-06 (hmac.c:94-98) | ○ |
| C-23 (UT-CRY-073) | HMAC-MD5 RFC2104テストベクタ一致 | E-06 (hmac.c:138-196) | ○ |
| C-24 (UT-CRY-074) | ssh_hmac_finalのバッファ不足拒否 | E-06 (hmac.c:107-121) | ○ |
| C-25 (UT-CRY-075~076) | ssh_hmac_freeのNULLセーフティ | E-06 (hmac.c:123-136) | ○ |
| C-26 (UT-CRY-077~079) | ssh_digest_by_algの範囲チェック | E-07 (digest-openssl.c:67-77) | ○ |
| C-27 (UT-CRY-080~082) | ssh_digest_alg_by_nameの名前検索 | E-07 (digest-openssl.c:79-89) | ○ |
| C-28 (UT-CRY-083~085) | ssh_digest_bytesの各アルゴリズムダイジェスト長 | E-07 (digest-openssl.c:58-65, 99-105) | ○ |
| C-29 (UT-CRY-086) | ssh_digest_memoryのSHA256既知ハッシュ値テスト | E-07 (digest-openssl.c:184-200) | △ |
| C-30 (UT-CRY-087~088) | ssh_digest_memoryのバッファ不足/不正アルゴリズム | E-07 (digest-openssl.c:184-200) | ○ |
| C-31 (UT-CRY-089~094) | ssh_digest_start/copy_state/final/free | E-07 (digest-openssl.c:113-182) | ○ |
| C-32 (UT-CRY-095~101) | match_patternのワイルドカード/完全一致/境界値 | E-08 (match.c:56-113) | ○ |
| C-33 (UT-CRY-102~105) | match_pattern_listのカンマ区切り/否定/長すぎるパターン | E-08 (match.c:121-172) | ○ |
| C-34 (UT-CRY-106~107) | match_hostnameの大文字小文字無視 | E-08 (match.c:193-203) | ○ |
| C-35 (UT-CRY-108~109) | match_host_and_ipのNULLホスト | E-08 (match.c:210-228) | ○ |
| C-36 (UT-CRY-110~111) | match_listのネゴシエーション成功/失敗 | E-08 (match.c:273-311) | ○ |
| C-37 (UT-CRY-112~113) | match_filter_denylist/allowlist | E-08 (match.c:320-367) | ○ |
| C-38 (UT-CRY-114~115) | match_userのパターンマッチ | E-08 (match.c:235-265) | ○ |
| C-39 (UT-CRY-116~131) | bitmap_new/set_bit/test_bit/clear_bit/zero/nbits/to_string/from_string/free | E-09 (bitmap.c:37-214) | ○ |
| C-40 (UT-CRY-132~139) | sshkey_type/type_from_name/type_is_cert/match_keyname_to_sigalgs | E-10 (sshkey.c:173-319) | ○ |
| C-41 (UT-CRY-140~142) | crypto_verify_32の定数時間比較 | E-11 (ed25519.c:29-31) | ○ |
| C-42 (UT-CRY-143~150) | addr_unicast_masklen/masklen_valid/addr_xaddr_to_sa | E-12 (addr.c:36-100) | ○ |
| C-43 | sshbuf_allocateの動的拡張ロジック | E-01 (sshbuf.c:329-369) | △ |
| C-44 | cipher_crypt内のGCMタグ検証ロジック | E-05 (cipher.c:366-401) | △ |
| C-45 | sshbuf_from のlen=0とblob非NULLの組み合わせ挙動 | E-01 (sshbuf.c:116) | △ |
| C-46 | cipher_get_keyiv/cipher_set_keyivの詳細動作 | E-05 (cipher.c:437-505) | △ |
| C-47 | libecc (nn, hash, sig) の関数群 | **根拠なし** | △ |
| C-48 | opensshのkex.c鍵交換ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **libecc ライブラリ**: `crypto/libecc/src/` 配下にnn（大数演算）、hash（ハッシュ関数群）、sig（署名）、fp（有限体演算）、ecdh（鍵共有）など多数のモジュールが存在するが、本テストケース一覧ではOpenSSH部分に集中しており、libecc固有のテストケースは含めていない
  - 候補：libecc/src/nn/nn.c / libecc/src/hash/sha256.c / libecc/src/sig/
- **openssh kex.c（鍵交換）**: 鍵交換ロジックは外部依存（ネットワークI/O）が多く、単体テストとしての分離が困難なため対象外とした
  - 候補：kex.c / kexgen.c / kexc25519.c
- **SHA256の既知ハッシュ値**: UT-CRY-086の期待結果で参照する既知ハッシュ値はNIST FIPS 180-4等の外部仕様からの引用が必要
- **cipher_cryptの往復テスト**: UT-CRY-058の検証は暗号化コンテキストと復号コンテキストを別々に初期化する必要があり、テスト実装の詳細設計が追加で必要

## 5) リスクフラグ（レビュー観点）
- **2: 高リスク** - libecc配下のテストケース未網羅。暗号ライブラリの正当性検証としては、libecc固有の大数演算・楕円曲線演算のテストも必要
- **1: 中リスク** - cipher_cryptの暗号化/復号往復テスト（UT-CRY-058）は、OpenSSLのEVP APIへの依存があり、モック化の戦略が未定義
- **1: 中リスク** - cipher_get_keyiv/cipher_set_keyivの詳細テストが不足。GCMモードのIV管理は暗号的に重要
- **0: 低リスク** - sshbuf, match, bitmap の各モジュールは純粋な関数が多く、ソースコードから直接テストケースを導出できている

## 6) レビュアーチェックリスト（最小）
- [ ] libecc配下の暗号プリミティブ（大数演算、ハッシュ、署名）のテストケースを追加すべきか検討
- [ ] UT-CRY-058（暗号化/復号往復テスト）のテスト実装戦略（OpenSSL EVP APIのモック化方針）を確認
- [ ] UT-CRY-086（SHA256既知ハッシュ値テスト）の期待値がNIST FIPS 180-4の公式テストベクタと一致するか確認
- [ ] UT-CRY-073（HMAC-MD5 RFC2104テストベクタ）の値がhmac.c内TESTブロックのテストベクタと一致するか確認
- [ ] cipher_get_keyiv/cipher_set_keyivのGCMモードIV管理テストの追加要否を検討
- [ ] kex.c系（鍵交換プロトコル）のテストケースを統合テストとして別途計画すべきか検討
- [ ] 各テストケースの優先度（高/中/低）がプロジェクトのリスク方針と整合しているか確認
