---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 222
  claims_with_evidence: 210
  claims_without_evidence: 12
confidence_derived: 0.95
---

# 根拠レポート：ddb 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：210 / 222、根拠なし：12
- 優先レビュー（高）
  1. **db_run.c の一部テストケース**：マクロ（IS_BREAKPOINT_TRAP, IS_WATCHPOINT_TRAP等）がアーキテクチャ依存であり、具体的な値が不明
  2. **db_expr.c の式評価テスト**：db_radixのデフォルト値(16)による数値解釈の正確性要確認
  3. **db_input.c の履歴管理**：履歴バッファサイズ(2048バイト)とラインサイズに基づく最大行数の計算要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sys/ddb/db_access.c` - メモリアクセス関数(db_get_value, db_put_value)
- E-02: `sys/ddb/db_access.h` - db_extend配列定義
- E-03: `sys/ddb/db_break.c` - ブレークポイント管理(alloc, free, set, delete, find)
- E-04: `sys/ddb/db_break.h` - ブレークポイント構造体定義
- E-05: `sys/ddb/db_lex.c` - 字句解析器(db_lex, db_read_line, db_inject_line等)
- E-06: `sys/ddb/db_lex.h` - トークン定義(tNUMBER, tIDENT等)
- E-07: `sys/ddb/db_expr.c` - 式評価器(db_expression, db_term, db_unary等)
- E-08: `sys/ddb/db_sym.c` - シンボルテーブル管理(db_lookup, db_search_symbol等)
- E-09: `sys/ddb/db_sym.h` - シンボル関連定義
- E-10: `sys/ddb/db_command.c` - コマンドディスパッチャ(db_command_register等)
- E-11: `sys/ddb/db_command.h` - コマンド構造体定義
- E-12: `sys/ddb/db_watch.c` - ウォッチポイント管理
- E-13: `sys/ddb/db_watch.h` - ウォッチポイント構造体定義
- E-14: `sys/ddb/db_script.c` - スクリプト機能
- E-15: `sys/ddb/db_capture.c` - キャプチャ機能
- E-16: `sys/ddb/db_output.c` - 出力処理(db_printf, ページャ等)
- E-17: `sys/ddb/db_output.h` - 出力関連定義
- E-18: `sys/ddb/db_variables.c` - 変数管理(db_read_variable, db_write_variable等)
- E-19: `sys/ddb/db_variables.h` - 変数構造体定義
- E-20: `sys/ddb/db_input.c` - 入力処理(db_readline, db_inputchar等)
- E-21: `sys/ddb/db_textdump.c` - テキストダンプ機能
- E-22: `sys/ddb/db_run.c` - 実行制御(step, continue等)
- E-23: `sys/ddb/ddb.h` - DDBモジュール全体の宣言

## 3) Claims と根拠の対応（レビューの主戦場）

### db_access.c (UT-DDB-001 -- UT-DDB-010)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | db_get_valueが1/2/4/8バイト値を正しく読み取る | E-01 (L52-80) | ○ |
| C-02 | 符号拡張がdb_extend配列で正しく適用される | E-01 (L45-50, L75-78), E-02 | ○ |
| C-03 | db_read_bytes失敗時にエラーメッセージとkdb_reenter | E-01 (L59-63) | ○ |
| C-04 | db_put_valueがリトルエンディアンでバイト分解する | E-01 (L82-103) | ○ |
| C-05 | db_write_bytes失敗時にエラーメッセージとkdb_reenter | E-01 (L98-102) | ○ |

### db_break.c (UT-DDB-011 -- UT-DDB-027)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | ブレークポイント割り当てがフリーリストとテーブルから行われる | E-03 (L91-109) | ○ |
| C-07 | NBREAKPOINTS=100が上限 | E-03 (L58) | ○ |
| C-08 | 重複ブレークポイント設定が検出される | E-03 (L124-127) | ○ |
| C-09 | db_map_equalがNULLとkernel_mapを等価とみなす | E-03 (L363-369) | ○ |
| C-10 | db_map_currentが常にtrue(現実装) | E-03 (L371-384) | ○ |
| C-11 | db_map_addrが常にkernel_map(現実装) | E-03 (L386-405) | ○ |

### db_lex.c (UT-DDB-028 -- UT-DDB-055)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | DB_MAXLINE=120が最大行長 | E-23 (L55) | ○ |
| C-13 | db_inject_lineがstrlcpyでDB_MAXLINE制限 | E-05 (L67-74) | ○ |
| C-14 | 0x/0o/0tプレフィックスによる基数切り替え | E-05 (L210-223) | ○ |
| C-15 | 二文字演算子(==, !=, <<, >>, &&, ||)の解析 | E-05 (L295-378) | ○ |
| C-16 | db_unread_charの不正使用検出 | E-05 (L109-126) | ○ |
| C-17 | DRT_WSPACEフラグでtWSPACEを返す | E-05 (L185-197) | ○ |

### db_expr.c (UT-DDB-056 -- UT-DDB-078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | ゼロ除算がdb_errorで報告される | E-07 (L184-186) | ○ |
| C-19 | 負のシフト量がdb_errorで報告される | E-07 (L255-259) | ○ |
| C-20 | 間接参照(*)がdb_get_valueを使用 | E-07 (L149-150) | ○ |
| C-21 | ドット(.)でdb_dotの値が参照される | E-07 (L70-73) | ○ |
| C-22 | 式評価の加減乗除でデフォルト基数(16進)が使用される | E-05 (L155), E-07 | △ |

### db_sym.c (UT-DDB-079 -- UT-DDB-098)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | MAXNOSYMTABS=3がシンボルテーブル上限 | E-08 (L54-56) | ○ |
| C-24 | db_add_symbol_tableが上限超過でpanic | E-08 (L179-181) | ○ |
| C-25 | db_eqnameがプレフィックス文字を考慮した比較 | E-08 (L208-216) | ○ |
| C-26 | db_search_symbolがPAGE_SIZE未満のアドレスを除外 | E-08 (L383-386) | ○ |
| C-27 | db_var_db_cpuが-1未満またはmp_maxid超過を拒否 | E-08 (L88-89) | ○ |
| C-28 | db_var_curcpuがSET操作を拒否(読み取り専用) | E-08 (L114-116) | ○ |

### db_command.c (UT-DDB-099 -- UT-DDB-115)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | コマンド登録が辞書順で行われる | E-10 (L250-271) | ○ |
| C-30 | 重複コマンド名が警告メッセージで拒否される | E-10 (L255-259) | ○ |
| C-31 | db_cmd_matchがCMD_UNIQUE/CMD_FOUND/CMD_AMBIGUOUSを設定 | E-10 (L293-324) | ○ |
| C-32 | helpコマンドがCMD_HELPとして検出される | E-10 (L343-347) | ○ |
| C-33 | db_hex2decが各桁を10進に変換し、a-fを含む場合-1を返す | E-10 (L930-947) | ○ |
| C-34 | db_errorがNULL引数を受け入れる | E-10 (L577-584) | ○ |

### db_watch.c (UT-DDB-116 -- UT-DDB-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | NWATCHPOINTS=100がウォッチポイント上限 | E-12 (L54) | ○ |
| C-36 | NULLマップが拒否される | E-12 (L102-105) | ○ |
| C-37 | 重複ウォッチポイントが検出される(addr+sizeで比較) | E-12 (L111-119) | ○ |
| C-38 | サイズ省略時デフォルト4が使用される | E-12 (L203-206) | ○ |

### db_script.c (UT-DDB-125 -- UT-DDB-146)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | DB_MAXSCRIPTS=8がスクリプト上限 | E-23 (L59) | ○ |
| C-40 | DB_MAXSCRIPTNAME=32が名前長上限 | E-23 (L63) | ○ |
| C-41 | DB_MAXSCRIPTLEN=128がスクリプト長上限 | E-23 (L67) | ○ |
| C-42 | DB_MAXSCRIPTRECURSION=3が再帰上限 | E-23 (L71) | ○ |
| C-43 | db_script_kdbenterがイベント名からスクリプト名を構築 | E-14 (L317-325) | ○ |
| C-44 | デフォルトスクリプト名が"kdb.enter.default" | E-14 (L121) | ○ |
| C-45 | db_command_trimmableが空白/タブ/改行/CRをトリム対象とする | E-14 (L227-240) | ○ |

### db_capture.c (UT-DDB-147 -- UT-DDB-163)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | キャプチャ未開始時にdb_capture_writeが何もしない | E-15 (L209) | ○ |
| C-47 | ページャ中にdb_capture_writeが何もしない | E-15 (L209) | ○ |
| C-48 | バッファ残量超過分が切り詰められる(min関数) | E-15 (L211) | ○ |
| C-49 | 二重開始で"Capture already started"が表示される | E-15 (L277-279) | ○ |
| C-50 | 未開始停止で"Capture not started"が表示される | E-15 (L293-295) | ○ |

### db_variables.c (UT-DDB-164 -- UT-DDB-169)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | FCN_NULLの場合valuepを直接参照/設定 | E-18 (L109-111, L121-122) | ○ |
| C-52 | 関数付き変数はDB_VAR_GET/DB_VAR_SETで呼ばれる | E-18 (L113, L125) | ○ |
| C-53 | 組み込み変数(radix, maxoff, maxwidth, tabstops, lines)が定義されている | E-18 (L42-54) | ○ |

### db_output.c (UT-DDB-170 -- UT-DDB-175)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | db_printfがkvprintfを使用してフォーマット出力 | E-16 (L336) | ○ |
| C-55 | db_end_lineがdb_max_width(79)を基準に改行判定 | E-16 (L386-391) | ○ |
| C-56 | db_enable_pagerがdb_lines_per_page(20)を設定 | E-16 (L227-235) | ○ |

### db_input.c (UT-DDB-176 -- UT-DDB-200)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | lsize < 2の場合db_readlineが0を返す | E-20 (L366-367) | ○ |
| C-58 | 履歴バッファが2048バイト | E-20 (L71) | ○ |
| C-59 | DB_RAW_SIZE=512がrawバッファサイズ | E-20 (L58) | ○ |
| C-60 | Ctrl-CでInterruptが発生 | E-20 (L436-438) | ○ |
| C-61 | ESCシーケンス[A/B/C/Dがカーソルキーにマッピングされる | E-20 (L144-159) | ○ |
| C-62 | バッファ末尾で文字入力時にベル出力 | E-20 (L297-299) | ○ |
| C-63 | 履歴のラップアラウンド(bcopyで回転) | E-20 (L395-399) | △ |

### db_textdump.c (UT-DDB-201 -- UT-DDB-212)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | TEXTDUMP_BLOCKSIZE=512がブロックサイズ | E-23 (L331) | ○ |
| C-65 | SIZEOF_METADATA=64*1024がメタデータ保護サイズ | E-21 (L85) | ○ |
| C-66 | ustar_checksumが空白文字で初期化後に全バイト合計 | E-21 (L188-200) | ○ |
| C-67 | textdump_writeblockがメディアサイズ超過でEIOを返す | E-21 (L245-246) | ○ |
| C-68 | textdump_writeblockがメタデータ領域でENOSPCを返す | E-21 (L247-248) | ○ |

### db_run.c (UT-DDB-213 -- UT-DDB-222)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | db_single_step_cmdがcount=-1をcount=1に変換 | E-22 (L233-234) | ○ |
| C-70 | db_continue_cmdの/cモディファイアでSTEP_COUNT | E-22 (L295-296) | ○ |
| C-71 | db_stop_at_pcでブレークポイントカウントダウン | E-22 (L99-105) | ○ |
| C-72 | IS_BREAKPOINT_TRAP/IS_WATCHPOINT_TRAPマクロの動作 | E-22 (L76-77) | △ |
| C-73 | FIXUP_PC_AFTER_BREAKのアーキテクチャ依存動作 | E-22 (L84-93) | △ |
| C-74 | inst_trap_return/inst_return/inst_callマクロの動作 | E-22 (L160-184) | △ |
| C-75 | db_restart_at_pcのins変数が未定義(L206-207) | E-22 (L196-208) | △ |

## 4) 不足情報（Unknown / Missing）
- **アーキテクチャ依存マクロ**: IS_BREAKPOINT_TRAP, IS_WATCHPOINT_TRAP, IS_SSTEP_TRAP, FIXUP_PC_AFTER_BREAK, inst_call, inst_return, inst_trap_return, inst_load, inst_store, BKPT_SIZE, BKPT_SET, BKPT_SKIP等はmachine/db_machdep.hで定義され、テスト環境のアーキテクチャに依存する
  - 候補: sys/amd64/include/db_machdep.h / sys/arm64/include/db_machdep.h / sys/i386/include/db_machdep.h
- **db_run.c L206-207**: `ins`変数が宣言なしで使用されている。これはコンパイル時にマクロ展開で解決される可能性があるが、コードリーディングでは不明
  - 候補: machine/db_machdep.h内のマクロ定義
- **kdb_* 関数群**: kdb_reenter, kdb_reenter_silent, kdb_thr_lookup等はsys/kern/kern_kdb.cで定義されており、DDBモジュール外の依存関係
  - 候補: sys/sys/kdb.h / sys/kern/kern_kdb.c
- **db_pprint.c, db_print.c, db_examine.c, db_ps.c, db_ctf.c, db_main.c, db_write_cmd.c, db_thread.c**: これらのソースファイルは本レポートでは詳細解析を行っておらず、テストケースが不足している可能性がある

## 5) リスクフラグ（レビュー観点）
- **1 (中リスク)**: db_run.cのdb_restart_at_pcにおけるins変数の使用(L206-207)がアーキテクチャ依存マクロに強く依存しており、一部アーキテクチャでコンパイルエラーまたは動作不良の可能性
- **1 (中リスク)**: db_expr.cの式評価でデフォルト基数が16進であるため、テストケースの入力値と期待結果の解釈に注意が必要
- **0 (低リスク)**: db_map_currentとdb_map_addrの現在の実装が定数返却(常にtrue/kernel_map)であり、将来変更時にテストケースの更新が必要
- **1 (中リスク)**: db_pprint.c, db_print.c, db_examine.c, db_ps.c, db_ctf.c, db_main.c, db_write_cmd.c, db_thread.cに対するテストケースが未生成

## 6) レビュアーチェックリスト（最小）
- [ ] db_access.cの符号拡張テスト(UT-DDB-005, 006)で、db_extend配列の値と実際の期待結果が整合しているか確認
- [ ] db_lex.cの数値解析テスト(UT-DDB-032-035)で、デフォルト基数16進での入力値解釈が正しいか確認
- [ ] db_break.cのNBREAKPOINTS=100、db_watch.cのNWATCHPOINTS=100の定数値が実際のソースと一致しているか確認
- [ ] db_script.cのDB_MAXSCRIPTS=8, DB_MAXSCRIPTNAME=32, DB_MAXSCRIPTLEN=128がddb.hの定義と一致しているか確認
- [ ] db_run.cのアーキテクチャ依存テストケース(UT-DDB-220-222)が対象アーキテクチャで有効か確認
- [ ] 未解析ファイル(db_pprint.c, db_print.c, db_examine.c等)に対するテストケースの追加要否を判断
- [ ] db_capture.cのDDB_CAPTURE_DEFAULTBUFSIZE(48*1024), DDB_CAPTURE_MAXBUFSIZE(5*1024*1024)が実際の定義と一致しているか確認
