---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 235
  claims_with_evidence: 221
  claims_without_evidence: 14
confidence_derived: 0.94
---

# 根拠レポート：filesystem 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：221 / 235、根拠なし：14
- 優先レビュー（高）
  1. **inotifyイベント通知テスト(UT-FS-234)**：vfs_inotify.cの内部実装の詳細が未確認
  2. **VFS拡張属性テスト(UT-FS-235)**：vfs_extattr.cのAPI仕様の詳細が未確認
  3. **一部の異常系テストケースの期待エラーコード**：実際のカーネルコードパスとエラーコードの対応を要確認

## 2) 参照した情報（Evidence一覧）
> 以下は実在するソースファイルから抽出した根拠です。

- E-01: `sys/kern/vfs_cache.c` - VFSネームキャッシュ実装（関数シグネチャ、NCF_INVALIDフラグ）
- E-02: `sys/kern/vfs_lookup.c` - VFS名前解決実装（namei, vfs_lookup, nameicap系関数）
- E-03: `sys/kern/vfs_mount.c` - VFSマウント管理実装（vfs_freeopt, vfs_deleteopt, vfs_buildopts等）
- E-04: `sys/kern/vfs_vnops.c` - VFS vnode操作実装（vn_open, vn_rdwr, vn_truncate等）
- E-05: `sys/kern/vfs_subr.c` - VFSサブルーチン（vtryrecycle, v_init_counters等）
- E-06: `sys/kern/vfs_bio.c` - バッファキャッシュ実装（buf_recycle, vfs_vmio系）
- E-07: `sys/kern/vfs_default.c` - デフォルトVOP実装（vop_std系関数）
- E-08: `sys/kern/vfs_acl.c` - ACL管理実装（acl_copyin, vacl_set_acl等）
- E-09: `sys/kern/vfs_hash.c` - vnodeハッシュテーブル実装（vfs_hash_get, vfs_hash_insert等）
- E-10: `sys/kern/vfs_init.c` - VFS初期化（vfs_byname, vfs_register等）
- E-11: `sys/kern/vfs_export.c` - NFSエクスポート管理（vfs_export, vfs_export_lookup等）
- E-12: `sys/kern/vfs_syscalls.c` - VFSシステムコール（kern_sync, kern_statfs, kern_openat等）
- E-13: `sys/ufs/ffs/ffs_alloc.c` - FFSブロック/inode割り当て（ffs_alloc, ffs_valloc等）
- E-14: `sys/ufs/ffs/ffs_vfsops.c` - FFS VFS操作（ffs_mount, ffs_unmount, ffs_sync等）
- E-15: `sys/ufs/ufs/ufs_vnops.c` - UFS vnode操作（ufs_create, ufs_remove, ufs_rename等）
- E-16: `sys/ufs/ufs/ufs_lookup.c` - UFSディレクトリ検索（ufs_lookup_ino, ufs_direnter等）
- E-17: `sys/fs/tmpfs/tmpfs_subr.c` - tmpfsサブルーチン（tmpfs_alloc_node, tmpfs_free_node等）
- E-18: `sys/fs/tmpfs/tmpfs_vnops.c` - tmpfs vnode操作（tmpfs_create, tmpfs_read, tmpfs_write等）
- E-19: `sys/fs/tmpfs/tmpfs_vfsops.c` - tmpfs VFS操作
- E-20: `sys/fs/nullfs/null_subr.c` - nullfsサブルーチン（null_hashget, null_nodeget等）
- E-21: `sys/fs/nullfs/null_vfsops.c` - nullfs VFS操作（nullfs_mount, nullfs_statfs等）
- E-22: `sys/fs/nullfs/null_vnops.c` - nullfs vnode操作（null_bypass, null_lookup等）
- E-23: `sys/fs/devfs/devfs_devs.c` - devfsデバイス管理（devfs_alloc, devfs_find等）
- E-24: `sys/fs/ext2fs/ext2_alloc.c` - ext2fsブロック/inode割り当て
- E-25: `sys/fs/ext2fs/ext2_acl.c` - ext2fs ACL処理
- E-26: `sys/fs/msdosfs/msdosfs_conv.c` - MSDOSFSファイル名変換
- E-27: `sys/fs/msdosfs/msdosfs_denode.c` - MSDOSFSデノード管理
- E-28: `sys/fs/msdosfs/msdosfs_fat.c` - MSDOSFSFATテーブル操作
- E-29: `sys/fs/unionfs/union_subr.c` - unionfsサブルーチン
- E-30: `sys/fs/unionfs/union_vfsops.c` - unionfs VFS操作
- E-31: `sys/fs/fuse/fuse_file.c` - FUSEファイルハンドル管理
- E-32: `sys/fs/fuse/fuse_device.c` - FUSEデバイス操作
- E-33: `sys/fs/procfs/procfs.c` - procfsメイン実装
- E-34: `sys/fs/procfs/procfs_map.c` - procfsメモリマップ
- E-35: `sys/fs/procfs/procfs_status.c` - procfsステータス
- E-36: `sys/kern/vfs_cluster.c` - クラスタI/O実装
- E-37: `sys/kern/vfs_inotify.c` - inotify実装
- E-38: `sys/kern/vfs_extattr.c` - 拡張属性実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-06 | VFSネームキャッシュ関連テスト（UT-FS-001〜006） | E-01 | ○ |
| C-07〜C-17 | VFS名前解決関連テスト（UT-FS-007〜017） | E-02 | ○ |
| C-18〜C-28 | VFSマウント管理テスト（UT-FS-018〜028） | E-03 | ○ |
| C-29〜C-40 | VFS vnode操作テスト（UT-FS-029〜040） | E-04 | ○ |
| C-41〜C-45 | VFSサブルーチンテスト（UT-FS-041〜045） | E-05 | ○ |
| C-46〜C-49 | バッファキャッシュテスト（UT-FS-046〜049） | E-06 | ○ |
| C-50〜C-58 | デフォルトVOP実装テスト（UT-FS-050〜058） | E-07 | ○ |
| C-59〜C-63 | ACL管理テスト（UT-FS-059〜063） | E-08 | ○ |
| C-64〜C-69 | vnodeハッシュテスト（UT-FS-064〜069） | E-09 | ○ |
| C-70〜C-71 | VFS初期化テスト（UT-FS-070〜071） | E-10 | ○ |
| C-72〜C-73 | NFSエクスポートテスト（UT-FS-072〜073） | E-11 | ○ |
| C-74〜C-86 | VFSシステムコールテスト（UT-FS-074〜086） | E-12 | ○ |
| C-87〜C-93 | FFSブロック割り当てテスト（UT-FS-087〜093） | E-13 | ○ |
| C-94〜C-105 | FFS VFS操作テスト（UT-FS-094〜105） | E-14 | ○ |
| C-106〜C-123 | UFS vnode操作テスト（UT-FS-106〜123） | E-15 | ○ |
| C-124〜C-135 | UFSディレクトリ操作テスト（UT-FS-124〜135） | E-16 | ○ |
| C-136〜C-146 | tmpfsサブルーチンテスト（UT-FS-136〜146） | E-17 | ○ |
| C-147〜C-166 | tmpfs vnode操作テスト（UT-FS-147〜166） | E-18 | ○ |
| C-167〜C-168 | tmpfs VFS操作テスト（UT-FS-167〜168） | E-19 | ○ |
| C-169〜C-172 | nullfsサブルーチンテスト（UT-FS-169〜172） | E-20 | ○ |
| C-173〜C-176 | nullfs VFS操作テスト（UT-FS-173〜176） | E-21 | ○ |
| C-177〜C-179 | nullfs vnode操作テスト（UT-FS-177〜179） | E-22 | ○ |
| C-180〜C-190 | devfsデバイス管理テスト（UT-FS-180〜190） | E-23 | ○ |
| C-191〜C-196 | ext2fsブロック割り当てテスト（UT-FS-191〜196） | E-24 | ○ |
| C-197〜C-199 | ext2fs ACLテスト（UT-FS-197〜199） | E-25 | ○ |
| C-200〜C-208 | MSDOSFSファイル名変換テスト（UT-FS-200〜208） | E-26 | ○ |
| C-209〜C-211 | MSDOSFSデノードテスト（UT-FS-209〜211） | E-27 | ○ |
| C-212〜C-213 | MSDOSFS FATテスト（UT-FS-212〜213） | E-28 | ○ |
| C-214〜C-216 | unionfsサブルーチンテスト（UT-FS-214〜216） | E-29 | ○ |
| C-217〜C-218 | unionfs VFS操作テスト（UT-FS-217〜218） | E-30 | ○ |
| C-219〜C-223 | FUSEファイルハンドルテスト（UT-FS-219〜223） | E-31 | ○ |
| C-224〜C-226 | FUSEデバイステスト（UT-FS-224〜226） | E-32 | ○ |
| C-227〜C-229 | procfs属性・可視性テスト（UT-FS-227〜229） | E-33 | ○ |
| C-230 | procfsメモリマップ出力テスト（UT-FS-230） | E-34 | ○ |
| C-231 | procfsステータス出力テスト（UT-FS-231） | E-35 | ○ |
| C-232〜C-233 | クラスタI/Oテスト（UT-FS-232〜233） | E-36 | △ |
| C-234 | inotifyイベント通知テスト（UT-FS-234） | E-37 | △ |
| C-235 | 拡張属性テスト（UT-FS-235） | E-38 | △ |

## 4) 不足情報（Unknown / Missing）
- **vfs_cluster.cの詳細実装**：cluster_read/cluster_writeの関数シグネチャは確認したが、内部の分岐条件やエッジケースは未詳細調査
  - 候補：sys/kern/vfs_cluster.c の詳細解析 / FreeBSDカーネルドキュメント
- **vfs_inotify.cの実装詳細**：関数シグネチャレベルの確認のみで、イベントタイプやフィルタリング仕様が未確認
  - 候補：sys/kern/vfs_inotify.c の詳細解析 / inotify(7)マニュアル
- **vfs_extattr.cのAPI仕様**：拡張属性の名前空間やサポートされる操作の詳細が未確認
  - 候補：sys/kern/vfs_extattr.c の詳細解析 / extattr(2)マニュアル
- **NFS client/server実装**：sys/fs/nfsclient/ および sys/fs/nfsserver/ の詳細実装は本テストケース一覧のスコープとして限定的にカバー
  - 候補：NFSクライアント/サーバーのソースコード詳細解析
- **cd9660, autofs, smbfs, portalfs, fdescfs, pseudofs**：これらのファイルシステム固有テストケースは生成対象から除外（テストケース数が膨大になるため主要FSに絞った）
  - 候補：各FS実装の詳細解析を別途実施
- **一部異常系のエラーコード**：カーネルコードパスが複雑で、特定の条件でどのエラーコードが返るかの確認が不十分な箇所あり（UT-FS-030のEACCES等）
  - 候補：関連カーネルコードの条件分岐の詳細確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: VFS基本操作（namei, vfs_lookup, vn_open等）のテストケース - ソースコードから直接確認済み
- **0（低リスク）**: UFS/FFS/tmpfs/nullfs/devfsのテストケース - 関数シグネチャと基本動作を確認済み
- **1（中リスク）**: ext2fs/msdosfs/unionfs/FUSEのテストケース - 関数シグネチャは確認したが内部ロジックの一部が未確認
- **1（中リスク）**: 異常系テストケースのエラーコード - カーネル内部のエラー伝播パスが複雑なため、一部のエラーコードが実際と異なる可能性
- **2（高リスク）**: inotify/extattr/clusterのテストケース - 実装詳細の確認が限定的
- **1（中リスク）**: cd9660, autofs, smbfs等の未カバーFS - テストケース対象から除外したFSが存在

## 6) レビュアーチェックリスト（最小）
- [ ] VFS層の基本操作（namei, vfs_lookup）のテストケースがFreeBSDのVFS仕様と整合しているか
- [ ] UFS/FFSのブロック/inode割り当てのエラーコード（ENOSPC等）がカーネル実装と一致するか
- [ ] tmpfsのメモリ管理テストが実際のページアロケーション機構と整合しているか
- [ ] nullfsのバイパス処理テストがスタック型FS設計と整合しているか
- [ ] msdosfsのファイル名変換テストがFAT仕様（8.3形式、LFN）と整合しているか
- [ ] devfsのデバイスツリー同期テストが実際のデバイス登録フローと整合しているか
- [ ] 権限チェック系テスト（ufs_chmod, chroot等）のエラーコードがFreeBSDセキュリティモデルと一致するか
- [ ] cd9660, autofs, smbfs, fdescfs, pseudofs等の未カバーFSについて追加テストが必要か評価する
- [ ] inotify, extattr関連テストの入力値・期待結果を実装コードで検証する
