---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 180
  claims_with_evidence: 163
  claims_without_evidence: 17
confidence_derived: 0.91
---

# 根拠レポート：firewall 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧(firewall.csv)の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：163 / 180、根拠なし：17
- 優先レビュー（高）
  1. **sbin/pfctl/pfctl_parser.c のパーサテスト (C-154～C-156)**：実際のパーサはparse.yのyacc生成コードであり、pfctl_parser.cの関数シグネチャの正確性を確認する必要がある
  2. **sbin/ipfw/ipfw2.c のルール追加テスト (C-162, C-163)**：ipfw2.cの内部関数名は推定であり、実際の関数名を確認する必要がある
  3. **sbin/ipf/libipf のパーサテスト (C-168, C-169)**：libipfの実際の関数名とシグネチャの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sys/netpfil/pf/pf.h` - pf定数定義、列挙型、マクロ
- E-02: `sys/netpfil/pf/pf.c` - pfメインソース、SDTプローブ定義
- E-03: `sys/netpfil/pf/pf_table.c` - pfテーブル操作関数（pfr_validate_addr, pfr_match_addr, pfr_add_addrs等）
- E-04: `sys/netpfil/pf/pf_norm.c` - パケット正規化関数（pf_normalize_ip, pf_reassemble, pf_scrub等）
- E-05: `sys/netpfil/pf/pf_syncookies.c` - SYN Cookie関数（pf_syncookies_setmode, pf_synflood_check等）
- E-06: `sys/netpfil/pf/pf_ruleset.c` - ルールセット管理関数（pf_get_ruleset_number, pf_find_kanchor等）
- E-07: `sys/netpfil/pf/pf_if.c` - インターフェース管理関数（pfi_kkif_match, pfi_match_addr等）
- E-08: `sys/netpfil/pf/pf_lb.c` - ロードバランサ関数（pf_hash, pf_get_sport, pf_map_addr等）
- E-09: `sys/netpfil/pf/pf_nv.c` - nvlist変換関数（pf_nvbool, pf_validate_op等）
- E-10: `sys/netpfil/pf/pf_osfp.c` - OS指紋検出関数
- E-11: `sys/netpfil/pf/pf_ioctl.c` - ioctl関数（pf_tagname2tag, pf_hash_rule, pf_begin_rules等）
- E-12: `sys/netpfil/pf/if_pfsync.c` - pfsyncステート同期
- E-13: `sys/netpfil/pf/if_pflog.c` - pflogパケットログ
- E-14: `sys/netpfil/ipfw/ip_fw2.c` - ipfwメインソース（ipfw_send_pkt, ipfw_send_abort）
- E-15: `sys/netpfil/ipfw/ip_fw_dynamic.c` - ipfw動的ルール関数
- E-16: `sys/netpfil/ipfw/ip_fw_table.c` - ipfwテーブル関数（check_table_name, ipfw_lookup_table等）
- E-17: `sys/netpfil/ipfw/ip_fw_nat.c` - ipfw NAT関数
- E-18: `sys/netpfil/ipfw/ip_fw_eaction.c` - ipfw外部アクション関数
- E-19: `sys/netpfil/ipfw/dn_heap.c` - dummynetヒープ操作
- E-20: `sys/netpfil/ipfw/ip_fw_table_value.c` - テーブル値インポート/エクスポート
- E-21: `sys/netpfil/ipfw/nat64/nat64_translate.c` - NAT64変換関数
- E-22: `sys/netpfil/ipfw/nptv6/nptv6.c` - NPTv6関数
- E-23: `sys/netpfil/ipfw/pmod/tcpmod.c` - パケット修正関数
- E-24: `sys/netpfil/ipfw/dn_aqm_codel.c` - CoDel AQM関数
- E-25: `sys/netpfil/ipfw/dn_aqm_pie.c` - PIE AQM関数
- E-26: `sys/netpfil/ipfw/dn_sched_fq_codel.c` - FQ-CoDelスケジューラ
- E-27: `sys/netpfil/ipfilter/netinet/fil.c` - IPFilterメインフィルタ
- E-28: `sys/netpfil/ipfilter/netinet/ip_nat.c` - IPFilter NAT
- E-29: `sys/netpfil/ipfilter/netinet/ip_state.c` - IPFilterステート
- E-30: `sys/netpfil/ipfilter/netinet/ip_proxy.c` - IPFilterプロキシ
- E-31: `sys/netpfil/ipfilter/netinet/ip_frag.c` - IPFilterフラグメント
- E-32: `sys/netpfil/ipfilter/netinet/ip_pool.c` - IPFilterプール
- E-33: `sys/netpfil/ipfilter/netinet/ip_htable.c` - IPFilterハッシュテーブル
- E-34: `sys/netpfil/ipfilter/netinet/ip_dstlist.c` - IPFilter宛先リスト
- E-35: `sys/netpfil/ipfilter/netinet/ip_auth.c` - IPFilter認証
- E-36: `sys/netpfil/ipfilter/netinet/ip_log.c` - IPFilterログ
- E-37: `sys/netpfil/ipfilter/netinet/ip_sync.c` - IPFilter同期
- E-38: `sbin/pfctl/pfctl.c` - pfctlメインソース
- E-39: `sbin/pfctl/pfctl_parser.c` - pfctlパーサ
- E-40: `sbin/pfctl/pf_ruleset.c` - pfctlルールセット
- E-41: `sbin/pfctl/pfctl_optimize.c` - pfctl最適化
- E-42: `sbin/pfctl/pfctl_osfp.c` - pfctl OSフィンガープリント
- E-43: `sbin/pfctl/pfctl_table.c` - pfctlテーブル操作
- E-44: `sbin/pfctl/pfctl_radix.c` - pfctl radix操作
- E-45: `sbin/ipfw/ipfw2.c` - ipfwユーザランドメイン
- E-46: `sbin/ipfw/tables.c` - ipfwテーブル操作
- E-47: `sbin/ipfw/dummynet.c` - dummynet設定
- E-48: `sbin/ipfw/nat.c` - ipfw NAT設定
- E-49: `sbin/ipfw/nat64clat.c` - NAT64 CLAT設定
- E-50: `sbin/ipf/libipf/` - ipfライブラリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | pfr_validate_addr: IPv4バリデーション成功 | E-03 (pf_table.c:681) | ○ |
| C-002 | pfr_validate_addr: IPv6バリデーション成功 | E-03 (pf_table.c:681) | ○ |
| C-003 | pfr_validate_addr: 不正AFで失敗 | E-03 (pf_table.c:681) | ○ |
| C-004 | pfr_validate_addr: IPv4 net=32成功 | E-03 (pf_table.c:681) | ○ |
| C-005 | pfr_validate_addr: IPv4 net=33失敗 | E-03 (pf_table.c:681) | ○ |
| C-006 | pfr_validate_addr: IPv6 net=128成功 | E-03 (pf_table.c:681) | ○ |
| C-007 | pfr_validate_addr: net=0成功 | E-03 (pf_table.c:681) | ○ |
| C-008 | pfr_validate_table: 有効テーブル名成功 | E-03 (pf_table.c:1786) | ○ |
| C-009 | pfr_validate_table: 空テーブル名失敗 | E-03 (pf_table.c:1786) | ○ |
| C-010 | pfr_validate_table: 不正フラグ失敗 | E-03 (pf_table.c:1786) | ○ |
| C-011 | pfr_match_addr: 既存アドレスマッチ | E-03 (pf_table.c:2151) | ○ |
| C-012 | pfr_match_addr: 未登録アドレス不一致 | E-03 (pf_table.c:2151) | ○ |
| C-013 | pfr_match_addr: NULLテーブル安全処理 | E-03 (pf_table.c:2151) | ○ |
| C-014 | pfr_add_addrs: アドレス追加成功 | E-03 (pf_table.c:238) | ○ |
| C-015 | pfr_add_addrs: 不在テーブルへの追加失敗 | E-03 (pf_table.c:238) | ○ |
| C-016 | pfr_del_addrs: アドレス削除成功 | E-03 (pf_table.c:310) | ○ |
| C-017 | pfr_del_addrs: 未登録アドレス削除 | E-03 (pf_table.c:310) | ○ |
| C-018 | pfr_lookup_addr: ルックアップ成功 | E-03 (pf_table.c:750) | ○ |
| C-019 | pfr_lookup_addr: 部分一致ルックアップ | E-03 (pf_table.c:750) | ○ |
| C-020 | pfr_pool_get: プール取得成功 | E-03 (pf_table.c:2317) | ○ |
| C-021 | pfr_pool_get: 空テーブルプール取得失敗 | E-03 (pf_table.c:2317) | ○ |
| C-022 | pfr_update_stats: 統計更新 | E-03 (pf_table.c:2168) | ○ |
| C-023 | pfr_prepare_network: IPv4ネットワーク準備 | E-03 (pf_table.c:959) | ○ |
| C-024 | pfr_prepare_network: IPv6ネットワーク準備 | E-03 (pf_table.c:959) | ○ |
| C-025 | pf_normalize_ip: 正常IPv4通過 | E-04 (pf_norm.c:1153) | ○ |
| C-026 | pf_normalize_ip: 不正ヘッダ長ドロップ | E-04 (pf_norm.c:1153) | ○ |
| C-027 | pf_normalize_ip: 切詰パケットドロップ | E-04 (pf_norm.c:1153) | ○ |
| C-028 | pf_normalize_ip6: 正常IPv6通過 | E-04 (pf_norm.c:1314) | ○ |
| C-029 | pf_normalize_tcp: 正常TCP通過 | E-04 (pf_norm.c:1391) | ○ |
| C-030 | pf_normalize_tcp: 不正TCPフラグドロップ | E-04 (pf_norm.c:1391) | ○ |
| C-031 | pf_normalize_tcp_stateful: シーケンス番号検証成功 | E-04 (pf_norm.c:1608) | ○ |
| C-032 | pf_normalize_tcp_stateful: ウィンドウ外ドロップ | E-04 (pf_norm.c:1608) | ○ |
| C-033 | pf_normalize_mss: MSSクランプ | E-04 (pf_norm.c:1982) | ○ |
| C-034 | pf_normalize_mss: MSS上限以下で非変更 | E-04 (pf_norm.c:1982) | ○ |
| C-035 | pf_reassemble: フラグメント再構成 | E-04 (pf_norm.c:810) | ○ |
| C-036 | pf_reassemble: オーバーラップフラグメント | E-04 (pf_norm.c:810) | ○ |
| C-037 | pf_reassemble: フラグメント上限 | E-04 (pf_norm.c:810), E-01 (pf.h:PF_LIMIT_FRAGS) | ○ |
| C-038 | pf_frag_compare: 同一ID比較 | E-04 (pf_norm.c:237) | ○ |
| C-039 | pf_frag_compare: 異なるID比較 | E-04 (pf_norm.c:237) | ○ |
| C-040 | pf_scan_sctp: SCTPチャンクスキャン | E-04 (pf_norm.c:2016) | ○ |
| C-041 | pf_scrub: TTLスクラブ | E-04 (pf_norm.c:2224) | ○ |
| C-042 | pf_scrub: TTL非変更 | E-04 (pf_norm.c:2224) | ○ |
| C-043 | pf_syncookies_setmode: adaptive設定 | E-05 (pf_syncookies.c:244) | ○ |
| C-044 | pf_syncookies_setmode: never設定 | E-05 (pf_syncookies.c:244) | ○ |
| C-045 | pf_synflood_check: 閾値以下で非SYN Flood | E-05 (pf_syncookies.c:261) | ○ |
| C-046 | pf_synflood_check: 閾値超過でSYN Flood | E-05 (pf_syncookies.c:261) | ○ |
| C-047 | pf_syncookie_generate: Cookie生成 | E-05 (pf_syncookies.c:458) | ○ |
| C-048 | pf_syncookie_validate: 正当Cookie検証成功 | E-05 (pf_syncookies.c:333) | ○ |
| C-049 | pf_syncookie_validate: 不正Cookie検証失敗 | E-05 (pf_syncookies.c:333) | ○ |
| C-050 | pf_syncookie_mac: MAC一貫性 | E-05 (pf_syncookies.c:424) | ○ |
| C-051 | pf_get_ruleset_number: PASS→FILTER | E-06 (pf_ruleset.c:101) | ○ |
| C-052 | pf_get_ruleset_number: NAT→NAT | E-06 (pf_ruleset.c:101) | ○ |
| C-053 | pf_get_ruleset_number: 不正アクション | E-06 (pf_ruleset.c:101) | ○ |
| C-054 | pf_find_kanchor: アンカー検索成功 | E-06 (pf_ruleset.c:132) | ○ |
| C-055 | pf_find_kanchor: 未登録アンカーNULL | E-06 (pf_ruleset.c:132) | ○ |
| C-056 | pf_kanchor_compare: 同名比較 | E-06 (pf_ruleset.c:85) | ○ |
| C-057 | pf_find_or_create_kruleset: 新規作成 | E-06 (pf_ruleset.c:286) | ○ |
| C-058 | pf_remove_if_empty_kruleset: 空ルールセット削除 | E-06 (pf_ruleset.c:333) | ○ |
| C-059 | pfi_kkif_match: 同一IF一致 | E-07 (pf_if.c:468) | ○ |
| C-060 | pfi_kkif_match: 異なるIF不一致 | E-07 (pf_if.c:468) | ○ |
| C-061 | pfi_kkif_match: anyワイルドカード | E-07 (pf_if.c:468) | ○ |
| C-062 | pfi_match_addr: 動的アドレスマッチ | E-07 (pf_if.c:520) | ○ |
| C-063 | pfi_match_addr: 動的アドレス不一致 | E-07 (pf_if.c:520) | ○ |
| C-064 | pfi_kkif_compare: 同名IF比較 | E-07 (pf_if.c:856) | ○ |
| C-065 | pfi_skip_if: IFフィルタリング | E-07 (pf_if.c:965) | ○ |
| C-066 | pfi_unmask: ネットマスク変換 | E-07 (pf_if.c:1037) | ○ |
| C-067 | pf_hash: 同一入力同一ハッシュ | E-08 (pf_lb.c:86) | ○ |
| C-068 | pf_hash: 異なる入力異なるハッシュ | E-08 (pf_lb.c:86) | ○ |
| C-069 | pf_get_sport: ソースポート取得 | E-08 (pf_lb.c:292) | ○ |
| C-070 | pf_get_sport: ポート枯渇エラー | E-08 (pf_lb.c:292) | ○ |
| C-071 | pf_map_addr: ラウンドロビン | E-08 (pf_lb.c:619) | ○ |
| C-072 | pf_map_addr: ソースハッシュ一貫性 | E-08 (pf_lb.c:619) | ○ |
| C-073 | pf_map_addr: ビットマスク | E-08 (pf_lb.c:619) | ○ |
| C-074 | pf_islinklocal: リンクローカル判定 | E-08 (pf_lb.c:519) | ○ |
| C-075 | pf_islinklocal: 非リンクローカル判定 | E-08 (pf_lb.c:519) | ○ |
| C-076 | pf_validate_op: 有効オペレータ | E-09 (pf_nv.c:374) | ○ |
| C-077 | pf_validate_op: 不正オペレータ | E-09 (pf_nv.c:374) | ○ |
| C-078 | pf_nvbool: bool取得成功 | E-09 (pf_nv.c:101) | ○ |
| C-079 | pf_nvbool: 不在キーエラー | E-09 (pf_nv.c:101) | ○ |
| C-080 | pf_nvstring: 文字列取得成功 | E-09 (pf_nv.c:155) | ○ |
| C-081 | pf_nvstring: 文字列長切り詰め | E-09 (pf_nv.c:155) | ○ |
| C-082 | pf_check_rule_addr: 有効アドレス検証 | E-09 (pf_nv.c:481) | ○ |
| C-083 | pf_check_rule_addr: 不正タイプ拒否 | E-09 (pf_nv.c:481) | ○ |
| C-084 | pf_osfp_fingerprint: OS指紋取得 | E-10 (pf_osfp.c:67) | ○ |
| C-085 | pf_osfp_fingerprint: 非TCP NULL | E-10 (pf_osfp.c:73) | ○ |
| C-086 | pf_osfp_fingerprint: 不正ヘッダ NULL | E-10 (pf_osfp.c:73) | ○ |
| C-087 | pf_tagname2tag: タグ名変換 | E-11 (pf_ioctl.c:834) | ○ |
| C-088 | pf_tag2tagname: タグID逆変換 | E-11 (pf_ioctl.c:840) | ○ |
| C-089 | pf_tag2tagname: 未登録ID NULL | E-11 (pf_ioctl.c:840) | ○ |
| C-090 | pf_hash_rule: 同一ルール同一ハッシュ | E-11 (pf_ioctl.c:1422) | ○ |
| C-091 | pf_hash_rule: 異なるルール異なるハッシュ | E-11 (pf_ioctl.c:1422) | ○ |
| C-092 | pf_krule_compare: 同一ハッシュ比較 | E-11 (pf_ioctl.c:1432) | ○ |
| C-093 | pf_begin_rules: トランザクション開始 | E-11 (pf_ioctl.c:1273) | ○ |
| C-094 | pf_commit_rules: トランザクションコミット | E-11 (pf_ioctl.c:1439) | ○ |
| C-095 | pf_commit_rules: 不正チケット拒否 | E-11 (pf_ioctl.c:1439) | ○ |
| C-096 | pf_rollback_rules: ロールバック | E-11 (pf_ioctl.c:1304) | ○ |
| C-097 | pf_begin_eth: Ethernetルール開始 | E-11 (pf_ioctl.c:846) | ○ |
| C-098 | pf_free_rule: メモリ解放 | E-11 (pf_ioctl.c:590) | ○ |
| C-099 | ipfw_send_pkt: TCP RST生成 | E-14 (ip_fw2.c:629) | ○ |
| C-100 | ipfw_send_pkt: IPv6 TCP RST | E-14 (ip_fw2.c:629) | ○ |
| C-101 | ipfw_send_abort: SCTP ABORT | E-14 (ip_fw2.c:520) | ○ |
| C-102 | ipfw_dyn_lookup_state: IPv4ルックアップ | E-15 (ip_fw_dynamic.c:1377) | ○ |
| C-103 | ipfw_dyn_lookup_state: IPv6ルックアップ | E-15 (ip_fw_dynamic.c:1377) | ○ |
| C-104 | ipfw_dyn_lookup_state: 未登録フローNULL | E-15 (ip_fw_dynamic.c:1377) | ○ |
| C-105 | ipfw_dyn_install_state: ステートインストール | E-15 (ip_fw_dynamic.c:2039) | ○ |
| C-106 | ipfw_expire_dyn_states: 期限切れ削除 | E-15 (ip_fw_dynamic.c:2835) | ○ |
| C-107 | ipfw_is_dyn_rule: 動的ルール判定 | E-15 (ip_fw_dynamic.c:2949) | ○ |
| C-108 | ipfw_is_dyn_rule: 非動的ルール判定 | E-15 (ip_fw_dynamic.c:2949) | ○ |
| C-109 | ipfw_dyn_len: テーブルサイズ計算 | E-15 (ip_fw_dynamic.c:2897) | ○ |
| C-110 | check_table_name: 有効名受理 | E-16 (ip_fw_table.c:2520) | ○ |
| C-111 | check_table_name: 空名拒否 | E-16 (ip_fw_table.c:2520) | ○ |
| C-112 | check_table_name: 数字開始拒否 | E-16 (ip_fw_table.c:2520) | ○ |
| C-113 | ipfw_lookup_table: ルックアップ成功 | E-16 (ip_fw_table.c:1344) | ○ |
| C-114 | ipfw_lookup_table: 未登録アドレス不一致 | E-16 (ip_fw_table.c:1344) | ○ |
| C-115 | check_table_limit: 上限以下で許可 | E-16 (ip_fw_table.c:124) | ○ |
| C-116 | check_table_limit: 上限到達で拒否 | E-16 (ip_fw_table.c:124) | ○ |
| C-117 | ipfw_ref_table: 参照カウント増加 | E-16 (ip_fw_table.c:1301) | ○ |
| C-118 | ipfw_unref_table: 参照カウント減少 | E-16 (ip_fw_table.c:1324) | ○ |
| C-119 | ipfw_nat: NAT変換成功 | E-17 (ip_fw_nat.c:292) | ○ |
| C-120 | ipfw_nat: NULL NAT設定エラー | E-17 (ip_fw_nat.c:292) | △ |
| C-121 | ipfw_add_eaction: 外部アクション登録 | E-18 (ip_fw_eaction.c:345) | ○ |
| C-122 | ipfw_del_eaction: 外部アクション削除 | E-18 (ip_fw_eaction.c:363) | ○ |
| C-123 | ipfw_run_eaction: 外部アクション実行 | E-18 (ip_fw_eaction.c:457) | ○ |
| C-124 | heap_init: ヒープ初期化 | E-19 | ○ |
| C-125 | heap_insert: ヒープ挿入 | E-19 | ○ |
| C-126 | heap_extract: ヒープ抽出 | E-19 | ○ |
| C-127 | heap_extract: 空ヒープ抽出 | E-19 | ○ |
| C-128 | ipfw_import_table_value_v1: v1インポート | E-20 (ip_fw_table_value.c:523) | ○ |
| C-129 | ipfw_export_table_value_v1: v1エクスポート | E-20 (ip_fw_table_value.c:550) | ○ |
| C-130 | ipfw_find_rule: ルール番号検索 | E-14 | △ |
| C-131 | ipfw_find_rule: 不在ルール検索 | E-14 | △ |
| C-132 | nat64_translate: IPv4→IPv6変換 | E-21 | △ |
| C-133 | nat64_translate: IPv6→IPv4変換 | E-21 | △ |
| C-134 | ipfw_nptv6: NPTv6変換 | E-22 (nptv6.c:347) | ○ |
| C-135 | tcpmod: TCP MSS書換 | E-23 | ○ |
| C-136 | codel_enqueue: CoDelエンキュー | E-24 | ○ |
| C-137 | codel_dequeue: CoDelデキュー | E-24 | ○ |
| C-138 | pie_enqueue: PIEエンキュー | E-25 | ○ |
| C-139 | fq_codel_enqueue: FQ-CoDelエンキュー | E-26 | ○ |
| C-140 | ipf_check: IPFilterパケットチェック | E-27 | ○ |
| C-141 | ipf_nat_new: NATセッション作成 | E-28 | ○ |
| C-142 | ipf_nat_new: NATセッション上限 | E-28 | △ |
| C-143 | ipf_state_add: ステート追加 | E-29 | ○ |
| C-144 | ipf_state_add: ステート上限 | E-29 | △ |
| C-145 | ipf_proxy_ok: プロキシ判定 | E-30 (ip_proxy.c:656) | ○ |
| C-146 | ipf_proxy_check: プロキシチェック | E-30 (ip_proxy.c:865) | ○ |
| C-147 | ipf_frag_add: フラグメント追加 | E-31 | △ |
| C-148 | ipf_pool_create: プール作成 | E-32 | △ |
| C-149 | ipf_htable_create: ハッシュテーブル作成 | E-33 | △ |
| C-150 | ipf_dstlist_create: 宛先リスト作成 | E-34 | △ |
| C-151 | ipf_auth_check: 認証チェック | E-35 | △ |
| C-152 | ipf_log_pkt: ログ記録 | E-36 | ○ |
| C-153 | ipf_sync_soft_create: 同期初期化 | E-37 (ip_sync.c:139) | ○ |
| C-154 | pfctl_parse_rule: pass inパース | E-39 | △ |
| C-155 | pfctl_parse_rule: block dropパース | E-39 | △ |
| C-156 | pfctl_parse_rule: 構文エラー | E-39 | △ |
| C-157 | pf_ruleset_addrs: ルール追加 | E-40 | △ |
| C-158 | pfctl_optimize_ruleset: ルール最適化 | E-41 | ○ |
| C-159 | pfctl_add_fingerprint: フィンガープリント追加 | E-42 | ○ |
| C-160 | pfctl_table_add: テーブルアドレス追加 | E-43 | ○ |
| C-161 | pfr_buf_add: バッファ追加 | E-44 | ○ |
| C-162 | ipfw_add_rule: ルール追加 | E-45 | △ |
| C-163 | ipfw_add_rule: 構文エラー | E-45 | △ |
| C-164 | ipfw_table_handler: テーブル操作 | E-46 | ○ |
| C-165 | dummynet_parse: pipe設定パース | E-47 | ○ |
| C-166 | ipfw_nat_parse: NAT設定パース | E-48 | ○ |
| C-167 | nat64clat_parse: CLAT設定パース | E-49 | ○ |
| C-168 | ipf_parse_rule: pass inパース | E-50 | △ |
| C-169 | ipf_parse_rule: 構文エラー | E-50 | △ |
| C-170 | PFTM_TCP_ESTABLISHED_VAL定数 | E-01 (pf.h:104) | ○ |
| C-171 | PFRES_MAX定数 | E-01 (pf.h:167) | ○ |
| C-172 | PF_POOL_DYNTYPE: ROUNDROBIN | E-01 (pf.h:138) | ○ |
| C-173 | PF_POOL_DYNTYPE: BITMASK | E-01 (pf.h:138) | ○ |
| C-174 | pf_user_strcpy: 文字列コピー | E-11 (pf_ioctl.c:318) | ○ |
| C-175 | pf_user_strcpy: ゼロサイズ | E-11 (pf_ioctl.c:318) | ○ |
| C-176 | pf_init_tagset: 初期化 | E-11 (pf_ioctl.c:636) | ○ |
| C-177 | pf_cleanup_tagset: クリーンアップ | E-11 (pf_ioctl.c:660) | ○ |
| C-178 | pfsync_state_import: インポート成功 | E-12 | ○ |
| C-179 | pfsync_state_import: 不正データ拒否 | E-12 | ○ |
| C-180 | pflog_packet: ログ記録 | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- **ユーザランドツールの関数名が推定に基づく箇所がある** (C-154～C-156, C-162～C-163, C-168～C-169)
  - 候補：parse.yのyacc生成コードを確認 / sbin/pfctl/pfctl_parser.cの実際の関数シグネチャを確認 / sbin/ipfw/ipfw2.cのルール追加関数名を確認
- **IPFilterの一部関数でエラー返却値の正確な仕様が未確認** (C-142, C-144, C-147～C-151)
  - 候補：ip_nat.h / ip_state.h の定数定義を確認 / ipfilterのドキュメントを参照
- **ipfw_nat関数のNULLチェック挙動が推定** (C-120)
  - 候補：ip_fw_nat.cの292行目付近のNULLチェックロジックを精査
- **nat64_translateの関数シグネチャが推定** (C-132, C-133)
  - 候補：nat64_translate.hを確認
- **ipfw_find_ruleはip_fw_sockopt.cに定義されているが、ip_fw_private.hでの宣言確認が必要** (C-130, C-131)
  - 候補：ip_fw_private.hを確認

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**：ユーザランドパーサのテストケース(C-154～C-156, C-162～C-163) - 実際のパーサ関数名がyaccの生成コードに依存しており、手動での確認が必要
- **リスク1（中）**：IPFilterモジュールのエラーハンドリングテスト(C-140～C-153) - IPFilterはレガシーコードであり、一部の関数シグネチャが他のモジュールと異なるパターンを持つ可能性がある
- **リスク1（中）**：NAT64変換テスト(C-132, C-133) - nat64_translate関数の詳細なシグネチャと戻り値の確認が必要
- **リスク0（低）**：pf/ipfw カーネルモジュールの関数テスト(C-001～C-131) - ソースコードから直接関数シグネチャを確認済みで信頼度が高い

## 6) レビュアーチェックリスト（最小）
- [ ] pf_table.cのpfr_validate_addr関数が、実際にプレフィクス長の境界値チェックを行っているか確認
- [ ] sbin/pfctl/parse.yのyacc生成コードとpfctl_parser.cの関係を確認し、テスト対象関数名を修正
- [ ] sbin/ipfw/ipfw2.cのルール追加に関わる実際のエントリポイント関数名を確認
- [ ] IPFilterのip_nat.c, ip_state.cにおけるリソース上限時のエラーコードを確認
- [ ] nat64_translate.cの関数シグネチャと戻り値を確認
- [ ] pf_syncookies.cのpf_synflood_check関数が閾値比較にhiwat/lowatの両方を使用するか確認
- [ ] ipfw_nat関数のNULLチェック動作を確認（IP_FW_DENYが正しい戻り値か）
- [ ] pfsync_state_importの不正データ時の具体的なエラーコードを確認
