---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：geom-storage 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **g_io_transient_map_bio関連テスト**：仮想メモリサブシステムとの結合テストの観点が不足
  2. **g_mirror/g_eli/g_raid等のGEOMクラス固有テスト**：ヘッダファイルのみの解析で実装詳細が不足
  3. **geom_event.cのイベントハンドリング**：内部構造（g_event）の詳細がstatic定義のため確認困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sys/geom/geom.h` - GEOM公開API定義、構造体定義（g_class, g_geom, g_consumer, g_provider）
- E-02: `sys/geom/geom_subr.c` - GEOMコアサブルーチン実装（g_new_geom, g_attach, g_access等）
- E-03: `sys/geom/geom_io.c` - GEOM I/Oサブシステム実装（g_io_request, g_io_deliver, g_io_check等）
- E-04: `sys/geom/geom_disk.c` - ディスクGEOMクラス実装（g_disk_access, g_disk_start, disk_alloc等）
- E-05: `sys/geom/geom_ctl.c` - GEOM制御インターフェース実装（gctl_error等）
- E-06: `sys/geom/geom_event.c` - GEOMイベントシステム実装（g_waitidle等）
- E-07: `sys/geom/stripe/g_stripe.h` - GEOMストライプメタデータ定義とエンコード/デコード関数
- E-08: `sys/geom/concat/g_concat.h` - GEOMコンカットメタデータ定義とエンコード/デコード関数
- E-09: `sys/geom/mirror/g_mirror.h` - GEOMミラーメタデータ定義とフラグ定数
- E-10: `sys/geom/eli/g_eli.h` - GELI暗号化メタデータ定義とフラグ定数
- E-11: `sys/geom/geom_int.h` - GEOM内部ヘッダ（暗黙的に参照）
- E-12: `sys/geom/geom_disk.h` - ディスクGEOMクラスヘッダ（暗黙的に参照）
- E-13: `sys/geom/part/g_part.h` - パーティションGEOMクラスヘッダ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-GEO-001~002) | g_new_geomがgeomを正しく初期化しclassのメソッドを継承する | E-02 (L372-401) | ○ |
| C-02 (UT-GEO-003~004) | g_destroy_geomがKASSERTでconsumer/provider空を検証後にリスト削除とメモリ解放を行う | E-02 (L420-437) | ○ |
| C-03 (UT-GEO-005~006) | g_new_consumerがorphan必須とWITHERチェックを行う | E-02 (L529-549) | ○ |
| C-04 (UT-GEO-007~008) | g_destroy_consumerがprovider未接続とacr/acw/ace==0をKASSERTで検証する | E-02 (L551-570) | ○ |
| C-05 (UT-GEO-009~010) | g_new_providerfがaccess/start必須チェック、初期error=ENXIOで作成する | E-02 (L609-645) | ○ |
| C-06 (UT-GEO-011~012) | g_destroy_providerがconsumers空検証後にprovidergoneコールバック呼び出しとメモリ解放を行う | E-02 (L798-826) | ○ |
| C-07 (UT-GEO-013~016) | g_attachがWITHER/ORPHANチェック、ループ検出（redo_rank→ELOOP）を行う | E-02 (L897-919, L845-895) | ○ |
| C-08 (UT-GEO-017) | g_detachがconsumer切断、redo_rank呼び出しを行う | E-02 (L921-943) | ○ |
| C-09 (UT-GEO-018~024) | g_accessがspoil、排他制御（EPERM）、エラー状態チェック、SPOILEDチェック、NOPアサートを行う | E-02 (L952-1092) | ○ |
| C-10 (UT-GEO-025~029) | g_handleattrが文字列/バイナリ属性のコピー、名前不一致フィルタ、長さ不一致エラーを処理する | E-02 (L1122-1149) | ○ |
| C-11 (UT-GEO-030~033) | g_provider_by_nameが/dev/プレフィックス除去、WITHERフォールバック検索を行う | E-02 (L770-796) | ○ |
| C-12 (UT-GEO-034~036) | g_compare_namesがada/adプレフィックス互換比較を行う | E-02 (L1342-1358) | ○ |
| C-13 (UT-GEO-037~038) | g_wither_geomがWITHERフラグ設定と全providerへのg_orphan_provider呼び出しを行う | E-02 (L443-457) | ○ |
| C-14 (UT-GEO-039~041) | g_resize_providerが同一サイズスキップ、WITHERガードを行う | E-02 (L752-768) | ○ |
| C-15 (UT-GEO-042) | g_spoilが指定consumer以外にSPOILEDフラグを設定する | E-02 (L1244-1264) | ○ |
| C-16 (UT-GEO-043~046) | g_std_access/done/spoiledの動作 | E-02 (L1151-1206) | ○ |
| C-17 (UT-GEO-047~049) | g_media_changed/g_retasteの動作 | E-02 (L1289-1370) | ○ |
| C-18 (UT-GEO-050~052) | g_modeventのMOD_LOAD/UNLOAD/バージョンチェック | E-02 (L250-300) | ○ |
| C-19 (UT-GEO-053~054) | g_provider_add_aliasの重複防止 | E-02 (L647-676) | ○ |
| C-20 (UT-GEO-055~063) | BIO管理関数（g_new_bio/g_alloc_bio/g_clone_bio/g_duplicate_bio/g_reset_bio） | E-03 (L143-273) | ○ |
| C-21 (UT-GEO-064~067) | g_io_request/g_io_deliverのディスパッチ/完了通知/ENOMEMリトライ | E-03 (L494-716) | ○ |
| C-22 (UT-GEO-068~079) | g_io_checkのアクセス権、セクタアライメント、範囲チェック、ゼロ長、メディア不在 | E-03 (L392-492) | ○ |
| C-23 (UT-GEO-080~087) | g_read_data/g_write_data/g_delete_data/g_io_flush/g_io_getattr | E-03 (L878-991) | ○ |
| C-24 (UT-GEO-088~089) | g_format_bioのフォーマット出力 | E-03 (L1022-1089) | ○ |
| C-25 (UT-GEO-090~094) | g_disk_accessの初回オープン/最終クローズ/破壊済み/書き込み保護 | E-04 (L99-173) | ○ |
| C-26 (UT-GEO-095~102) | g_disk_startのBIO_READ/WRITE/DELETE/FLUSH/GETATTR/メモリ枯渇 | E-04 (L429-589) | ○ |
| C-27 (UT-GEO-103~106) | g_disk_done/g_disk_ioctlの動作 | E-04 (L226-288) | ○ |
| C-28 (UT-GEO-107~112) | disk_alloc/disk_create/disk_destroyのライフサイクル | E-04 (L872-942) | ○ |
| C-29 (UT-GEO-113~117) | disk_gone/disk_resize/disk_add_aliasの動作 | E-04 (L944-1061) | ○ |
| C-30 (UT-GEO-118~119) | g_disk_ident_adjustの非印字文字変換 | E-04 (L851-870) | ○ |
| C-31 (UT-GEO-120~123) | g_disk_maxsize/g_disk_limitのI/Oサイズ制限と分割 | E-04 (L290-427) | ○ |
| C-32 (UT-GEO-124~126) | gctl_errorのエラーメッセージ記録とNULLチェック | E-05 (L78-100) | ○ |
| C-33 (UT-GEO-127) | g_waitidleのイベント待機 | E-06 (L79-93) | ○ |
| C-34 (UT-GEO-128~130) | stripe_metadata_encode/decodeのラウンドトリップ | E-07 (L83-110) | ○ |
| C-35 (UT-GEO-131~133) | concat_metadata_encode/decodeのラウンドトリップ | E-08 (L91-116) | ○ |
| C-36 (UT-GEO-134~138) | g_valid_objのオブジェクト種別判定 | E-02 (L1368-1396) | ○ |
| C-37 (UT-GEO-139~140) | g_error_providerのエラーコード設定/クリア | E-02 (L678-684) | ○ |
| C-38 (UT-GEO-141~142) | g_getattr__のサイズ検証 | E-02 (L1309-1321) | ○ |
| C-39 (UT-GEO-143) | g_wither_geom_closeのアクセス解放とwither | E-02 (L474-486) | ○ |
| C-40 (UT-GEO-144~149) | g_disk_setstate/g_disk_providergone/disk_attr_changedの動作 | E-04 (L200-224, L799-821, L1005-1019) | ○ |
| C-41 (UT-GEO-150) | disk_attr_changedのdevctl通知 | E-04 (L1005-1019) | ○ |
| C-42 | g_mirror/g_eli/g_raid等クラス固有の詳細テスト | **根拠不足** | △ |
| C-43 | g_io_transient_map_bioのvm連携テスト | **根拠不足** | △ |
| C-44 | geom_event.cの内部イベントキュー管理の詳細テスト | **根拠不足** | △ |
| C-45 | g_part系パーティション操作の詳細テスト | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **g_mirror.c/g_eli.c等のGEOMクラス実装詳細**：ヘッダファイルからフラグ定数やメタデータ構造は確認できたが、各クラスの実装ファイルは全件を精読していない。テストケースはコアフレームワークとディスクGEOMクラスに集中している。
  - 候補：`sys/geom/mirror/g_mirror.c` / `sys/geom/eli/g_eli.c` / `sys/geom/raid/g_raid.c`
- **geom_event.cの内部実装詳細**：g_event構造体はstaticで外部非公開のため、イベントキュー管理の完全なテスト設計には実装の深い理解が必要。
  - 候補：`sys/geom/geom_event.c` の全体解析
- **geom_dev.c（デバイスノード管理）**：デバイスノードの作成・削除テストは含まれていない。
  - 候補：`sys/geom/geom_dev.c`
- **geom_vfs.c/geom_kern.c**：VFS統合やカーネルスレッド管理のテストは含まれていない。
  - 候補：`sys/geom/geom_vfs.c` / `sys/geom/geom_kern.c`

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**：GEOMクラス固有テスト（mirror/eli/stripe/concat/part/raid等）が主にメタデータのエンコード/デコードに限定されている。各クラスのstart/taste/ctlreqメソッドの単体テストは別途必要。
- **リスク0（低）**：コアフレームワーク（geom_subr.c/geom_io.c）のテストは主要な公開APIを網羅しており、正常系・異常系・境界値の観点が含まれている。
- **リスク0（低）**：ディスクGEOMクラス（geom_disk.c）のテストはライフサイクル管理、I/Oディスパッチ、アクセス制御を網羅している。
- **リスク1（中）**：カーネル内テスト実行の制約により、KASSERT検証テストの実際の実行可能性にはDIAGNOSTICビルドが必要。

## 6) レビュアーチェックリスト（最小）
- [ ] geom_subr.cの公開API（g_new_geom, g_attach, g_access等）が網羅されているか
- [ ] geom_io.cのI/Oパス（g_io_request→g_io_check→start→g_io_deliver）が網羅されているか
- [ ] geom_disk.cのディスクライフサイクル（disk_alloc→disk_create→disk_gone→disk_destroy）が網羅されているか
- [ ] g_io_checkのセクタアライメント/範囲チェック/アクセス権チェックが十分か
- [ ] メタデータエンコード/デコードのラウンドトリップテストが含まれているか
- [ ] GEOMクラス固有テスト（mirror/eli/part等）の追加が今後必要か検討されているか
- [ ] テストIDの採番（UT-GEO-001～150）に抜け漏れがないか
- [ ] 優先度の高いテスト（金額計算相当→データ整合性/I/Oパス/アクセス制御）が適切に設定されているか
