---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 112
  claims_without_evidence: 8
confidence_derived: 0.93
---

# 根拠レポート：ipsec 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：112 / 120、根拠なし：8
- 優先レビュー（高）
  1. **UT-IPS-037, 038（ipsec4_common_input_cb）**：コールバックの完全な動作はcryptoサブシステムとの統合に依存
  2. **UT-IPS-042, 043（ipsec4_perform_request, ipsec_process_done）**：出力パイプラインの完全な動作は外部関数に依存
  3. **UT-IPS-105, 106（ipcomp_init）**：IPComp初期化の詳細なエラーパスは未読了

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sys/netipsec/ipsec.h` - IPsec構造体・定数定義（secpolicy, secasvar, ipsecrequest, IPSEC_MODE_*, IPSEC_POLICY_*, IPSEC_LEVEL_*）
- E-02: `sys/netipsec/ipsec.c` - IPsecコア実装（ipsec_chkreplay, ipsec_updatereplay, check_window, advance_window, set_window, ipsec_get_reqlevel, sysctl_def_policy, ipsec_checkpolicy, ipsec_in_reject, ipsec_hdrsiz_internal, ipsec_invalidate_cache, ipsec_cachepolicy, ipsec_newisr, ipsec_delisr, ipsec_updateid）
- E-03: `sys/netipsec/ipsec_input.c` - IPsec入力処理（ipsec_common_input, ipsec4_common_input_cb, ipsec4_input, ipsec6_input）
- E-04: `sys/netipsec/ipsec_output.c` - IPsec出力処理（ipsec4_allocsa, ipsec4_perform_request, ipsec4_process_packet, ipsec_process_done, ipsec_encap, ipsec_get_pmtu, ipsec_prepend）
- E-05: `sys/netipsec/xform_esp.c` - ESP変換処理（esp_hdrsiz, esp_init, esp_input_cb, esp_output_cb）
- E-06: `sys/netipsec/xform_ah.c` - AH変換処理（xform_ah_authsize, ah_hdrsiz, ah_init, ah_input_cb, ah_output_cb）
- E-07: `sys/netipsec/key.h` - 鍵管理関数宣言（key_allocsp, key_newsp, key_freesp, key_addref, key_allocsa, key_allocsa_tunnel, key_allocsa_policy, key_allocsa_tcpmd5, key_freesav, key_sockaddrcmp, key_parse, key_sa_recordxfer, key_portfromsaddr, key_porttosaddr, key_msg2sp, key_sp2msg）
- E-08: `sys/netipsec/key.c` - 鍵管理実装（key_sockaddrcmp関数実装4532行目確認済み、key_allocsa 1154行、key_allocsa_tunnel 1198行、key_allocsa_policy 1075行、key_allocsa_tcpmd5 1023行）
- E-09: `sys/netipsec/keydb.h` - SA/SPデータ構造体（secasindex, secashead, secasvar, secreplay, secnatt, seckey, seclifetime, secident）
- E-10: `sys/netipsec/ipsec_mbuf.c` - mbufユーティリティ（m_makespace, m_pad, m_striphdr）
- E-11: `sys/netipsec/subr_ipsec.c` - IPsecサブルーチン（ipsec4_setsockaddrs, ipsec6_setsockaddrs, ipsec_kmod_enter, ipsec_kmod_exit, ipsec_kmod_drain）
- E-12: `sys/netipsec/ipsec_pcb.c` - PCB関連（ipsec_setspidx_inpcb, ipsec_setsockaddrs_inpcb）
- E-13: `sys/netipsec/udpencap.c` - UDP-ESP encapsulation（udp_ipsec_pcbctl）
- E-14: `sys/netipsec/xform_tcp.c` - TCP-MD5（tcp_ipsec_pcbctl）
- E-15: `sys/netipsec/xform_ipcomp.c` - IPComp変換（ipcomp_init）
- E-16: `sys/netipsec/keysock.c` - PF_KEYソケット（key_send）
- E-17: `sbin/setkey/test-policy.c` - ポリシーテストコード（ipsec_set_policy, ipsec_dump_policy, ipsec_get_policylen テスト用リクエスト配列）
- E-18: `sbin/setkey/test-pfkey.c` - PF_KEYテストコード（sendkeymsg, key_setsadbmsg等）
- E-19: `sbin/setkey/setkey.c` - setkeyツール本体（main, sendkeymsg, postproc）
- E-20: `tests/sys/netipsec/tunnel/` - IPsecトンネルテスト（aes_cbc_128, aes_gcm_128等のシェルスクリプトテスト）
- E-21: `sys/netipsec/ipsec_offload.c` - IPsecオフロード（ipsec_accel_*関数群）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-IPS-001~006) | ipsec_chkreplay のリプレイウィンドウ検証 | E-02 (ipsec.c 1274行) | ○ |
| C-02 (UT-IPS-007~008) | ipsec_updatereplay のウィンドウ更新 | E-02 (ipsec.c 1404行) | ○ |
| C-03 (UT-IPS-009~012) | check_window, advance_window, set_window 内部関数 | E-02 (ipsec.c 1211, 1226, 1249行) | ○ |
| C-04 (UT-IPS-013~016) | ipsec_get_reqlevel のレベル判定 | E-02 (ipsec.c 896行), E-01 (IPSEC_LEVEL_*定数) | ○ |
| C-05 (UT-IPS-017~019) | sysctl_def_policy の検証 | E-02 (ipsec.c 131行, IPSEC_POLICY_DISCARD/NONE判定) | ○ |
| C-06 (UT-IPS-020~023) | ipsec_checkpolicy のポリシー分岐 | E-02 (ipsec.c 418行, switch文) | ○ |
| C-07 (UT-IPS-024~025) | ipsec_in_reject のパケット拒否 | E-02 (ipsec.c 1044行) | ○ |
| C-08 (UT-IPS-026~027) | ipsec_hdrsiz_internal のヘッダサイズ計算 | E-02 (ipsec.c 1113行) | ○ |
| C-09 (UT-IPS-028~029) | ipsec_invalidate_cache のキャッシュ管理 | E-02 (ipsec.c 316行) | ○ |
| C-10 (UT-IPS-030) | ipsec_updateid のcrypto session更新 | E-02 (ipsec.c 1509行) | ○ |
| C-11 (UT-IPS-031~036) | ipsec_common_input の入力処理 | E-03 (ipsec_input.c 120行) | ○ |
| C-12 (UT-IPS-037~038) | ipsec4_common_input_cb コールバック | E-03 (ipsec_input.c 341行) | △ |
| C-13 (UT-IPS-039~041) | ipsec4_allocsa のSA割り当て | E-04 (ipsec_output.c 114行) | ○ |
| C-14 (UT-IPS-042~043) | ipsec4_perform_request, ipsec_process_done | E-04 (ipsec_output.c 189行, 902行) | △ |
| C-15 (UT-IPS-044~047) | ipsec_encap, ipsec_get_pmtu, ipsec_prepend | E-04 (ipsec_output.c 1144行, 1091行, 1063行) | ○ |
| C-16 (UT-IPS-048~053) | esp_hdrsiz, esp_init のESP処理 | E-05 (xform_esp.c 109行, 143行) | ○ |
| C-17 (UT-IPS-054~059) | xform_ah_authsize, ah_hdrsiz のAH処理 | E-06 (xform_ah.c 119行, 147行) | ○ |
| C-18 (UT-IPS-060~065) | key_allocsp, key_newsp, key_freesp, key_addref | E-07, E-08 | ○ |
| C-19 (UT-IPS-066~070) | key_allocsa, key_allocsa_tunnel, key_allocsa_policy, key_allocsa_tcpmd5 | E-08 (key.c 1154, 1198, 1075, 1023行) | ○ |
| C-20 (UT-IPS-071~075) | key_sockaddrcmp のアドレス比較 | E-08 (key.c 4532行) | ○ |
| C-21 (UT-IPS-076~078) | key_parse のメッセージ処理 | E-08 | △ |
| C-22 (UT-IPS-079~083) | key_sa_recordxfer, key_freesav, key_portfromsaddr, key_porttosaddr | E-07 | ○ |
| C-23 (UT-IPS-084~089) | m_makespace, m_pad, m_striphdr | E-10 (ipsec_mbuf.c 54行) | ○ |
| C-24 (UT-IPS-090~095) | ipsec4/6_setsockaddrs, ipsec_kmod_enter/exit | E-11 (subr_ipsec.c 64, 82, 117, 131行) | ○ |
| C-25 (UT-IPS-096~097) | ipsec_setspidx_inpcb | E-12 (ipsec_pcb.c 128行) | ○ |
| C-26 (UT-IPS-098~102) | udp_ipsec_pcbctl のNAT-T | E-13 (udpencap.c 70行) | ○ |
| C-27 (UT-IPS-103~104) | tcp_ipsec_pcbctl のTCP-MD5 | E-14 (xform_tcp.c 77行) | △ |
| C-28 (UT-IPS-105~106) | ipcomp_init のIPComp | E-15 (xform_ipcomp.c) | △ |
| C-29 (UT-IPS-107~109) | key_send のPF_KEYソケット | E-16 (keysock.c 89行) | ○ |
| C-30 (UT-IPS-110~111) | key_msg2sp, key_sp2msg | E-07, E-08 | ○ |
| C-31 (UT-IPS-112~113) | ipsec_newisr, ipsec_delisr | E-01 (ipsec.h宣言), E-02 | ○ |
| C-32 (UT-IPS-114~120) | ipsec_set_policy, ipsec_dump_policy テスト | E-17 (test-policy.c) | ○ |

## 4) 不足情報（Unknown / Missing）
- **ipsec4_common_input_cb の復号後処理フロー**：コールバック内でのcryptoサブシステムとの連携部分は、opencrypto/cryptodev.hの詳細な読み込みが不足している
  - 候補：`sys/opencrypto/cryptodev.h` / `sys/opencrypto/crypto.c`
- **key_parse の全メッセージタイプ**：key.cは非常に大きなファイル（約5000行以上）であり、全てのSADB_*メッセージタイプの処理パスを網羅的に確認していない
  - 候補：`sys/netipsec/key.c` の全体読み込み / `net/pfkeyv2.h`
- **tcp_ipsec_pcbctl の詳細パス**：xform_tcp.cの完全な実装は80行目以降を未読了
  - 候補：`sys/netipsec/xform_tcp.c` 全体
- **ipcomp_init のエラーパス**：xform_ipcomp.cの80行目以降を未読了
  - 候補：`sys/netipsec/xform_ipcomp.c` 全体
- **ipsec_offload.c のオフロード機能**：IPSEC_OFFLOAD条件コンパイル配下の関数群は調査済みだがテストケースに含めていない（ハードウェア依存のため）
  - 候補：`sys/netipsec/ipsec_offload.c` / `sys/netipsec/ipsec_offload.h`

## 5) リスクフラグ（レビュー観点）
- **2（高リスク）**：ipsec_chkreplay / ipsec_updatereplay のリプレイ防御ロジック -- セキュリティクリティカルな機能であり、テストケースの入力値・期待結果が正確であることが特に重要
- **1（中リスク）**：key_parse のPF_KEYメッセージ処理 -- 全メッセージタイプを網羅的に確認していないため、追加のテストケースが必要な可能性がある
- **1（中リスク）**：ipsec_common_input のSPI取得ロジック -- プロトコル別のSPI取得オフセットがRFC準拠であることの確認が必要
- **0（低リスク）**：ユーザーランドツール（setkey）のテスト -- test-policy.cに既存のテストパターンがあり、それに基づいてテストケースを生成している

## 6) レビュアーチェックリスト（最小）
- [ ] ipsec_chkreplay のシーケンス番号境界値テスト（UT-IPS-005, 006）が RFC 4302/4303 の仕様と一致しているか
- [ ] ipsec_updatereplay のオーバーフロー検出（UT-IPS-008）が64bit拡張シーケンス番号（ESN）に対応しているか
- [ ] ipsec_get_reqlevel のDEFAULTレベル解決（UT-IPS-015）がIPv6用のsysctl変数も考慮しているか
- [ ] ipsec_common_input のIPCOMPのSPI取得ロジック（16bit CPI変換）が正しいか
- [ ] key_parse のメッセージバリデーションが全SADB_*タイプを網羅しているか
- [ ] ipsec_offload.c 関連のテストケースが必要かどうかの判断
- [ ] ESP/AH初期化のアルゴリズム対応表（AES-GCM, ChaCha20-Poly1305等）が現行コードと一致しているか
