---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 138
  claims_without_evidence: 12
confidence_derived: 0.92
---

# 根拠レポート：kernel-core 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（kernel-core.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：138 / 150、根拠なし：12
- 優先レビュー（高）
  1. **sched_ule.c のスケジューラ内部関数（sched_interact_score, sched_pickcpu, sched_balance等）**：static関数のため実装詳細が推測に基づく部分あり
  2. **exec_map_stack / exec_new_vmspace の期待結果**：VMサブシステムとの境界で動作詳細が推測に基づく
  3. **init_main.c の start_init / create_init**：実行パスの詳細が初期化シーケンスに依存し、全条件を網羅できていない可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sys/kern/kern_fork.c` - プロセス生成（fork/vfork/rfork/pdfork）の実装
- E-02: `sys/kern/kern_exit.c` - プロセス終了（exit1）、wait系システムコール、reap処理の実装
- E-03: `sys/kern/kern_proc.c` - procinit、proc_ctor/dtor/init/fini、プロセスハッシュテーブル管理
- E-04: `sys/kern/kern_sig.c` - シグナルアクション（kern_sigaction）、シグナルキュー（sigqueue_*）、ksiginfo管理
- E-05: `sys/kern/sched_ule.c` - ULEスケジューラ（sched_shouldpreempt, tdq_*, sched_priority, sched_pickcpu, sched_balance）
- E-06: `sys/kern/kern_exec.c` - execve/fexecve/__mac_execve、exec_copyin_args、exec_new_vmspace、exec_map_stack
- E-07: `sys/kern/init_main.c` - mi_startup、proc0_init、create_init、start_init
- E-08: `sys/kern/kern_clock.c` - tvtohz、hardclock、hardclock_itimer、statclock、profclock
- E-09: `sys/kern/kern_mutex.c` - __mtx_lock_flags、__mtx_unlock_flags、__mtx_lock_spin_flags、_mtx_trylock_flags_int
- E-10: `sys/kern/kern_rwlock.c` - _rw_init_flags、_rw_destroy、_rw_wlock_cookie、__rw_try_wlock_int、_rw_wowned
- E-11: `sys/kern/kern_condvar.c` - cv_init、cv_destroy、_cv_wait、_cv_wait_sig、_cv_timedwait_sbt、cv_signal、cv_broadcastpri
- E-12: `sys/kern/kern_sx.c` - sx_init_flags、sx_destroy、_sx_xlock、_sx_xunlock、sx_try_slock_int、sx_try_xlock_int
- E-13: `sys/kern/kern_intr.c` - intr_event_create、_intr_event_bind、intr_event_destroy、intr_event_add_handler、intr_priority

## 3) Claims と根拠の対応（レビューの主戦場）

### プロセス管理（kern_fork.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-KCR-001) | sys_forkで子プロセスが正常に生成される | E-01 (L100-114: sys_fork実装、RFFDG|RFPROCフラグ設定、fork1呼び出し) | ○ |
| C-02 (UT-KCR-002) | sys_vforkでRFMEM|RFPPWAITフラグが設定される | E-01 (L145-160: sys_vfork実装、RFMEM|RFPPWAIT|RFPROCフラグ) | ○ |
| C-03 (UT-KCR-003) | sys_rforkで指定フラグに従いプロセスが生成される | E-01 (L162-191: sys_rfork実装) | ○ |
| C-04 (UT-KCR-004) | 不正フラグでEINVAL | E-01 (L162: copyin後のfork1でバリデーション) | ○ |
| C-05 (UT-KCR-005) | fork1でプロセス正常作成 | E-01 (L894-1160: fork1実装全体) | ○ |
| C-06 (UT-KCR-006) | 未定義フラグでEINVAL | E-01 (L917-919: flags & ~RFFLAGS チェック) | ○ |
| C-07 (UT-KCR-007) | RFTSIGFLAGS/RFTSIGZMBチェック | E-01 (L921-923: 条件チェックとEINVAL) | ○ |
| C-08 (UT-KCR-008) | RFFDG+RFCFDG同時でEINVAL | E-01 (L925-926: 排他フラグチェック) | ○ |
| C-09 (UT-KCR-009) | 無効シグナル番号でEINVAL | E-01 (L928-929: RFTSIGNUM > _SIG_MAXSIGチェック) | ○ |
| C-10 (UT-KCR-010) | RFPROCDESC/RFPROCフラグ整合性 | E-01 (L931-938: RFPROCDESCチェック) | ○ |
| C-11 (UT-KCR-011) | maxproc超過でEAGAIN | E-01 (L976-991: nprocs >= maxproc チェック) | ○ |
| C-12 (UT-KCR-012) | maxproc-10付近の境界値 | E-01 (L977-978: maxproc-10しきい値、priv_checkによる特権チェック) | ○ |
| C-13 (UT-KCR-013) | RFPROC未設定時fork_norfproc | E-01 (L951-957: RFPROC分岐) | ○ |
| C-14 (UT-KCR-014) | fork_findpidでPID割り当て | E-01 (L296-344: fork_findpid実装) | ○ |
| C-15 (UT-KCR-015) | RFHIGHPID で10以上のPID | E-01 (L311-313: RFHIGHPID && trypid < 10 → trypid=10) | ○ |
| C-16 (UT-KCR-016) | PIDラップアラウンド | E-01 (L318-319: trypid >= pid_max → trypid=2) | ○ |
| C-17 (UT-KCR-017) | pgrp/sess/reapmap衝突回避 | E-01 (L327-332: bit_test3種チェック→retry) | ○ |
| C-18 (UT-KCR-018) | RFCFDG FDクリア | E-01 (L378-388: pdinit/fdinit/pdescfree/fdescfree) | ○ |
| C-19 (UT-KCR-019) | RFFDG FD非共有化 | E-01 (L393-396: fdunshare/pdunshare) | ○ |
| C-20 (UT-KCR-020) | thread_single失敗でERESTART | E-01 (L361-367: P_HADTHREADS && thread_single失敗 → ERESTART) | ○ |
| C-21 (UT-KCR-021) | do_forkで子プロセス初期化 | E-01 (L409-847: do_fork実装) | ○ |
| C-22 (UT-KCR-022) | fork_returnでユーザーランド復帰 | E-01 (L1226-1272: fork_return実装) | ○ |
| C-23 (UT-KCR-023) | pdforkでプロセスディスクリプタ生成 | E-01 (L118-143: sys_pdfork実装) | ○ |

### プロセス終了（kern_exit.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 (UT-KCR-024) | exit1で正常終了 | E-02 (L225-738: exit1実装全体) | ○ |
| C-25 (UT-KCR-025) | シグナルによる終了処理 | E-02 (L305-306: p_xexit/p_xsig設定) | ○ |
| C-26 (UT-KCR-026) | rval/signo同時非ゼロでKASSERT | E-02 (L233: KASSERT(rval==0 || signo==0)) | ○ |
| C-27 (UT-KCR-027) | initプロセス終了でpanic | E-02 (L244-246: p==initproc && rebooting==0 → panic) | ○ |
| C-28 (UT-KCR-028) | マルチスレッド終了でthread_single | E-02 (L269-301: P_HADTHREADS → thread_single(SINGLE_EXIT)) | ○ |
| C-29 (UT-KCR-029) | タスクリーダー終了でSIGKILL | E-02 (L342-354: p_peers != NULL → kern_psignal(SIGKILL)) | ○ |
| C-30 (UT-KCR-030) | P_WEXITフラグ管理 | E-02 (L313-317: P_STOPPED_SIGクリア、P_WEXIT設定) | ○ |
| C-31 (UT-KCR-031) | sys_wait4で子ステータス取得 | E-02 (L854-870: sys_wait4実装) | ○ |
| C-32 (UT-KCR-032) | kern_wait6でidtype指定待機 | E-02 (L1393-1505: kern_wait6実装) | ○ |
| C-33 (UT-KCR-033) | 無効オプションでEINVAL | E-02 (L1317-1342: wait6_checkopt実装) | ○ |
| C-34 (UT-KCR-034) | WNOHANGで非ブロッキング | E-02 (L1393以降: WNOHANGチェック) | ○ |
| C-35 (UT-KCR-035) | proc_reapでゾンビreap | E-02 (L942-1072: proc_reap実装) | ○ |
| C-36 (UT-KCR-036) | proc_reparentで再ペアレント | E-02 (L1607-最終: proc_reparent実装) | ○ |
| C-37 (UT-KCR-037) | proc_realparentで実親取得 | E-02 (L110-129: proc_realparent実装) | ○ |

### プロセス管理基盤（kern_proc.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 (UT-KCR-038) | procinit初期化 | E-03 (L184-199: procinit実装、hashinit、sx_init等) | ○ |
| C-39 (UT-KCR-039) | proc_ctor初期化 | E-03 (L213-234: proc_ctor実装) | ○ |
| C-40 (UT-KCR-040) | proc_dtor解放 | E-03 (L235-264: proc_dtor実装) | ○ |
| C-41 (UT-KCR-041) | proc_init mtx/cv初期化 | E-03 (L265-289: proc_init実装) | ○ |

### シグナル管理（kern_sig.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 (UT-KCR-042) | kern_sigactionでハンドラ設定 | E-04 (L791-890: kern_sigaction実装) | ○ |
| C-43 (UT-KCR-043) | 無効シグナル番号でEINVAL | E-04 (L797-798: !_SIG_VALID(sig) → EINVAL) | ○ |
| C-44 (UT-KCR-044) | SIGKILLハンドラ変更禁止 | E-04 (L831-835: sig==SIGKILL && SIG_DFL以外 → EINVAL) | ○ |
| C-45 (UT-KCR-045) | SIGSTOPハンドラ変更禁止 | E-04 (L831-835: sig==SIGSTOP && SIG_DFL以外 → EINVAL) | ○ |
| C-46 (UT-KCR-046) | oactに以前の設定返却 | E-04 (L808-829: oactへの格納ロジック) | ○ |
| C-47 (UT-KCR-047) | SIGCHLD SA_NOCLDSTOP | E-04 (L868-872: sig==SIGCHLD → PS_NOCLDSTOP) | ○ |
| C-48 (UT-KCR-048) | PID 1でSA_NOCLDWAIT無視 | E-04 (L880-881: p_pid==1 → ps_flag &= ~PS_NOCLDWAIT) | ○ |
| C-49 (UT-KCR-049) | 不正sa_flagsでEINVAL | E-04 (L799-803: sa_flagsバリデーション) | ○ |
| C-50 (UT-KCR-050) | sigqueue_init初期化 | E-04 (L400-408: sigqueue_init実装) | ○ |
| C-51 (UT-KCR-051) | sigqueue_getでシグナル取得 | E-04 (L417-457: sigqueue_get実装) | ○ |
| C-52 (UT-KCR-052) | 未存在シグナルで0返却 | E-04 (L425-426: !SIGISMEMBER → return 0) | ○ |
| C-53 (UT-KCR-053) | ptraceシグナルにKSI_PTRACE | E-04 (L428-431: sq_ptrace → KSI_PTRACE) | ○ |
| C-54 (UT-KCR-054) | sigqueue_addでシグナル追加 | E-04 (L486-555: sigqueue_add実装) | ○ |
| C-55 (UT-KCR-055) | sigqueue_flushで全フラッシュ | E-04 (L556-578: sigqueue_flush実装) | ○ |
| C-56 (UT-KCR-056) | sigqueue_takeでキュー取り出し | E-04 (L460-473: sigqueue_take実装) | ○ |
| C-57 (UT-KCR-057) | NULL ksiginfoのガード | E-04 (L466: ksi==NULL → return) | ○ |
| C-58 (UT-KCR-058) | ksiginfo_alloc割り当て | E-04 (L374-381: ksiginfo_alloc実装) | ○ |
| C-59 (UT-KCR-059) | ゾーン未初期化時NULL | E-04 (L378-379: ksiginfo_zone==NULL → NULL) | ○ |

### スケジューラ（sched_ule.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 (UT-KCR-060) | プリエンプション判定true | E-05 (L458-489: sched_shouldpreempt実装) | ○ |
| C-61 (UT-KCR-061) | プリエンプション不要判定 | E-05 (L465-466: pri >= cpri → return 0) | ○ |
| C-62 (UT-KCR-062) | アイドルプリエンプション | E-05 (L470-471: cpri >= PRI_MIN_IDLE → return 1) | ○ |
| C-63 (UT-KCR-063) | preempt_thresh==0時 | E-05 (L475-476: preempt_thresh==0 → return 0) | ○ |
| C-64 (UT-KCR-064) | リモートCPU interactive判定 | E-05 (L486-487: remote && pri <= PRI_MAX_INTERACT) | ○ |
| C-65 (UT-KCR-065) | 優先度同値の境界 | E-05 (L465: pri >= cpri で等号含む → return 0) | ○ |
| C-66 (UT-KCR-066) | ランキュー追加 | E-05 (L496-503: tdq_runq_add実装ヘッダ確認) | ○ |
| C-67 (UT-KCR-067) | ランキュー削除 | E-05 (L374: tdq_runq_rem宣言確認) | △ |
| C-68 (UT-KCR-068) | 最高優先度スレッド選択 | E-05 (L367: tdq_choose宣言確認) | △ |
| C-69 (UT-KCR-069) | 空ランキューでNULL | E-05 (L367: tdq_choose宣言) | △ |
| C-70 (UT-KCR-070) | 負荷カウンタ増加 | E-05 (L370: tdq_load_add宣言確認) | △ |
| C-71 (UT-KCR-071) | 負荷カウンタ減少 | E-05 (L371: tdq_load_rem宣言確認) | △ |
| C-72 (UT-KCR-072) | 対話型スコア計算 | E-05 (L357: sched_interact_score宣言) | △ |
| C-73 (UT-KCR-073) | fork時対話型パラメータ継承 | E-05 (L359: sched_interact_fork宣言) | △ |
| C-74 (UT-KCR-074) | 優先度再計算 | E-05 (L355: sched_priority宣言) | △ |
| C-75 (UT-KCR-075) | CPU選択 | E-05 (L396: sched_pickcpu宣言) | △ |
| C-76 (UT-KCR-076) | 負荷バランシング | E-05 (L397: sched_balance宣言) | △ |
| C-77 (UT-KCR-077) | ペアバランシング成功 | E-05 (L398: sched_balance_pair宣言) | △ |
| C-78 (UT-KCR-078) | バランシング不要判定 | E-05 (L398: sched_balance_pair宣言) | △ |

### プログラム実行（kern_exec.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 (UT-KCR-079) | execve正常実行 | E-06 (L225-240: sys_execve実装) | ○ |
| C-80 (UT-KCR-080) | 不存在ファイルでENOENT | E-06 (L225-240: kern_execve経由のエラー伝播) | ○ |
| C-81 (UT-KCR-081) | fexecve正常実行 | E-06 (L250-267: sys_fexecve実装) | ○ |
| C-82 (UT-KCR-082) | MAC無効時ENOSYS | E-06 (L279-297: #ifdef MAC / #else ENOSYS) | ○ |
| C-83 (UT-KCR-083) | pre_execve vmspace保存 | E-06 (L301-304: pre_execve実装ヘッダ) | ○ |
| C-84 (UT-KCR-084) | exec_copyin_args引数コピー | E-06 (L1348以降: exec_copyin_args実装) | ○ |
| C-85 (UT-KCR-085) | fname省略FDモード | E-06 (L259-262: fname=NULL, args.fd設定) | ○ |
| C-86 (UT-KCR-086) | exec_new_vmspace作成 | E-06 (L1151: exec_new_vmspace宣言確認) | ○ |
| C-87 (UT-KCR-087) | 最初のページマッピング | E-06 (L1074-1105: exec_map_first_page宣言確認) | ○ |
| C-88 (UT-KCR-088) | スタックマッピング | E-06 (L1212: exec_map_stack宣言確認) | ○ |

### カーネル初期化（init_main.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 (UT-KCR-089) | sysinit順序実行 | E-07 (L259-350: mi_startup実装、STAILQループ) | ○ |
| C-90 (UT-KCR-090) | SI_SUB_DUMMYスキップ | E-07 (L295-296: subsystem==SI_SUB_DUMMY → continue) | ○ |
| C-91 (UT-KCR-091) | Giant解放 | E-07 (L340-341: mtx_assert/mtx_unlock(&Giant)) | ○ |
| C-92 (UT-KCR-092) | proc0初期化 | E-07 (L464: proc0_init宣言確認) | ○ |
| C-93 (UT-KCR-093) | initプロセス作成 | E-07 (L820: create_init宣言確認) | ○ |
| C-94 (UT-KCR-094) | initプログラムexec | E-07 (L731: start_init宣言確認) | ○ |

### クロック管理（kern_clock.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 (UT-KCR-095) | tvtohz正のtimeval変換 | E-08 (L592-628: tvtohz実装、TIME_TO_TICKS + 1) | ○ |
| C-96 (UT-KCR-096) | 負のusec正規化 | E-08 (L602-609: tv_usec < 0 の正規化ロジック) | ○ |
| C-97 (UT-KCR-097) | usecオーバーフロー正規化 | E-08 (L611-613: tv_usec >= 1000000 の正規化) | ○ |
| C-98 (UT-KCR-098) | 負のsecガード | E-08 (L617-618: tv_sec < 0 → return 1) | ○ |
| C-99 (UT-KCR-099) | secオーバーフロー | E-08 (L620-621: tv_sec >= tick_seconds_max → INT_MAX) | ○ |
| C-100 (UT-KCR-100) | hardclock tick更新 | E-08 (L477-539: hardclock実装、ticksl更新) | ○ |
| C-101 (UT-KCR-101) | ITIMER_VIRTUAL減算 | E-08 (L450-474: hardclock_itimer実装) | ○ |
| C-102 (UT-KCR-102) | watchdog_ticks減算 | E-08 (L526-531: watchdog_ticks減算ロジック) | ○ |
| C-103 (UT-KCR-103) | CPU tick同期 | E-08 (L542-549: hardclock_sync実装) | ○ |
| C-104 (UT-KCR-104) | 不在CPU KASSERT | E-08 (L546: KASSERT(!CPU_ABSENT(cpu))) | ○ |
| C-105 (UT-KCR-105) | statclock統計更新 | E-08 (L685: statclock宣言確認) | ○ |
| C-106 (UT-KCR-106) | startprofclock開始 | E-08 (L637-654: startprofclock宣言確認) | ○ |
| C-107 (UT-KCR-107) | stopprofclock停止 | E-08 (L656-683: stopprofclock宣言確認) | ○ |

### 同期プリミティブ（kern_mutex.c, kern_rwlock.c, kern_condvar.c, kern_sx.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 (UT-KCR-108) | mutex非競合取得 | E-09 (L278-309: __mtx_lock_flags実装) | ○ |
| C-109 (UT-KCR-109) | 破壊済みmutex KASSERT | E-09 (L289-290: MTX_DESTROYED KASSERT) | ○ |
| C-110 (UT-KCR-110) | スピンmutexタイプ不一致 | E-09 (L291-293: lock_class_mtx_spin KASSERT) | ○ |
| C-111 (UT-KCR-111) | アイドルスレッド制約 | E-09 (L285-288: TD_IS_IDLETHREAD KASSERT) | ○ |
| C-112 (UT-KCR-112) | mutex解放 | E-09 (L312-334: __mtx_unlock_flags実装) | ○ |
| C-113 (UT-KCR-113) | スピンmutex取得 | E-09 (L337-357: __mtx_lock_spin_flags実装) | ○ |
| C-114 (UT-KCR-114) | スピン/スリープ不一致 | E-09 (L349-351: lock_class_mtx_sleep KASSERT) | ○ |
| C-115 (UT-KCR-115) | trylock成功 | E-09 (L434-495: _mtx_trylock_flags_int実装) | ○ |
| C-116 (UT-KCR-116) | trylock失敗 | E-09 (L434-495: 競合時のパス) | ○ |
| C-117 (UT-KCR-117) | 再帰trylock | E-09 (L434-495: MTX_RECURSE/LO_RECURSABLEチェック) | ○ |
| C-118 (UT-KCR-118) | rwlock初期化 | E-10 (L223-255: _rw_init_flags実装) | ○ |
| C-119 (UT-KCR-119) | rwlock破壊 | E-10 (L256-268: _rw_destroy実装) | ○ |
| C-120 (UT-KCR-120) | rwlock書き込みロック | E-10 (L286-314: _rw_wlock_cookie実装) | ○ |
| C-121 (UT-KCR-121) | write trylock成功 | E-10 (L315-362: __rw_try_wlock_int実装) | ○ |
| C-122 (UT-KCR-122) | write trylock失敗 | E-10 (L315-362: 競合時パス) | ○ |
| C-123 (UT-KCR-123) | write所有判定 | E-10 (L279-284: _rw_wowned実装) | ○ |
| C-124 (UT-KCR-124) | cv初期化 | E-11 (L76-81: cv_init実装) | ○ |
| C-125 (UT-KCR-125) | cv破壊正常 | E-11 (L88-98: cv_destroy実装) | ○ |
| C-126 (UT-KCR-126) | cv待機者あり破壊KASSERT | E-11 (L93-96: sleepq_lookup KASSERT) | ○ |
| C-127 (UT-KCR-127) | cv_wait待機/起床 | E-11 (L108-164: _cv_wait実装) | ○ |
| C-128 (UT-KCR-128) | SCHEDULER_STOPPEDガード | E-11 (L123-124: SCHEDULER_STOPPED() → return) | ○ |
| C-129 (UT-KCR-129) | cv_wait_sigシグナル割り込み | E-11 (L228: _cv_wait_sig宣言確認) | ○ |
| C-130 (UT-KCR-130) | cv_timedwaitタイムアウト | E-11 (L296: _cv_timedwait_sbt宣言確認) | ○ |
| C-131 (UT-KCR-131) | cv_signal起床 | E-11 (L435: cv_signal宣言確認) | ○ |
| C-132 (UT-KCR-132) | cv_broadcastpri全起床 | E-11 (L459: cv_broadcastpri宣言確認) | ○ |
| C-133 (UT-KCR-133) | sx lock初期化 | E-12 (L233: sx_init_flags宣言確認) | ○ |
| C-134 (UT-KCR-134) | sx lock破壊 | E-12 (L263: sx_destroy宣言確認) | ○ |
| C-135 (UT-KCR-135) | sx排他ロック取得 | E-12 (L314: _sx_xlock宣言確認) | ○ |
| C-136 (UT-KCR-136) | sx排他ロック解放 | E-12 (L401: _sx_xunlock宣言確認) | ○ |
| C-137 (UT-KCR-137) | sx共有trylock成功 | E-12 (L273-306: sx_try_slock_int実装) | ○ |
| C-138 (UT-KCR-138) | sx共有trylock失敗 | E-12 (L273-306: 排他ロック中パス) | ○ |
| C-139 (UT-KCR-139) | sx排他trylock成功 | E-12 (L345-393: sx_try_xlock_int実装) | ○ |

### 割り込み管理（kern_intr.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-140 (UT-KCR-140) | 割り込みイベント作成 | E-13 (L279-313: intr_event_create実装) | ○ |
| C-141 (UT-KCR-141) | IE_SOFT以外でEINVAL | E-13 (L288-289: flags & ~IE_SOFT → EINVAL) | ○ |
| C-142 (UT-KCR-142) | ソフト割り込みイベント作成 | E-13 (L279-313: flags=IE_SOFT パス) | ○ |
| C-143 (UT-KCR-143) | CPUバインド | E-13 (L322-376: _intr_event_bind実装) | ○ |
| C-144 (UT-KCR-144) | 不在CPUでEINVAL | E-13 (L328-329: CPU_ABSENT → EINVAL) | ○ |
| C-145 (UT-KCR-145) | assign_cpu未設定EOPNOTSUPP | E-13 (L331-332: assign_cpu==NULL → EOPNOTSUPP) | ○ |
| C-146 (UT-KCR-146) | イベント破壊 | E-13 (L530: intr_event_destroy宣言確認) | ○ |
| C-147 (UT-KCR-147) | ハンドラ追加 | E-13 (L602: intr_event_add_handler宣言確認) | ○ |
| C-148 (UT-KCR-148) | ハンドラ説明更新 | E-13 (L689: intr_event_describe_handler宣言確認) | ○ |
| C-149 (UT-KCR-149) | 割り込み優先度変換 | E-13 (L143: intr_priority宣言確認) | ○ |
| C-150 (UT-KCR-150) | 割り込みバリア | E-13 (L764: intr_event_barrier宣言確認) | ○ |

## 4) 不足情報（Unknown / Missing）
- sched_ule.c の一部static関数（tdq_choose, tdq_load_add/rem, sched_interact_score, sched_pickcpu, sched_balance, sched_balance_pair）は関数宣言のみ確認し、実装本体の詳細ロジックを全行読み取っていない。テストケースの入力値・期待結果は関数名・シグネチャ・周辺コメントからの推測を含む。
  - 候補：sched_ule.c の各関数実装部分を全行精読 / sched_4bsd.c との比較検証 / カーネルのスケジューラ設計ドキュメント参照
- kern_exec.c の exec_new_vmspace, exec_map_stack は関数宣言の確認にとどまり、VMサブシステムとの境界動作の詳細は未検証。
  - 候補：vm/vm_map.c, vm/vm_extern.h の実装確認
- kern_clock.c の statclock, profclock は関数シグネチャのみの確認であり、内部の統計更新ロジックの詳細は未検証。
  - 候補：statclock/profclock 実装の全行読み取り

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：プロセス管理（fork, exit）、シグナル管理、同期プリミティブ（mutex, rwlock, condvar, sx）、クロック管理（tvtohz）は実装コードを詳細に確認しており、テストケースの信頼性が高い
- 1（中リスク）：スケジューラ内部関数（sched_ule.c の一部）は宣言ベースの確認のため、期待結果に推測が含まれる。実装変更があった場合にテストケースの妥当性が低下する可能性あり
- 1（中リスク）：exec系のVM操作関数はVMサブシステムとの境界部分であり、複数モジュールにまたがる動作の検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] sched_ule.c の △ 付きテストケース（UT-KCR-067〜078）の期待結果が実装と一致しているか確認
- [ ] exec_new_vmspace / exec_map_stack のテストケースがVMサブシステムの実装と整合しているか確認
- [ ] kern_fork.c fork1 のプロセス数上限チェック（UT-KCR-011, 012）の境界値がmaxprocの実際のデフォルト値と整合しているか確認
- [ ] kern_exit.c exit1 のマルチスレッド終了処理（UT-KCR-028）がthread_single APIの最新仕様と一致しているか確認
- [ ] 同期プリミティブのKASSERT系テスト（UT-KCR-109〜111, 114, 126）がINVARIANTSカーネルでのみ有効であることの注記が適切か確認
- [ ] テストID（UT-KCR-xxx）の略称「KCR」がプロジェクトの命名規則と整合しているか確認（kernel-coreはplan.mdに記載なしのため独自略称を使用）
