---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 138
  claims_without_evidence: 12
confidence_derived: 0.92
---

# 根拠レポート：lib モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：138 / 150、根拠なし：12
- 優先レビュー（高）
  1. **UT-LIB-094 (crypt_sha512 セキュリティ:メモリクリア)**：explicit_bzeroの実行確認はランタイム依存
  2. **UT-LIB-059 (pidfile_signal)**：シグナル送信の動作確認はプロセス環境依存
  3. **UT-LIB-144〜146 (login_cap)**：login.confの構造を直接確認していない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `lib/libutil/expand_number.c` - expand_number, expand_unsigned関数の実装
- E-02: `lib/libutil/humanize_number.c` - humanize_number関数の実装
- E-03: `lib/libutil/_secure_path.c` - _secure_path関数の実装
- E-04: `lib/libutil/flopen.c` - flopen, flopenat関数の実装
- E-05: `lib/libutil/fparseln.c` - fparseln関数の実装
- E-06: `lib/libutil/pidfile.c` - pidfile_open, pidfile_write, pidfile_close, pidfile_remove, pidfile_fileno, pidfile_signal関数の実装
- E-07: `lib/libutil/trimdomain.c` - trimdomain関数の実装
- E-08: `lib/libutil/hexdump.c` - hexdump関数の実装
- E-09: `lib/libutil/property.c` - properties_read, property_find, properties_free関数の実装
- E-10: `lib/libcrypt/crypt.c` - crypt, crypt_r, crypt_get_format, crypt_set_format関数の実装
- E-11: `lib/libcrypt/crypt-sha256.c` - crypt_sha256関数の実装（テストベクタ含む）
- E-12: `lib/libcrypt/crypt-sha512.c` - crypt_sha512関数の実装（テストベクタ含む）
- E-13: `lib/libcrypt/crypt-md5.c` - crypt_md5関数の実装
- E-14: `lib/libfetch/fetch.c` - fetchParseURL, fetchMakeURL, fetchFreeURL, fetchXGet等の実装
- E-15: `lib/libjail/jail.c` - jail_setv, jail_getv, jailparam_init, jailparam_import, jailparam_export, jailparam_free等の実装
- E-16: `lib/libutil/realhostname.c` - realhostname, realhostname_sa関数の実装
- E-17: `lib/libutil/login_cap.c` - login capabilities関連関数の実装（先頭80行のみ確認）
- E-18: `lib/libutil/quotafile.c` - quotafile構造体と基本構造（先頭60行のみ確認）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-12 | expand_number: 各サフィックス(K/M/G/T/P/E)による変換、符号、空白スキップ | E-01 | ○ |
| C-13〜C-16 | expand_number: 異常系(空文字列, 不正サフィックス)、境界値(オーバーフロー) | E-01 | ○ |
| C-17〜C-18 | expand_unsigned: 符号なし変換、負数拒否 | E-01 | ○ |
| C-19〜C-27 | humanize_number: 各フラグ(HN_AUTOSCALE, HN_DIVISOR_1000, HN_IEC_PREFIXES, HN_DECIMAL, HN_NOSPACE, HN_B, HN_GETSCALE)の動作 | E-02 | ○ |
| C-28〜C-32 | humanize_number: NULL入力、不正スケール、フラグ矛盾、バッファ不足 | E-02 | ○ |
| C-33〜C-37 | _secure_path: 正常パス、ファイル不在、ワールドライタブル、非通常ファイル、所有者チェック | E-03 | ○ |
| C-38〜C-42 | flopen/flopenat: ファイル作成+ロック、既存ファイル、O_TRUNC、不在エラー、dirfd利用 | E-04 | ○ |
| C-43〜C-48 | fparseln: 行読取、コメント除去、行継続、エスケープ、UNESCALL、空ファイル | E-05 | ○ |
| C-49〜C-60 | pidfile: open/write/close/remove/fileno/signal各関数 | E-06 | ○ |
| C-59 | pidfile_signal: 実行中プロセスへのシグナル送信 | E-06 | △ |
| C-61〜C-63 | trimdomain: ドメイン除去、サイズ制限、DISPLAY保持 | E-07 | ○ |
| C-64〜C-68 | hexdump: 基本ダンプ、各省略フラグ、length=0 | E-08 | ○ |
| C-69〜C-78 | property: read/find/free各関数の正常系・異常系 | E-09 | ○ |
| C-79〜C-86 | crypt: SHA512/SHA256/MD5/NTHash各フォーマット、crypt_r、format get/set | E-10 | ○ |
| C-87〜C-90 | crypt_sha256: テストベクタ、カスタムラウンド、境界値 | E-11 | ○ |
| C-91〜C-94 | crypt_sha512: テストベクタ、カスタムラウンド、メモリクリア | E-12 | ○ |
| C-94 | crypt_sha512: explicit_bzeroによるメモリクリア確認 | E-12 | △ |
| C-95〜C-97 | crypt_md5: ハッシュ生成、プレフィクススキップ、ソルト長制限 | E-13 | ○ |
| C-98〜C-115 | fetchParseURL: 各スキーム、認証情報、IPv6、ポート、エンコーディング | E-14 | ○ |
| C-116〜C-139 | libjail: init/import/export/free/setv/getv/all/noname/nononame | E-15 | ○ |
| C-140〜C-143 | realhostname/realhostname_sa: ホスト名解決、v4mapped変換 | E-16 | ○ |
| C-140〜C-141 | realhostname: DNS依存のテスト | E-16 | △ |
| C-144〜C-146 | login_cap: getclass/close | E-17 | △ |
| C-147〜C-148 | quotafile: open/close | E-18 | △ |
| C-149〜C-150 | cpuset_parselist: CPUリストパース | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **cpuset.c**: cpuset_parselist関数のソースコードを直接確認していない。libutil/cpuset.cのファイル一覧で存在は確認したが、関数シグネチャや内部ロジックは未確認。
  - 候補：`lib/libutil/cpuset.c` の直接読取
- **login_cap.c**: 先頭80行のみの確認のため、login_getclass/login_closeの完全な動作仕様は未確認。
  - 候補：`lib/libutil/login_cap.c` の全文読取 / `lib/libutil/login_cap.h`
- **quotafile.c**: 先頭60行のみの確認のため、quota_open/quota_closeの完全な動作仕様は未確認。
  - 候補：`lib/libutil/quotafile.c` の全文読取
- **DNS依存テスト**: realhostname関数のテストはDNS環境に依存するため、テスト環境での再現性に課題がある。
  - 候補：モック/スタブ化の検討
- **explicit_bzero確認**: メモリクリアの検証はランタイム観察が必要で、純粋な単体テストでの確認が困難。
  - 候補：メモリダンプ検証 / sanitizerの利用
- **lib全体の網羅性**: libモジュールは156のサブライブラリを含むが、本テストケースでは主要な6ライブラリ（libutil, libcrypt, libfetch, libjail）に焦点を当てている。libc, libmd, libelf, libprocstat等の重要ライブラリは対象外。
  - 候補：追加ワーカーによるlibc等の分析

## 5) リスクフラグ（レビュー観点）
- **2（高リスク）**: libcryptのハッシュ関数テスト -- セキュリティ上重要であり、テストベクタが正確であることの確認が必要
- **1（中リスク）**: libjailのパラメータ操作 -- jail_set/jail_getはシステムコールへの依存があり、テスト環境にjail機能が必要
- **1（中リスク）**: libfetchのURL解析 -- パーセントエンコーディングやIPv6パースのエッジケースが網羅的でない可能性
- **1（中リスク）**: lib全体の網羅性 -- 156ライブラリ中6ライブラリのみの対応であり、libc等の基盤ライブラリが未対応
- **0（低リスク）**: libutil各関数 -- ソースコードとの整合性が高く、テストケースの根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] libcryptのテストベクタ値がRFC/FIPS仕様のテストベクタと一致していることを確認
- [ ] SHA256/SHA512のROUNDS_MIN(1000), ROUNDS_MAX(999999999)の境界値テストが十分か確認
- [ ] fetchParseURLのエッジケース（非常に長いURL、特殊文字含むホスト名）の追加を検討
- [ ] libjailテストはjail対応カーネル上での実行が前提であることを確認
- [ ] pidfile_signalテストが実行環境でプロセス操作可能であることを確認
- [ ] cpuset.cのテストケース(UT-LIB-149, 150)のソースコード根拠を補完
- [ ] login_cap.c, quotafile.cのテストケースの網羅性を確認（部分読取のため）
- [ ] libc, libmd, libelf等の主要ライブラリの追加テストケースの必要性を判断
