---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：libexec 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **UT-LIB-072, UT-LIB-073 (phdr_in_zero_page)**: page_sizeの実行時依存値のため期待結果の妥当性を確認が必要
  2. **UT-LIB-095〜UT-LIB-097 (option_timeout)**: TIMEOUT_MIN/TIMEOUT_MAXの定数値がヘッダ依存のため実際の範囲を確認が必要
  3. **UT-LIB-099〜UT-LIB-101 (option_blksize)**: BLKSIZE_MIN/BLKSIZE_MAXの定数値がヘッダ依存のため実際の範囲を確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libexec/rtld-elf/rtld_malloc.c` - メモリアロケータ実装（__crt_malloc, __crt_calloc, __crt_free, __crt_realloc, __crt_aligned_alloc_offset）
- E-02: `libexec/rtld-elf/rtld_malloc.h` - メモリアロケータヘッダ
- E-03: `libexec/rtld-elf/xmalloc.c` - xmalloc/xcalloc/xstrdupラッパー実装
- E-04: `libexec/rtld-elf/libmap.c` - ライブラリマッピング設定管理（lm_init, lmc_parse, lmc_parse_file, lmc_parse_dir）
- E-05: `libexec/rtld-elf/libmap.h` - ライブラリマッピングヘッダ
- E-06: `libexec/rtld-elf/rtld_printf.c` - 独自printf実装（rtld_snprintf, rtld_vsnprintf, kvprintf, ksprintn, rtld_fdputstr, rtld_fdputchar）
- E-07: `libexec/rtld-elf/rtld_lock.c` - ロック管理実装（def_lock_create, def_lock_acquire_set, def_lock_release, rlock_acquire, wlock_acquire, lock_release, lock_upgrade, lockdflt_init）
- E-08: `libexec/rtld-elf/rtld.h` - rtldメインヘッダ（構造体定義、マクロ）
- E-09: `libexec/rtld-elf/debug.c` - デバッグ出力実装（debug_printf, dump_relocations）
- E-10: `libexec/rtld-elf/map_object.c` - ELFオブジェクトマッピング（map_object, phdr_in_zero_page）
- E-11: `libexec/bootpd/hash.c` - bootpd汎用ハッシュテーブル（hash_Init, hash_Insert, hash_Lookup, hash_Delete, hash_Exists, hash_FirstEntry, hash_NextEntry, hash_Reset, hash_HashFunction）
- E-12: `libexec/tftpd/tftp-options.c` - TFTPオプション処理（option_timeout, option_blksize, option_blksize2, option_rollover, option_windowsize, option_tsize, options_set_request, options_set_reply, make_options, parse_options, init_options）
- E-13: `libexec/tftpd/tftp-utils.c` - TFTPユーティリティ（settimeouts, unmappedaddr）
- E-14: `libexec/mknetid/hash.c` - mknetidハッシュ実装（hash, hashkey, lookup, mstore）
- E-15: `libexec/talkd/table.c` - talkdテーブル管理（find_match, find_request, insert_table, new_id, delete_invite）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-05 | __crt_mallocの正常系/異常系/境界値テスト | E-01 | ○ |
| C-06〜C-08 | __crt_callocの正常系/異常系/境界値テスト | E-01 | ○ |
| C-09〜C-12 | __crt_freeの正常系/異常系テスト | E-01 | ○ |
| C-13〜C-16 | __crt_reallocの正常系/異常系テスト | E-01 | ○ |
| C-17〜C-18 | __crt_aligned_alloc_offsetの正常系/境界値テスト | E-01 | ○ |
| C-19〜C-24 | xmalloc/xcalloc/xstrdup/xmalloc_alignedのテスト | E-03 | ○ |
| C-25〜C-27 | lm_initの正常系/境界値テスト | E-04 | ○ |
| C-28〜C-37 | lmc_parse/lmc_parse_dir/lmc_parse_fileのテスト | E-04 | ○ |
| C-38〜C-51 | rtld_snprintf/ksprintn/rtld_fdputstr/rtld_fdputcharのテスト | E-06 | ○ |
| C-52〜C-70 | ロック管理関連のテスト | E-07 | ○ |
| C-71 | new_id (talkd)のテスト - rtld_lock.cに誤配置 | E-15 | △ |
| C-72〜C-73 | phdr_in_zero_pageのテスト | E-10 | ○ |
| C-74〜C-75 | debug_printfのテスト | E-09 | ○ |
| C-76〜C-94 | bootpd hash.cのテスト | E-11 | ○ |
| C-95〜C-117 | tftp-options.cのテスト | E-12 | ○ |
| C-118〜C-123 | tftp-utils.cのテスト | E-13 | ○ |
| C-124〜C-131 | mknetid hash.cのテスト | E-14 | ○ |
| C-132〜C-142 | talkd table.cのテスト | E-15 | ○ |
| C-143〜C-145 | option_tsizeのテスト | E-12 | ○ |
| C-146〜C-150 | lockdflt_init/_rtld_atfork_pre/_rtld_atfork_postのテスト | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- **TIMEOUT_MIN/TIMEOUT_MAX/BLKSIZE_MIN/BLKSIZE_MAX/WINDOWSIZE_MIN/WINDOWSIZE_MAXの具体的な値**: tftp-utils.hまたはtftp-options.hで定義されるはずだが、ヘッダファイルの内容を直接確認していない
  - 候補：`libexec/tftpd/tftp-utils.h` / `libexec/tftpd/tftp-options.h` / `arpa/tftp.h`
- **rtld-elfのアーキテクチャ依存reloc.c**: amd64/i386/aarch64/arm/riscv/powerpc/powerpc64のreloc.cは解析対象外とした（アーキテクチャ固有の再配置処理）
  - 候補：各アーキテクチャ固有テストとして別途追加
- **rc/nuageinit/flua等のシェルスクリプト/Lua実装**: Cコード以外の実装はC単体テストの対象外
  - 候補：統合テスト / シェルスクリプトテストフレームワーク
- **UT-LIB-071の対象クラス誤り**: talkd/table.cのnew_idがrtld-elf/rtld_lock.cの対象クラスとして記載されている
  - 候補：対象クラスをtalkd/table.cに修正

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**: rtld-elf/rtld_malloc.cの__crt_mallocはページプール（mmap）に依存するため、単体テスト環境でのモック化が必要
- **リスク1（中）**: rtld-elf/rtld_lock.cのロック関連テストはアトミック操作に依存するため、マルチスレッドテスト環境が必要
- **リスク0（低）**: tftpd/tftp-options.cのoption_blksize/option_windowsizeはsysctlbynameに依存するためモック化推奨
- **リスク0（低）**: bootpd/hash.cは独立した汎用ADTであり、単体テストの実装が容易
- **リスク1（中）**: talkd/table.cはclock_gettimeに依存するため、時刻モック化が必要

## 6) レビュアーチェックリスト（最小）
- [ ] rtld_malloc.cのバケットサイズ計算ロジック（FIRST_BUCKET_SIZE, NBUCKETS）が正確にテストケースに反映されているか
- [ ] ロック関連テスト（UT-LIB-052〜070）のロック状態遷移が実装と一致しているか
- [ ] TFTPオプションの範囲チェック（TIMEOUT_MIN/MAX, BLKSIZE_MIN/MAX, WINDOWSIZE_MIN/MAX）の具体値が正しいか
- [ ] bootpd hash.cのhash_Insertにおけるhashcode % sizeの暗黙的適用がテストケースに考慮されているか
- [ ] talkd/table.cのMAX_LIFE定数の値がテストケースの期限切れ判定に正しく反映されているか
- [ ] UT-LIB-071の対象クラスが正しくtalkd/table.cであるか（CSVでは誤ってrtld-elf/rtld_lock.cに記載）
- [ ] アーキテクチャ依存コード（reloc.c）のテスト追加要否の判断
- [ ] flua/Luaバインディングのテスト追加要否の判断
