---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 108
  claims_without_evidence: 12
confidence_derived: 0.90
---

# 根拠レポート：netgraph 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：108 / 120、根拠なし：12
- 優先レビュー（高）
  1. **ng_bridge ループ検出の詳細条件**：ループ検出のminStableAge/loopTimeoutパラメータの正確な挙動はソース解析が必要
  2. **ng_ksocket accept処理の詳細フロー**：accept時のノード作成とフック接続の詳細手順は実行時検証が必要
  3. **ng_vlan エンカプセレーション/デカプセレーション挙動**：encap_enable/decap_enableフラグの組み合わせパターンの網羅性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sys/netgraph/ng_base.c` - netgraph基盤コード（ノード管理、フック管理、パス解析、汎用メッセージ処理）
- E-02: `sys/netgraph/netgraph.h` - netgraphカーネルヘッダ（構造体定義、マクロ、フラグ定義）
- E-03: `sys/netgraph/ng_message.h` - netgraphメッセージ定義（NGM_*コマンド、構造体、サイズ制限定数）
- E-04: `sys/netgraph/ng_bridge.c` - ブリッジノード実装（MAC学習、フラッディング、ループ検出）
- E-05: `sys/netgraph/ng_ether.c` - Ethernetノード実装（upper/lower/orphanフック、入出力処理）
- E-06: `sys/netgraph/ng_hub.c` - ハブノード実装（全フック転送、永続モード）
- E-07: `sys/netgraph/ng_tee.c` - Teeノード実装（データ複製、4フック構成）
- E-08: `sys/netgraph/ng_socket.c` - ソケットノード実装（制御/データソケット、バインド）
- E-09: `sys/netgraph/ng_vlan.c` - VLANノード実装（VLANフィルタ、encap/decap）
- E-10: `sys/netgraph/ng_one2many.c` - One2Manyノード実装（ラウンドロビン、集約）
- E-11: `sys/netgraph/ng_ksocket.c` - カーネルソケットノード実装（プロトコル解析、accept）
- E-12: `sys/netgraph/ng_macfilter.c` - MACフィルタノード実装（MACテーブル、フック振り分け）
- E-13: `sys/netgraph/ng_vlan_rotate.c` - VLANローテートノード実装（VLANタグ回転、min/max制限）
- E-14: `sys/netgraph/ng_echo.c` - エコーノード実装（データ返送）
- E-15: `sys/netgraph/ng_hole.c` - ホールノード実装（データ破棄）
- E-16: `lib/libnetgraph/sock.c` - libnetgraphソケット関数（NgMkSockNode）
- E-17: `lib/libnetgraph/msg.c` - libnetgraphメッセージ関数（NgSendMsg, NgSendAsciiMsg）
- E-18: `lib/libnetgraph/debug.c` - libnetgraphデバッグ関数（NgSetDebug）
- E-19: `lib/libnetgraph/netgraph.h` - libnetgraph公開API定義
- E-20: `tests/sys/netgraph/basic.c` - 既存ATFテスト（send_recv, node等のテストパターン参考）
- E-21: `sys/netgraph/ng_parse.h` - パース型定義ヘッダ

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-NGR-001) | ng_make_node: 有効なタイプ名でノード生成成功 | E-01 (L594-634) | ○ |
| C-02 (UT-NGR-002) | ng_make_node: NULL入力でEINVAL | E-01 (L601-604) | ○ |
| C-03 (UT-NGR-003) | ng_make_node: 未登録タイプでENXIO | E-01 (L609-610) | ○ |
| C-04 (UT-NGR-004) | ng_make_node: constructor=NULLでEINVAL | E-01 (L622-632) | ○ |
| C-05 (UT-NGR-005) | ng_make_node_common: ID割り当て | E-01 (L641-694) | ○ |
| C-06 (UT-NGR-006) | ng_make_node_common: 未登録タイプでEINVAL | E-01 (L647-650) | ○ |
| C-07 (UT-NGR-007) | ng_rmnode: 正常シャットダウン | E-01 (L714-785) | ○ |
| C-08 (UT-NGR-008) | ng_rmnode: 二重シャットダウン防止 | E-01 (L720-721) | ○ |
| C-09 (UT-NGR-009) | ng_rmnode: deadnodeガード | E-01 (L723-726) | ○ |
| C-10 (UT-NGR-010) | ng_rmnode: 永続ノード存続 | E-01 (L757-771) | ○ |
| C-11 (UT-NGR-011) | ng_unref_node: 最終参照で解放 | E-01 (L792-820) | ○ |
| C-12 (UT-NGR-012) | ng_unref_node: deadnodeガード | E-01 (L796-797) | ○ |
| C-13 (UT-NGR-013) | ng_name_node: 有効名前割当 | E-01 (L851-900) | ○ |
| C-14 (UT-NGR-014) | ng_name_node: 空文字列EINVAL | E-01 (L867-870) | ○ |
| C-15 (UT-NGR-015) | ng_name_node: ドット含有EINVAL | E-01 (L863-870) | ○ |
| C-16 (UT-NGR-016) | ng_name_node: コロン含有EINVAL | E-01 (L864) | ○ |
| C-17 (UT-NGR-017) | ng_name_node: 重複名EADDRINUSE | E-01 (L882-887) | ○ |
| C-18 (UT-NGR-018) | ng_name_node: 同名リネームnoop | E-01 (L858-860) | ○ |
| C-19 (UT-NGR-019) | ng_name_node: ID形式名禁止 | E-01 (L871-874) | ○ |
| C-20 (UT-NGR-020) | ng_name_node: NG_NODESIZ境界値 | E-01 (L863), E-03 (L51) | ○ |
| C-21 (UT-NGR-021) | ng_name2noderef: ドットで自己参照 | E-01 (L920-923) | ○ |
| C-22 (UT-NGR-022) | ng_name2noderef: 名前検索 | E-01 (L930-941) | ○ |
| C-23 (UT-NGR-023) | ng_name2noderef: ID検索 | E-01 (L926-928) | ○ |
| C-24 (UT-NGR-024) | ng_name2noderef: 不在ノード | E-01 (L930-941) | ○ |
| C-25 (UT-NGR-025) | ng_decodeidname: 有効IDデコード | E-01 (L948-966) | ○ |
| C-26 (UT-NGR-026) | ng_decodeidname: 短文字列で0 | E-01 (L956-958) | ○ |
| C-27 (UT-NGR-027) | ng_decodeidname: 括弧なしで0 | E-01 (L956) | ○ |
| C-28 (UT-NGR-028) | ng_decodeidname: 非16進で0 | E-01 (L957) | ○ |
| C-29 (UT-NGR-029) | ng_decodeidname: ゼロ値で0 | E-01 (L962) | ○ |
| C-30 (UT-NGR-030) | ng_path_parse: 絶対パス解析 | E-01 (L1658-1721) | ○ |
| C-31 (UT-NGR-031) | ng_path_parse: 相対パス解析 | E-01 (L1682-1684) | ○ |
| C-32 (UT-NGR-032) | ng_path_parse: ドットノード名 | E-01 (L1677) | ○ |
| C-33 (UT-NGR-033) | ng_path_parse: 空ノード名エラー | E-01 (L1673-1674) | ○ |
| C-34 (UT-NGR-034) | ng_path_parse: パス内コロンエラー | E-01 (L1688-1690) | ○ |
| C-35 (UT-NGR-035) | ng_path_parse: 連続ドットエラー | E-01 (L1693-1695) | ○ |
| C-36 (UT-NGR-036) | ng_path_parse: 先頭ドット除去 | E-01 (L1698-1699) | ○ |
| C-37 (UT-NGR-037) | ng_path_parse: 末尾ドット除去 | E-01 (L1700-1701) | ○ |
| C-38 (UT-NGR-038) | ng_path_parse: フック名解析 | E-01 (L1704-1711) | ○ |
| C-39 (UT-NGR-039) | ng_path2noderef: 絶対アドレス解決 | E-01 (L1727-1757) | ○ |
| C-40 (UT-NGR-040) | ng_path2noderef: NULLガード | E-01 (L1736-1739) | ○ |
| C-41 (UT-NGR-041) | ng_path2noderef: 不正パスエラー | E-01 (L1747-1749) | ○ |
| C-42 (UT-NGR-042) | ng_add_hook: 有効名フック生成 | E-01 (L223) | ○ |
| C-43 (UT-NGR-043) | ng_add_hook: 空名エラー | E-01 | ○ |
| C-44 (UT-NGR-044) | ng_add_hook: 名前長制限 | E-01, E-03 (L50: NG_HOOKSIZ=32) | ○ |
| C-45 (UT-NGR-045) | ng_destroy_hook: フック破棄 | E-01 (L242) | ○ |
| C-46 (UT-NGR-046) | ng_con_nodes: ノード接続 | E-01 (L232-234) | ○ |
| C-47 (UT-NGR-047) | ng_mkpeer: ピア作成 | E-01 (L236-237) | ○ |
| C-48 (UT-NGR-048) | ng_mkpeer: 不正タイプエラー | E-01 (L236) | ○ |
| C-49 (UT-NGR-049) | ng_generic_msg: SHUTDOWN処理 | E-01 (L224), E-03 (L118) | ○ |
| C-50 (UT-NGR-050) | ng_generic_msg: MKPEER処理 | E-01 (L224), E-03 (L119) | ○ |
| C-51 (UT-NGR-051) | ng_generic_msg: CONNECT処理 | E-01 (L224), E-03 (L120) | ○ |
| C-52 (UT-NGR-052) | ng_generic_msg: NAME処理 | E-01, E-03 (L121) | ○ |
| C-53 (UT-NGR-053) | ng_generic_msg: RMHOOK処理 | E-01, E-03 (L122) | ○ |
| C-54 (UT-NGR-054) | ng_generic_msg: NODEINFO処理 | E-01, E-03 (L125) | ○ |
| C-55 (UT-NGR-055) | ng_ID2noderef: 有効ID検索 | E-01 (L825-836) | ○ |
| C-56 (UT-NGR-056) | ng_ID2noderef: 不在ID | E-01 (L825-836) | ○ |
| C-57 (UT-NGR-057) | ng_node2ID: ノード→ID | E-01 (L838-842) | ○ |
| C-58 (UT-NGR-058) | ng_node2ID: NULL入力 | E-01 (L841) | ○ |
| C-59 (UT-NGR-059) | ng_bridge constructor | E-04 | ○ |
| C-60 (UT-NGR-060) | ng_bridge ユニキャスト転送 | E-04 (MACテーブルとフラッディングロジック) | ○ |
| C-61 (UT-NGR-061) | ng_bridge フラッディング | E-04 (L42-43コメント) | ○ |
| C-62 (UT-NGR-062) | ng_bridge ブロードキャスト | E-04 | ○ |
| C-63 (UT-NGR-063) | ng_bridge ラントパケット | E-04 (L94: recvRunts) | ○ |
| C-64 (UT-NGR-064) | ng_bridge 不正送信元MAC | E-04 (L95: recvInvalid) | ○ |
| C-65 (UT-NGR-065) | ng_bridge ループ検出 | E-04 (L43-44コメント) | △ |
| C-66 (UT-NGR-066) | ng_bridge_put MAC登録 | E-04 (L172) | ○ |
| C-67 (UT-NGR-067) | ng_bridge_remove_hosts リンク別削除 | E-04 (L174) | ○ |
| C-68 (UT-NGR-068) | ng_bridge_timeout エージング | E-04 (L175, L49コメント) | ○ |
| C-69 (UT-NGR-069) | ng_ether_input upper転送 | E-05 (L97) | ○ |
| C-70 (UT-NGR-070) | ng_ether_input_orphan orphan転送 | E-05 (L98) | ○ |
| C-71 (UT-NGR-071) | ng_ether_output lower送信 | E-05 (L99) | ○ |
| C-72 (UT-NGR-072) | ng_ether_rcv_lower 物理IF送出 | E-05 (L102) | ○ |
| C-73 (UT-NGR-073) | ng_ether_rcv_upper プロトコルスタック | E-05 (L103) | △ |
| C-74 (UT-NGR-074) | ng_hub_constructor | E-06 (L52) | ○ |
| C-75 (UT-NGR-075) | ng_hub_rcvdata 全フック転送 | E-06 (L55) | ○ |
| C-76 (UT-NGR-076) | ng_hub_rcvdata 単一フック | E-06 | ○ |
| C-77 (UT-NGR-077) | ng_hub_rcvmsg persistent設定 | E-06 (L61-66) | ○ |
| C-78 (UT-NGR-078) | ng_hub_shutdown | E-06 (L54) | ○ |
| C-79 (UT-NGR-079) | ng_hub_disconnect 最終フック | E-06 (L56) | ○ |
| C-80 (UT-NGR-080) | ng_tee right→left複製 | E-07 (L46-49コメント) | ○ |
| C-81 (UT-NGR-081) | ng_tee left→right複製 | E-07 (L46-49コメント) | ○ |
| C-82 (UT-NGR-082) | ng_tee left2right→left | E-07 (L48-49コメント) | ○ |
| C-83 (UT-NGR-083) | ng_tee 未接続複製先 | E-07 | △ |
| C-84 (UT-NGR-084) | ng_socket attach_cntl | E-08 (L122) | ○ |
| C-85 (UT-NGR-085) | ng_socket attach_data | E-08 (L121) | ○ |
| C-86 (UT-NGR-086) | ng_socket connect_data | E-08 (L126) | ○ |
| C-87 (UT-NGR-087) | ng_socket bind | E-08 (L127) | ○ |
| C-88 (UT-NGR-088) | ng_vlan VLANフィルタリング | E-09 (L50-57, L70) | ○ |
| C-89 (UT-NGR-089) | ng_vlan nomatch転送 | E-09 (L52) | ○ |
| C-90 (UT-NGR-090) | ng_vlan デカプセレーション | E-09 (L53) | ○ |
| C-91 (UT-NGR-091) | ng_vlan エンカプセレーション | E-09 (L54) | △ |
| C-92 (UT-NGR-092) | ng_vlan downstreamフック名 | E-09 (L69) | ○ |
| C-93 (UT-NGR-093) | ng_vlan nomatchフック名 | E-09 (L69) | ○ |
| C-94 (UT-NGR-094) | ng_vlan フィルタ追加 | E-09 (L67) | ○ |
| C-95 (UT-NGR-095) | ng_vlan VLAN ID=0境界値 | E-09 (L56: EVL_VLID_MASK) | △ |
| C-96 (UT-NGR-096) | ng_vlan VLAN ID=4095境界値 | E-09 (L56: EVL_VLID_MASK) | ○ |
| C-97 (UT-NGR-097) | ng_one2many ラウンドロビン | E-10 (L41-47コメント, L71-77) | ○ |
| C-98 (UT-NGR-098) | ng_one2many many→one | E-10 (L46コメント) | ○ |
| C-99 (UT-NGR-099) | ng_one2many activeMany=0 | E-10 (L75) | △ |
| C-100 (UT-NGR-100) | ng_ksocket プロトコル名解析 | E-11 (L180-181) | ○ |
| C-101 (UT-NGR-101) | ng_ksocket 数値プロトコル | E-11 (L180) | ○ |
| C-102 (UT-NGR-102) | ng_ksocket accept処理 | E-11 (L174) | △ |
| C-103 (UT-NGR-103) | ng_macfilter 登録MAC転送 | E-12 (L31-36コメント) | ○ |
| C-104 (UT-NGR-104) | ng_macfilter defaultフック転送 | E-12 (L33-34コメント) | ○ |
| C-105 (UT-NGR-105) | ng_macfilter 未接続破棄 | E-12 | △ |
| C-106 (UT-NGR-106) | ng_vlan_rotate タグ回転 | E-13 (L53, L57) | ○ |
| C-107 (UT-NGR-107) | ng_vlan_rotate min未満でexcessive | E-13 (L63: min field) | ○ |
| C-108 (UT-NGR-108) | ng_vlan_rotate max超でexcessive | E-13 (L64: max field) | ○ |
| C-109 (UT-NGR-109) | ng_vlan_rotate rot=0パススルー | E-13 (L62: rot field) | ○ |
| C-110 (UT-NGR-110) | NgMkSockNode ソケット作成 | E-16 (L58-100) | ○ |
| C-111 (UT-NGR-111) | NgMkSockNode 無名ノード | E-16 (L67-68) | ○ |
| C-112 (UT-NGR-112) | NgMkSockNode 空文字列 | E-16 (L67-68) | ○ |
| C-113 (UT-NGR-113) | NgSendMsg メッセージ送信 | E-17 (L63-82) | ○ |
| C-114 (UT-NGR-114) | NgSendMsg ヘッダバージョン | E-17 (L71) | ○ |
| C-115 (UT-NGR-115) | NgSendMsg トークン単調増加 | E-17 (L73) | ○ |
| C-116 (UT-NGR-116) | NgSendAsciiMsg ASCII送信 | E-17 (L88-119) | ○ |
| C-117 (UT-NGR-117) | NgSendAsciiMsg vasprintf失敗 | E-17 (L100-101) | △ |
| C-118 (UT-NGR-118) | NgSetDebug レベル設定 | E-18 (L111) | ○ |
| C-119 (UT-NGR-119) | ng_echo エコー動作 | E-14 | △ |
| C-120 (UT-NGR-120) | ng_hole 破棄動作 | E-15 | △ |

## 4) 不足情報（Unknown / Missing）
- **ng_bridge ループ検出の詳細実装（C-65）**：コメントにminStableAge/loopTimeoutの記述があるが、実際の判定ロジックの詳細はng_bridge_rcvdata内部を深く確認する必要がある
  - 候補：ng_bridge.c rcvdata関数の完全解析 / ng_bridge.hの設定構造体
- **ng_ether_rcv_upper Ethernetヘッダ付与の詳細（C-73）**：プロトコルスタックへの受け渡し詳細は関数本体の解析が不足
  - 候補：ng_ether.c rcv_upper関数の完全解析
- **ng_tee 未接続複製先のスキップ条件（C-83）**：dupフックがNULLの場合の正確な挙動はソース確認が必要
  - 候補：ng_tee.c rcvdata関数の完全解析
- **ng_vlan encap_enable詳細（C-91）**：エンカプセレーション時のプロトコルフィールド設定の詳細
  - 候補：ng_vlan.c rcvdata関数の完全解析 / encap_proto変数の使用箇所
- **ng_vlan VLAN ID=0の有効性（C-95）**：VLAN ID=0が有効な値として扱われるかどうかの仕様確認が必要
  - 候補：IEEE 802.1Q仕様 / ng_vlan.cのバリデーションロジック
- **ng_one2many activeMany=0の動作（C-99）**：転送先なしの場合のパケット処理詳細
  - 候補：ng_one2many.c rcvdata関数の完全解析
- **ng_ksocket accept詳細フロー（C-102）**：accept時のノード/フック作成手順の詳細
  - 候補：ng_ksocket.c accept関数の完全解析
- **ng_macfilter 未接続時挙動（C-105）**：etherフック未接続時の正確な動作パス
  - 候補：ng_macfilter.c rcvdata関数の完全解析
- **ng_echo/ng_hole 詳細実装（C-119, C-120）**：単純なノードだが実装の完全確認は未実施
  - 候補：ng_echo.c / ng_hole.c の完全解析
- **NgSendAsciiMsg vasprintf失敗条件（C-117）**：実際のメモリ不足時の挙動確認
  - 候補：実行時テスト

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - ng_bridge ループ検出テストケース（C-65）：ループ検出のタイミング依存条件が正確でない可能性
- **1: 中リスク** - ng_vlan エンカプセレーション（C-91）：encap_proto設定の影響範囲が不明確
- **0: 低リスク** - ng_echo/ng_hole（C-119, C-120）：実装が極めて単純なため影響は限定的
- **0: 低リスク** - libnetgraph API（C-110〜C-118）：ユーザ空間APIでソースが明確に読み取れる
- **1: 中リスク** - テスト網羅性：ng_async, ng_bpf, ng_cisco, ng_l2tp, ng_pppoe等の複雑なノードタイプは対象外としている

## 6) レビュアーチェックリスト（最小）
- [ ] ng_base.c のノード管理関数（ng_make_node, ng_rmnode, ng_name_node）のテストケースが主要パスを網羅しているか
- [ ] ng_path_parse のパス解析テストケースが全分岐条件（空ノード名、連続ドット、コロン）をカバーしているか
- [ ] ng_bridge のループ検出テストケース（UT-NGR-065）の前提条件が実際の実装と整合しているか
- [ ] ng_vlan のVLAN ID境界値（0, 4095）テストケースが仕様と一致しているか
- [ ] ng_tee の4フック構成（left, right, left2right, right2left）の全パターンがカバーされているか
- [ ] ng_one2many のラウンドロビン以外のアルゴリズム（failover等）が存在する場合、テストケースが不足していないか
- [ ] libnetgraph APIのエラーパス（ソケット作成失敗、kldload失敗等）が十分にカバーされているか
- [ ] ng_async, ng_bpf, ng_cisco, ng_l2tp, ng_pppoe等の未対象ノードタイプについて追加テストが必要か検討すること
