---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 227
  claims_with_evidence: 210
  claims_without_evidence: 17
confidence_derived: 0.93
---

# 根拠レポート：network-core 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：210 / 227、根拠なし：17
- 優先レビュー（高）
  1. **TCP輻輳制御関連テスト（UT-NWC-195〜197）**：cc_ack_received, cc_cong_signal, cc_conn_initの内部動作はソースコードから関数シグネチャのみ確認。cwnd/ssthresh更新ロジックの詳細は未精査
  2. **BPFフィルタ実行テスト（UT-NWC-128〜132）**：bpf_filterのBPFバイトコードインタプリタ内部動作の網羅性が不十分。全命令セットのカバレッジは未検証
  3. **VJ圧縮テスト（UT-NWC-220〜221）**：sl_compress_tcp/sl_uncompress_tcpの圧縮コンテキスト状態管理の詳細は未精査

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sys/net/if.c` - ネットワークインタフェース管理（ifnet_byindex, if_alloc, if_free, if_ref, if_rele, if_attach, if_detach等）
- E-02: `sys/net/radix.c` - Radixツリー実装（rn_search, rn_lookup, rn_match, rn_insert, rn_addroute, rn_delete, rn_walktree, rn_inithead等）
- E-03: `sys/net/route.c` - ルーティングテーブル管理（rt_table_init, rt_table_destroy, rib_add_redirect, ifa_ifwithroute, rt_flushifroutes, rt_maskedcopy等）
- E-04: `sys/netinet/ip_input.c` - IPv4入力処理（ip_input, ip_forward, ipproto_register/unregister）
- E-05: `sys/netinet/ip_output.c` - IPv4出力処理（ip_output, ip_fragment, in_delayed_cksum）
- E-06: `sys/netinet/ip_icmp.c` - ICMP処理（icmp_error, icmp_input, icmp_reflect, ip_next_mtu, badport_bandlim）
- E-07: `sys/netinet/in_pcb.c` - プロトコル制御ブロック管理（in_pcballoc, in_pcbbind, in_pcbconnect, in_pcbdisconnect, in_pcblisten, in_pcb_lport）
- E-08: `sys/netinet/in_cksum.c` - チェックサム計算（in_cksum_skip, in_cksum_hdr, in_addword, in_pseudo）
- E-09: `sys/netinet/in.c` - IPv4アドレス管理（in_localaddr, in_localip, in_canforward, in_mask2len, in_ifhasaddr）
- E-10: `sys/netinet/ip_ecn.c` - ECN処理（ip_ecn_ingress, ip_ecn_egress）
- E-11: `sys/netinet/ip_reass.c` - IPフラグメント再構成（ip_reass, ipreass_drain）
- E-12: `sys/netinet/ip_id.c` - IP ID生成（ip_fillid, ip_randomid）
- E-13: `sys/net/bpf_filter.c` - BPFフィルタ（bpf_filter, bpf_validate）
- E-14: `sys/net/netisr.c` - ネットワークISR（netisr_register, netisr_unregister, netisr_getqlimit, netisr_setqlimit）
- E-15: `sys/net/pfil.c` - パケットフィルタフレームワーク（pfil_head_register, pfil_mbuf_in, pfil_mbuf_out）
- E-16: `sys/net/if_ethersubr.c` - Ethernet処理（ether_output, ether_input_internal, ether_resolve_addr, ether_sprintf）
- E-17: `sys/netinet/if_ether.c` - ARP処理（arpresolve, arprequest, in_arpinput, arp_fillheader）
- E-18: `sys/netinet/in_fib.c` - FIBルックアップ（fib4_lookup, fib4_check_urpf, fib4_calc_software_hash）
- E-19: `sys/net/rtsock.c` - ルーティングソケット（rt_xaddrs, rtsock_msg_buffer）
- E-20: `sys/netinet6/ip6_input.c` - IPv6入力処理（ip6_input, ip6_process_hopopts, ip6_unknown_opt）
- E-21: `sys/netinet/tcp_input.c` - TCP入力処理（tcp_input, tcp_dooptions, tcp_mss, tcp_xmit_timer, cc_ack_received, cc_cong_signal）
- E-22: `sys/netinet/tcp_output.c` - TCP出力処理（tcp_default_output, tcp_setpersist, tcp_addoptions）
- E-23: `sys/netinet/tcp_timer.c` - TCPタイマー（tcp_timer_rexmt, tcp_timer_2msl, tcp_timer_keep, tcp_timer_persist, tcp_timer_delack）
- E-24: `sys/netinet/udp_usrreq.c` - UDP処理（udp_input, udp_send, udp_attach, udp_abort）
- E-25: `sys/net/if_vlan.c` - VLAN処理（vlan_input, vlan_ioctl）
- E-26: `sys/net/if_bridge.c` - ブリッジ処理（bridge_input, bridge_output）
- E-27: `sys/net/if_lagg.c` - LAGG処理（lagg_port_create, lagg_port_destroy）
- E-28: `sys/netinet6/nd6_nbr.c` - NDP近隣探索（nd6_ns_input）
- E-29: `sys/netinet6/frag6.c` - IPv6フラグメント（frag6_input）
- E-30: `sys/netinet6/icmp6.c` - ICMPv6処理（icmp6_input）
- E-31: `sys/net/slcompress.c` - VJ圧縮（sl_compress_tcp, sl_uncompress_tcp）
- E-32: `sys/netinet/igmp.c` - IGMP処理（igmp_input）
- E-33: `sys/netinet/in_mcast.c` - マルチキャスト管理（in_joingroup, in_leavegroup）
- E-34: `sys/net/if_loop.c` - ループバック（looutput）
- E-35: `sys/net/toeplitz.c` - Toeplitzハッシュ（toeplitz_hash）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ifnet_byindex: 有効インデックスでifnet取得（UT-NWC-001） | E-01 | ○ |
| C-02 | ifnet_byindex: 範囲外でNULL返却（UT-NWC-002） | E-01 | ○ |
| C-03 | ifnet_byindex_ref: 参照カウント付き取得（UT-NWC-003〜004） | E-01 | ○ |
| C-04 | if_alloc/if_alloc_domain: ifnet割り当て（UT-NWC-005〜006） | E-01 | ○ |
| C-05 | if_free: ifnet解放（UT-NWC-007） | E-01 | ○ |
| C-06 | if_ref/if_try_ref/if_rele: 参照カウント管理（UT-NWC-008〜012） | E-01 | ○ |
| C-07 | if_attach/if_detach: インタフェース登録/除去（UT-NWC-013〜014） | E-01 | ○ |
| C-08 | if_setflag: フラグ設定（UT-NWC-015〜016） | E-01 | ○ |
| C-09 | ifq_init/ifq_delete: キュー管理（UT-NWC-017〜018） | E-01 | ○ |
| C-10 | if_hw_tsomax_update: TSO更新（UT-NWC-019） | E-01 | ○ |
| C-11 | if_input_default/if_transmit_default: 入出力処理（UT-NWC-020〜021） | E-01 | ○ |
| C-12 | if_purgeaddrs/if_delmulti_locked: アドレスパージ/マルチキャスト削除（UT-NWC-022〜024） | E-01 | ○ |
| C-13 | rn_search/rn_search_m: Radix検索（UT-NWC-025〜027） | E-02 | ○ |
| C-14 | rn_lookup: 完全一致検索（UT-NWC-028〜029） | E-02 | ○ |
| C-15 | rn_match: 最長一致検索（UT-NWC-030〜031） | E-02 | ○ |
| C-16 | rn_insert: エントリ挿入（UT-NWC-032〜033） | E-02 | ○ |
| C-17 | rn_addroute: ルート追加（UT-NWC-034） | E-02 | ○ |
| C-18 | rn_delete: ルート削除（UT-NWC-035〜036） | E-02 | ○ |
| C-19 | rn_walktree/rn_inithead/rn_detachhead: ツリー操作（UT-NWC-037〜040） | E-02 | ○ |
| C-20 | rn_refines/rn_satisfies_leaf: マスク/リーフ判定（UT-NWC-041〜043） | E-02 | ○ |
| C-21 | rt_table_init/rt_table_destroy: テーブル管理（UT-NWC-044〜045） | E-03 | ○ |
| C-22 | rib_add_redirect: リダイレクトルート追加（UT-NWC-046〜047） | E-03 | ○ |
| C-23 | ifa_ifwithroute: インタフェースアドレス解決（UT-NWC-048〜049） | E-03 | ○ |
| C-24 | rt_flushifroutes/rt_getifa_fib/rt_maskedcopy: ルート操作（UT-NWC-050〜053） | E-03 | ○ |
| C-25 | rt_addrmsg/rt_ifmsg: ルーティングソケット通知（UT-NWC-054〜055） | E-03 | ○ |
| C-26 | ip_input: IPv4入力処理（UT-NWC-056〜061） | E-04 | ○ |
| C-27 | ip_forward: IP転送（UT-NWC-062〜064） | E-04 | ○ |
| C-28 | ipproto_register/unregister: プロトコル登録（UT-NWC-065〜067） | E-04 | ○ |
| C-29 | ip_output: IPv4出力処理（UT-NWC-068〜071） | E-05 | ○ |
| C-30 | ip_fragment: フラグメント処理（UT-NWC-072〜073） | E-05 | ○ |
| C-31 | in_delayed_cksum: 遅延チェックサム（UT-NWC-074） | E-05 | ○ |
| C-32 | icmp_error: ICMPエラー生成（UT-NWC-075〜077） | E-06 | ○ |
| C-33 | icmp_input: ICMP入力処理（UT-NWC-078〜080） | E-06 | ○ |
| C-34 | icmp_reflect/ip_next_mtu/badport_bandlim: ICMP補助関数（UT-NWC-081〜085） | E-06 | ○ |
| C-35 | in_pcballoc: PCB割り当て（UT-NWC-086〜087） | E-07 | ○ |
| C-36 | in_pcbbind: ソケットバインド（UT-NWC-088〜091） | E-07 | ○ |
| C-37 | in_pcbconnect/in_pcbdisconnect/in_pcblisten: 接続管理（UT-NWC-092〜095） | E-07 | ○ |
| C-38 | in_pcb_lport/in_pcbladdr: ポート/アドレス解決（UT-NWC-096〜098） | E-07 | ○ |
| C-39 | in_cksum_skip/in_cksum_hdr/in_addword/in_pseudo: チェックサム計算（UT-NWC-099〜104） | E-08 | ○ |
| C-40 | in_localaddr/in_localip/in_canforward: アドレス判定（UT-NWC-105〜111） | E-09 | ○ |
| C-41 | in_mask2len: マスク変換（UT-NWC-112〜114） | E-09 | ○ |
| C-42 | in_ifhasaddr/in_socktrim: アドレス操作（UT-NWC-115〜117） | E-09 | ○ |
| C-43 | ip_ecn_ingress/ip_ecn_egress: ECN処理（UT-NWC-118〜120） | E-10 | ○ |
| C-44 | ip_reass: IP再構成（UT-NWC-121〜124） | E-11 | ○ |
| C-45 | ipreass_drain: 再構成キュー排出（UT-NWC-125） | E-11 | ○ |
| C-46 | ip_fillid: IP ID生成（UT-NWC-126〜127） | E-12 | ○ |
| C-47 | bpf_filter: BPFフィルタ実行（UT-NWC-128〜129） | E-13 | △ |
| C-48 | bpf_validate: BPFプログラム検証（UT-NWC-130〜132） | E-13 | ○ |
| C-49 | netisr_register/unregister: ISR登録（UT-NWC-133〜134） | E-14 | ○ |
| C-50 | netisr_getqlimit/setqlimit/default_flow2cpu: ISR補助関数（UT-NWC-135〜137） | E-14 | ○ |
| C-51 | pfil_head_register/unregister: pfilフレームワーク（UT-NWC-138〜139） | E-15 | ○ |
| C-52 | pfil_mbuf_in/out: パケットフィルタ実行（UT-NWC-140〜142） | E-15 | ○ |
| C-53 | ether_output: Ethernet送出（UT-NWC-143〜144） | E-16 | ○ |
| C-54 | ether_input_internal: Ethernet受信（UT-NWC-145〜147） | E-16 | ○ |
| C-55 | ether_resolve_addr/ether_sprintf: アドレス解決/表示（UT-NWC-148〜150） | E-16 | ○ |
| C-56 | arpresolve/arprequest/in_arpinput/arp_fillheader: ARP処理（UT-NWC-151〜156） | E-17 | ○ |
| C-57 | fib4_lookup/fib4_check_urpf/fib4_calc_software_hash: FIB関連（UT-NWC-157〜162） | E-18 | ○ |
| C-58 | rt_xaddrs/rtsock_msg_buffer: ルーティングソケット（UT-NWC-163〜165） | E-19 | ○ |
| C-59 | ip6_input: IPv6入力処理（UT-NWC-166〜169） | E-20 | ○ |
| C-60 | ip6_process_hopopts/ip6_unknown_opt: IPv6オプション処理（UT-NWC-170〜172） | E-20 | ○ |
| C-61 | tcp_input: TCP入力処理（UT-NWC-173〜175） | E-21 | ○ |
| C-62 | tcp_dooptions: TCPオプション解析（UT-NWC-176〜177） | E-21 | ○ |
| C-63 | tcp_mss: MSS交渉（UT-NWC-178〜179） | E-21 | ○ |
| C-64 | tcp_xmit_timer: RTT推定（UT-NWC-180〜181） | E-21 | ○ |
| C-65 | tcp_compute_initwnd/tcp_compute_pipe: ウィンドウ/パイプ計算（UT-NWC-182〜183） | E-21 | ○ |
| C-66 | cc_ack_received: 輻輳制御ACK処理のcwnd更新ロジック（UT-NWC-195） | E-21 | △ |
| C-67 | cc_cong_signal: 輻輳シグナルのcwnd/ssthresh更新（UT-NWC-196） | E-21 | △ |
| C-68 | cc_conn_init: 輻輳制御初期パラメータ設定（UT-NWC-197） | E-21 | △ |
| C-69 | tcp_default_output: TCP送信処理（UT-NWC-184〜185） | E-22 | ○ |
| C-70 | tcp_setpersist: パーシストタイマー設定（UT-NWC-186） | E-22 | ○ |
| C-71 | tcp_addoptions: TCPオプション構築（UT-NWC-187） | E-22 | ○ |
| C-72 | tcp_timer_rexmt: 再送タイマー（UT-NWC-188〜189） | E-23 | ○ |
| C-73 | tcp_timer_2msl: TIME_WAITタイマー（UT-NWC-190） | E-23 | ○ |
| C-74 | tcp_timer_keep: キープアライブタイマー（UT-NWC-191〜192） | E-23 | ○ |
| C-75 | tcp_timer_persist: パーシストタイマー（UT-NWC-193） | E-23 | ○ |
| C-76 | tcp_timer_delack: 遅延ACKタイマー（UT-NWC-194） | E-23 | ○ |
| C-77 | udp_input: UDP受信処理（UT-NWC-198〜200） | E-24 | ○ |
| C-78 | udp_send: UDP送信処理（UT-NWC-201〜202） | E-24 | ○ |
| C-79 | udp_attach/udp_abort: UDPソケット管理（UT-NWC-203〜204） | E-24 | ○ |
| C-80 | vlan_input/vlan_ioctl: VLAN処理（UT-NWC-205〜207） | E-25 | ○ |
| C-81 | bridge_input/bridge_output: ブリッジ処理（UT-NWC-208〜210） | E-26 | ○ |
| C-82 | lagg_port_create/lagg_port_destroy: LAGG処理（UT-NWC-211〜212） | E-27 | ○ |
| C-83 | toeplitz_hash: Toeplitzハッシュ計算（UT-NWC-213） | E-35 | △ |
| C-84 | nd6_ns_input: NDP近隣探索（UT-NWC-214〜215） | E-28 | ○ |
| C-85 | frag6_input: IPv6フラグメント再構成（UT-NWC-216〜217） | E-29 | ○ |
| C-86 | icmp6_input: ICMPv6処理（UT-NWC-218〜219） | E-30 | ○ |
| C-87 | sl_compress_tcp/sl_uncompress_tcp: VJ圧縮（UT-NWC-220〜221） | E-31 | △ |
| C-88 | igmp_input: IGMP処理（UT-NWC-222〜223） | E-32 | ○ |
| C-89 | in_joingroup/in_leavegroup: マルチキャスト管理（UT-NWC-224〜225） | E-33 | △ |
| C-90 | looutput: ループバック処理（UT-NWC-226〜227） | E-34 | ○ |

## 4) 不足情報（Unknown / Missing）
- **TCP輻輳制御アルゴリズムの詳細動作**（C-66〜68）：cc_ack_received, cc_cong_signal, cc_conn_initの関数シグネチャはソースコードから確認したが、各輻輳制御アルゴリズム（NewReno, CUBIC等）のモジュール固有ロジックの詳細は `sys/netinet/cc/` 配下のファイルに依存しており、本モジュール範囲外のため未精査
  - 候補：`sys/netinet/cc/cc_newreno.c` / `sys/netinet/cc/cc_cubic.c` / `sys/netinet/cc/cc_htcp.c`
- **BPFフィルタの全命令セットカバレッジ**（C-47）：bpf_filterは40以上のBPF命令をサポートするが、テストケースではaccept-all/reject-allのみ記載。全命令の単体テストは別途必要
  - 候補：BPF命令セットごとのテストケース / FreeBSD ATFテストスイート
- **VJ圧縮の状態管理**（C-87）：sl_compress_tcp/sl_uncompress_tcpの圧縮コンテキスト（接続スロット管理、差分圧縮状態）の詳細は関数シグネチャレベルでの確認にとどまる
  - 候補：`sys/net/slcompress.c`の詳細解析 / RFC 1144仕様
- **マルチキャスト管理のソースフィルタ**（C-89）：in_joingroup/in_leavegroup関数のIGMPv3ソースフィルタリング詳細は未精査
  - 候補：`sys/netinet/in_mcast.c`の詳細解析 / RFC 3376仕様
- **Toeplitzハッシュの関数内部ロジック**（C-83）：toeplitz.cのファイルは確認したが関数内部のハッシュ計算ロジックの詳細検証は未実施
  - 候補：`sys/net/toeplitz.c`の詳細解析 / Microsoft RSS仕様

## 5) リスクフラグ（レビュー観点）
- **リスク2（高リスク）**：TCP輻輳制御テスト（UT-NWC-195〜197）。輻輳制御の不具合はネットワーク全体のパフォーマンスに影響するため、各CCモジュールとの統合テストが必要
- **リスク1（中リスク）**：IP再構成テスト（UT-NWC-121〜124）。フラグメント再構成の不具合はセキュリティ脆弱性（teardrop攻撃等）につながる可能性があるため、セキュリティ観点のテストケース追加を推奨
- **リスク1（中リスク）**：BPFフィルタ検証テスト（UT-NWC-130〜132）。bpf_validateのバイパスはカーネル空間での任意コード実行につながる可能性がある
- **リスク1（中リスク）**：ARP入力処理（UT-NWC-154〜155）。ARPスプーフィング攻撃に対する防御のテストケースが不足
- **リスク0（低リスク）**：VJ圧縮テスト（UT-NWC-220〜221）。レガシー機能で使用頻度は低い

## 6) レビュアーチェックリスト（最小）
- [ ] TCP輻輳制御テスト（UT-NWC-195〜197）のcwnd/ssthresh期待値が各CCモジュールのアルゴリズムと一致するか確認
- [ ] IPフラグメント再構成テスト（UT-NWC-121〜124）にteardrop攻撃等のセキュリティテストケースを追加する必要がないか検討
- [ ] BPFフィルタテスト（UT-NWC-128〜132）の命令セットカバレッジが十分か確認
- [ ] ARP処理テスト（UT-NWC-151〜156）にARPスプーフィング防御のテストケースを追加する必要がないか検討
- [ ] ポートバインド境界値テスト（UT-NWC-090〜091）のエフェメラルポート範囲がsysctl設定と整合するか確認
- [ ] uRPFテスト（UT-NWC-159〜160）のstrict/looseモードの網羅性を確認
- [ ] IPv6 NDP関連テスト（UT-NWC-214〜215）にRA Guard等のセキュリティ機能テストが不要か検討
- [ ] 各テストケースの「前提条件」がカーネルテスト環境で再現可能か確認
