---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 89
  claims_without_evidence: 11
confidence_derived: 0.89
---

# 根拠レポート：sbin 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧(sbin.csv)の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容(Claim：主張)を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テスト・ヘッダファイルなどの根拠(Evidence)が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：89 / 100、根拠なし：11
- 優先レビュー（高）
  1. **UT-SBIN-085〜087 (sysctl関連)**：カーネル依存関数のため、ユーザ空間での単体テスト実行可否が不確定
  2. **UT-SBIN-089〜091 (rcorder依存関係解析)**：テスト対象メソッドがmain関数内のロジックであり、単体テスト切り出しの可否が要確認
  3. **UT-SBIN-088 (route keywords)**：静的データの検証であり、テスト価値の評価が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sbin/ping/utils.c` - in_cksum関数の実装
- E-02: `sbin/ping/utils.h` - in_cksum関数宣言
- E-03: `sbin/ping/tests/in_cksum_test.c` - 既存ATFテスト(4ケース)
- E-04: `sbin/hastd/ebuf.c` - extensible buffer実装
- E-05: `sbin/hastd/ebuf.h` - ebuf API宣言
- E-06: `sbin/hastd/rangelock.c` - 範囲ロック実装
- E-07: `sbin/hastd/rangelock.h` - rangelock API宣言
- E-08: `sbin/hastd/activemap.c` - 活性マップ実装
- E-09: `sbin/hastd/activemap.h` - activemap API宣言
- E-10: `sbin/hastd/nv.c` - 名前-値ペア実装
- E-11: `sbin/hastd/nv.h` - nv API宣言
- E-12: `sbin/fdisk/fdisk_mbr_enc.c` - MBRパーティションenc/dec実装
- E-13: `sbin/fdisk/fdisk_mbr_enc.h` - fdisk_mbr_enc API宣言
- E-14: `sbin/md5/md5.c` - ハッシュ計算ユーティリティ(MDInput, MDOutput, gnu_check, MDTestSuite等)
- E-15: `sbin/fsck/fsutil.c` - fsckユーティリティ関数(getfsopt, setcdevname等)
- E-16: `sbin/fsck/fsutil.h` - fsutil API宣言
- E-17: `sbin/sysctl/sysctl.c` - sysctl実装(strIKtoi, name2oid, oidfmt)
- E-18: `sbin/route/route.c` - routeコマンド実装(keywords配列)
- E-19: `sbin/rcorder/rcorder.c` - rcorder依存関係解析実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-03 | in_cksum正常系テスト(アライン/非アライン) | E-01, E-02, E-03 | ○ |
| C-04〜C-07 | in_cksum境界値テスト(len=0, len=1, 全0, 全0xFF) | E-01 | ○ |
| C-08〜C-09 | ebuf_alloc正常系テスト | E-04, E-05 | ○ |
| C-10 | ebuf_free正常系テスト | E-04 | ○ |
| C-11〜C-13 | ebuf_add_head正常系/境界値テスト | E-04 | ○ |
| C-14〜C-15 | ebuf_add_tail正常系/境界値テスト | E-04 | ○ |
| C-16〜C-17 | ebuf_del_head/del_tail正常系テスト | E-04 | ○ |
| C-18〜C-20 | ebuf_data/ebuf_size正常系/境界値テスト | E-04 | ○ |
| C-21 | rangelock_init正常系テスト | E-06, E-07 | ○ |
| C-22 | rangelock_add正常系テスト | E-06 | ○ |
| C-23〜C-27 | rangelock_islocked正常系/境界値テスト | E-06 | ○ |
| C-28 | rangelock_del正常系テスト | E-06 | ○ |
| C-29 | rangelock_free正常系テスト | E-06 | ○ |
| C-30〜C-32 | activemap_init正常系/異常系/境界値テスト | E-08, E-09 | ○ |
| C-33〜C-35 | bitcount32正常系/境界値テスト | E-08 | ○ |
| C-36〜C-38 | off2ext/ext2off変換テスト | E-08 | ○ |
| C-39〜C-41 | activemap_write_start/ndirty正常系テスト | E-08, E-09 | ○ |
| C-42〜C-45 | activemap_free/size/ondisk_size/calc_ondisk_sizeテスト | E-08, E-09 | ○ |
| C-46〜C-51 | dos_partition_dec/enc正常系/境界値テスト | E-12, E-13 | ○ |
| C-52〜C-55 | MDTestSuite各アルゴリズムテスト | E-14 | ○ |
| C-56〜C-60 | MDInput各モードテスト | E-14 | ○ |
| C-61〜C-66 | MDOutput各モード/エラーテスト | E-14 | ○ |
| C-67〜C-69 | gnu_check解析テスト | E-14 | ○ |
| C-70〜C-72 | main関数モード検出/オプション処理テスト | E-14 | ○ |
| C-73〜C-78 | getfsopt正常系/異常系/境界値テスト | E-15, E-16 | ○ |
| C-79 | setcdevname/cdevnameテスト | E-15 | ○ |
| C-80〜C-84 | nv構造体/add/find/swapテスト | E-10, E-11 | ○ |
| C-85 | strIKtoi温度文字列変換テスト | E-17 | △ |
| C-86 | name2oid sysctl名前解決テスト | E-17 | △ |
| C-87 | oidfmt OIDフォーマット取得テスト | E-17 | △ |
| C-88 | route keywords配列定義テスト | E-18 | △ |
| C-89〜C-91 | rcorder依存関係解析テスト | E-19 | △ |
| C-92〜C-93 | activemap_copyin/merge テスト | E-08, E-09 | ○ |
| C-94 | activemap_bitmap テスト | E-08, E-09 | ○ |
| C-95〜C-98 | activemap_sync_rewind/sync_offset/need_sync/differテスト | E-08, E-09 | ○ |
| C-99〜C-100 | ext2reqs正常系/境界値テスト | E-08 | △ |

## 4) 不足情報（Unknown / Missing）
- **sysctl関連(C-85〜C-87)**：strIKtoi, name2oid, oidfmtはカーネルsysctl MIBへのアクセスが必要であり、純粋な単体テストとしての実行方法が不明確。モック化の要否を確認する必要がある。
  - 候補：sysctl MIBのモック作成 / 結合テストとしての位置づけ変更 / カーネル環境でのテスト実行
- **route keywords(C-88)**：静的配列の内容検証はコンパイル時に保証されるため、単体テストの価値が限定的。レビュアーによる妥当性判断が必要。
  - 候補：テストケース削除 / コンパイル時アサーション / 結合テストへの移行
- **rcorder依存関係解析(C-89〜C-91)**：依存関係解析ロジックがmain関数および複数のstatic関数に分散しており、単体テスト対象としての切り出し方法が不明確。
  - 候補：テスト用のラッパー関数作成 / 統合テストとしての位置づけ変更 / ATFテストによるE2Eテスト
- **ext2reqs(C-99〜C-100)**：MAXPHYSはシステム定義定数であり、テスト環境での値が不確定。
  - 候補：MAXPHYS値をテスト時にマクロ定義で上書き / 値の確認後にテスト期待値を設定

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**: sysctl関連テスト(UT-SBIN-085〜087) - カーネルsysctl APIへの依存があり、ユーザ空間での単体テスト実行に制約がある
- **リスク1（中）**: rcorder依存関係テスト(UT-SBIN-089〜091) - ロジックの分離が不十分で、テスト設計の見直しが必要な可能性がある
- **リスク1（中）**: md5 MDInputテスト(UT-SBIN-056〜060) - ファイルI/Oに依存するため、テスト用のファイル準備が必要
- **リスク0（低）**: hastd ebuf/rangelock/activemapテスト(UT-SBIN-008〜045) - 自己完結的なデータ構造であり、テスト容易性が高い
- **リスク0（低）**: in_cksumテスト(UT-SBIN-001〜007) - 既存ATFテストが存在し、テスト方法が確立されている
- **リスク0（低）**: fdisk_mbr_encテスト(UT-SBIN-046〜051) - 純粋な変換関数であり、テスト容易性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] sysctl関連テスト(UT-SBIN-085〜087)について、単体テストとして実行可能か、結合テストに移行すべきかを判断
- [ ] rcorder依存関係テスト(UT-SBIN-089〜091)の実装方針(ロジック切り出し vs E2Eテスト)を決定
- [ ] in_cksumの既存ATFテスト(E-03)と重複するテストケース(UT-SBIN-001〜003)の扱いを確認
- [ ] md5テストベクタ(UT-SBIN-052〜055)がMDTestSuiteの自己テスト機能(-xオプション)と重複しないか確認
- [ ] hastd関連テスト(UT-SBIN-008〜045, 080〜084, 092〜100)の網羅性が、hastdモジュールの重要度に見合っているか確認
- [ ] getfsopt(UT-SBIN-073〜078)のテストケースが、コメントに記載された6パターンを全て網羅しているか確認
- [ ] dos_partition_enc/decのラウンドトリップテスト(UT-SBIN-049)の実装方針を確認
