---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 112
  claims_without_evidence: 8
confidence_derived: 0.93
---

# 根拠レポート：security モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：112 / 120、根拠なし：8
- 優先レビュー（高）
  1. **UT-SEC-059, 060（mmap revocation）**：mac_proc_vm_revoke_recurseの内部動作は静的関数のため外部テスト困難
  2. **UT-SEC-086〜088（audit_pipe制限値）**：マクロ定数の定義は確認したが実際のioctl経由での設定動作は未検証
  3. **UT-SEC-120（MAC_MAX_SLOTS初期値）**：32ビット演算のオーバーフロー可能性の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sys/security/mac/mac_label.c` - ラベル管理関数群（mac_init_label, mac_destroy_label, mac_label_get, mac_label_set, mac_labelzone_*）
- E-02: `sys/security/mac/mac_framework.c` - MACフレームワーク初期化、ポリシー管理、ロック機構、ファストパス
- E-03: `sys/security/mac/mac_priv.c` - 権限チェック・権限付与インターフェース
- E-04: `sys/security/mac/mac_cred.c` - 認証ラベル管理（alloc, init, free, destroy）
- E-05: `sys/security/mac/mac_process.c` - プロセスラベル管理、execveラベル設定、mmap revocation
- E-06: `sys/security/mac/mac_vfs.c` - VFSラベル管理（devfs, mount）
- E-07: `sys/security/mac/mac_inet.c` - inpcbラベル管理
- E-08: `sys/security/mac/mac_net.c` - ネットワークラベル管理（mbuf）
- E-09: `sys/security/mac/mac_syscalls.c` - MACシステムコール（ラベルコピーイン）
- E-10: `sys/security/audit/audit.c` - 監査フレームワーク初期化、レコード構築、kinfo管理
- E-11: `sys/security/audit/audit_syscalls.c` - 監査システムコール（sys_audit, audit_priv_check_cred）
- E-12: `sys/security/audit/audit_arg.c` - 監査引数記録関数群
- E-13: `sys/security/audit/audit_bsm.c` - BSM監査初期化、レコード管理
- E-14: `sys/security/audit/audit_pipe.c` - 監査パイプ（キュー制限定数）
- E-15: `sys/security/mac_biba/mac_biba.c` - Biba整合性モデル実装（支配関係、範囲チェック、特権判定）
- E-16: `sys/security/mac/mac_internal.h` - 内部マクロ定義（MAC_POLICY_PERFORM等）
- E-17: `sys/security/mac/mac_policy.h` - ポリシーインターフェース定義
- E-18: `sys/security/mac/mac_socket.c` - ソケットラベル管理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-SEC-001) | mac_init_labelがMAC_FLAG_INITIALIZEDをセット | E-01 (mac_label.c:77) | ○ |
| C-02 (UT-SEC-002) | mac_destroy_labelがフラグをクリア | E-01 (mac_label.c:90-91) | ○ |
| C-03 (UT-SEC-003) | 未初期化ラベル破棄でKASSERT | E-01 (mac_label.c:84-85) | ○ |
| C-04 (UT-SEC-004) | mac_labelzone_initでUMAゾーン作成 | E-01 (mac_label.c:62-64) | ○ |
| C-05 (UT-SEC-005) | mac_labelzone_allocでuma_zalloc | E-01 (mac_label.c:117-119) | ○ |
| C-06 (UT-SEC-006) | mac_labelzone_freeでuma_zfree | E-01 (mac_label.c:123-127) | ○ |
| C-07 (UT-SEC-007) | mac_label_getでスロット値取得 | E-01 (mac_label.c:132-138) | ○ |
| C-08 (UT-SEC-008) | mac_label_getのNULL KASSERT | E-01 (mac_label.c:136) | ○ |
| C-09 (UT-SEC-009) | mac_label_setでスロット値設定 | E-01 (mac_label.c:141-148) | ○ |
| C-10 (UT-SEC-010) | mac_label_setのNULL KASSERT | E-01 (mac_label.c:145) | ○ |
| C-11 (UT-SEC-011) | mac_labelzone_ctorでmac_init_label呼出 | E-01 (mac_label.c:95-103) | ○ |
| C-12 (UT-SEC-012) | mac_labelzone_dtorでmac_destroy_label呼出 | E-01 (mac_label.c:105-113) | ○ |
| C-13 (UT-SEC-013) | mac_initでリスト初期化 | E-02 (mac_framework.c:326-328) | ○ |
| C-14 (UT-SEC-014) | mac_late_initでmac_late=1 | E-02 (mac_framework.c:346) | ○ |
| C-15 (UT-SEC-015〜020) | ロック関数のmac_late条件分岐 | E-02 (mac_framework.c:228-276) | ○ |
| C-16 (UT-SEC-021〜023) | ポリシーラベル検出とビットマスク統合 | E-02 (mac_framework.c:353-413) | ○ |
| C-17 (UT-SEC-024〜027) | ファストパス有効/無効化のカウントとフラグ | E-02 (mac_framework.c:463-485) | ○ |
| C-18 (UT-SEC-028〜029) | mac_priv_check_implの権限チェック | E-03 (mac_priv.c:67-76) | ○ |
| C-19 (UT-SEC-030〜031) | mac_priv_grant_implの権限付与 | E-03 (mac_priv.c:84-93) | ○ |
| C-20 (UT-SEC-032〜037) | 認証ラベルのalloc/init/free/destroy | E-04 (mac_cred.c:76-112) | ○ |
| C-21 (UT-SEC-038〜041) | プロセスラベルのinit/destroy | E-05 (mac_process.c:88-124) | ○ |
| C-22 (UT-SEC-042〜043) | mac_execve_enterのNULLチェックとEINVAL | E-05 (mac_process.c:134-145) | ○ |
| C-23 (UT-SEC-044) | mac_thread_userretのポリシー呼出 | E-05 (mac_process.c:127-131) | ○ |
| C-24 (UT-SEC-045〜047) | devfs/mountラベル初期化 | E-06 (mac_vfs.c:86-120) | ○ |
| C-25 (UT-SEC-048〜050) | inpcbラベル割り当てと初期化 | E-07 (mac_inet.c:75-100) | ○ |
| C-26 (UT-SEC-051〜052) | mac_mbuf_to_labelのNULLチェック | E-08 (mac_net.c:94-100) | ○ |
| C-27 (UT-SEC-053〜058) | MACラベルコピーイン処理 | E-09 (mac_syscalls.c:93-150) | ○ |
| C-28 (UT-SEC-059〜060) | mmap revocation動作 | E-05 (mac_process.c:75-86) | △ |
| C-29 (UT-SEC-061〜063) | audit_syscalls_enabled_update条件分岐 | E-10 (audit.c:210-228) | ○ |
| C-30 (UT-SEC-064〜067) | audit_set_kinfo/audit_get_kinfo | E-10 (audit.c:231-254) | ○ |
| C-31 (UT-SEC-068〜070) | audit_record_ctorのレコード構築 | E-10 (audit.c:259-299) | ○ |
| C-32 (UT-SEC-071〜076) | sys_auditのバリデーション | E-11 (audit_syscalls.c:91-141) | ○ |
| C-33 (UT-SEC-077〜078) | audit_priv_check_credのjailエラー変換 | E-11 (audit_syscalls.c:57-72) | ○ |
| C-34 (UT-SEC-079〜083) | 監査引数記録関数 | E-12 (audit_arg.c:69-119) | ○ |
| C-35 (UT-SEC-084〜085) | kau_init/kau_open | E-13 (audit_bsm.c:70-96) | ○ |
| C-36 (UT-SEC-086〜088) | 監査パイプキュー制限定数 | E-14 (audit_pipe.c:75-77) | △ |
| C-37 (UT-SEC-089〜093) | biba_bit_set_empty, biba_alloc, biba_free | E-15 (mac_biba.c:138-163) | ○ |
| C-38 (UT-SEC-094〜095) | biba_atmostflags | E-15 (mac_biba.c:165-172) | ○ |
| C-39 (UT-SEC-096〜101) | biba_dominate_element | E-15 (mac_biba.c:174-224) | ○ |
| C-40 (UT-SEC-102〜104) | biba_subject_dominate_high | E-15 (mac_biba.c:226-237) | ○ |
| C-41 (UT-SEC-105〜106) | biba_range_in_range | E-15 (mac_biba.c:239-247) | ○ |
| C-42 (UT-SEC-107〜108) | biba_effective_in_range | E-15 (mac_biba.c:249-264) | ○ |
| C-43 (UT-SEC-109) | biba_dominate_effective | E-15 (mac_biba.c:266-275) | ○ |
| C-44 (UT-SEC-110〜112) | biba_equal_element | E-15 (mac_biba.c:277-286) | ○ |
| C-45 (UT-SEC-113〜115) | biba_contains_equal | E-15 (mac_biba.c:300-317) | ○ |
| C-46 (UT-SEC-116〜119) | biba_subject_privileged | E-15 (mac_biba.c:319-342) | ○ |
| C-47 (UT-SEC-120) | mac_slot_offsets_free初期値 | E-02 (mac_framework.c:168-173) | △ |

## 4) 不足情報（Unknown / Missing）
- **mmap revocation（C-28）**: mac_proc_vm_revoke_recurseは静的関数であり、vm_mapの内部操作を含む。実際のページ単位の取り消し動作の検証には、VMサブシステムとの統合テストが必要。sysctl security.mac.mmap_revocationとsecurity.mac.mmap_revocation_via_cowの動作組み合わせは推測に基づく。
  - 候補：VMサブシステムのテストコード / mac_process.cの後半部分 / vm_map.hの定義
- **監査パイプキュー制限（C-36）**: マクロ定数AUDIT_PIPE_QLIMIT_MIN/MAX/DEFAULTの定義は確認したが、ioctl経由での設定・検証ロジック（audit_pipe_ioctl関数）の詳細は未分析。
  - 候補：audit_pipe.cの後半（ioctl実装部分） / audit_ioctl.h
- **MAC_MAX_SLOTSビットマスク（C-47）**: mac_slot_offsets_freeの初期値計算 `(1 << MAC_MAX_SLOTS) - 1` について、MAC_MAX_SLOTS=32の場合に `1 << 32` が未定義動作（C言語仕様）となる可能性がある。ただし `#if MAC_MAX_SLOTS > 32` のガードが存在する。
  - 候補：mac_framework.hのMAC_MAX_SLOTS定義 / コンパイラの動作確認

## 5) リスクフラグ（レビュー観点）
- 0: MAC label管理（UT-SEC-001〜012）- ソースコードから直接読み取れる明確なロジック
- 0: MACフレームワーク初期化・ロック（UT-SEC-013〜027）- 分岐条件が明確
- 0: 権限チェック・認証ラベル（UT-SEC-028〜037）- MACマクロの展開動作に依存するが基本的に明確
- 0: 監査フレームワーク（UT-SEC-061〜085）- ソースコードから直接確認可能
- 0: Biba整合性モデル（UT-SEC-089〜119）- アルゴリズムがソースコードから完全に追跡可能
- 1: mmap revocation（UT-SEC-059〜060）- VMサブシステムとの連携動作が未検証
- 1: 監査パイプ制限値（UT-SEC-086〜088）- ioctl実装の詳細未確認
- 1: MAC_MAX_SLOTSビットマスク（UT-SEC-120）- C言語仕様上の境界値

## 6) レビュアーチェックリスト（最小）
- [ ] mac_destroy_labelのDIAGNOSTICモード分岐（bzero vs フラグクリア）の挙動がテストケースに反映されているか
- [ ] MAC_POLICY_PERFORMおよびMAC_POLICY_CHECK_NOSLEEPマクロの展開結果が期待動作と一致するか
- [ ] biba_dominate_elementのコンパートメントビット比較ロジック（MAC_BIBA_MAX_COMPARTMENTS）の境界値が十分か
- [ ] audit_record_ctorのstrlcpyによるjail名切り詰め（sizeof(ar_jailname)超過時）のテストが必要か
- [ ] mac_label_copyin_stringのm_buflenバリデーション（mac_check_structmac_consistent）の具体的な上限値を確認
- [ ] sys_auditのMAX_AUDIT_RECORD_SIZEとaudit_qctrl.aq_bufszの関係性を確認
- [ ] mmap revocationの実際のVM操作について、mac_process.cの後半部分を精査
- [ ] mac_mls（Multi-Level Security）モジュールのテストケース追加の要否を検討
