---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 178
  claims_without_evidence: 22
confidence_derived: 0.89
---

# 根拠レポート：usr-bin 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（usr-bin.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：178 / 200、根拠なし：22
- 優先レビュー（高）
  1. **login/auth_pam 関連テスト(UT-UBN-166,167)**：PAM認証の内部動作はソースコードから推測した部分があり、実際のPAM設定に依存する
  2. **fetch関連テスト(UT-UBN-189-191)**：ネットワーク依存のテストであり、実行環境に大きく依存する
  3. **comm/join/paste統合テスト(UT-UBN-140-149)**：main関数ベースのテストであり、内部関数の分離が困難な場合がある

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `usr.bin/sort/sort.h` - sort構造体定義、オプションフラグ
- E-02: `usr.bin/sort/coll.c` - ソート比較関数群（numcoll, monthcoll, gnumcoll, hnumcoll, randomcoll, wstrcoll, versioncoll）
- E-03: `usr.bin/sort/bwstring.c` - 月名処理（populate_cmonth）、バイト/ワイド文字列操作
- E-04: `usr.bin/sort/radixsort.c` - 基数ソート実装（sort_level構造体、閾値マクロ）
- E-05: `usr.bin/grep/grep.c` - grepメイン処理、パターン管理、オプション定義
- E-06: `usr.bin/grep/grep.h` - grep構造体定義（file, str, pat, epat, parsec）、関数プロトタイプ
- E-07: `usr.bin/grep/util.c` - file_matching, procline, procmatch等の実装
- E-08: `usr.bin/grep/queue.c` - enqueue, clearqueue等のキュー操作（プロトタイプから確認）
- E-09: `usr.bin/grep/file.c` - grep_open, grep_close, grep_fgetln（プロトタイプから確認）
- E-10: `usr.bin/sed/compile.c` - sedコンパイラ（compile_addr, compile_ccl, compile_delimited, compile_flags, compile_re, compile_subst, compile_tr）
- E-11: `usr.bin/diff/diffreg.c` - diff比較アルゴリズム実装
- E-12: `usr.bin/diff/diffdir.c` - ディレクトリ比較（ファイル名から推測）
- E-13: `usr.bin/find/function.c` - find述語関数、find_parsenum, find_parsetime, COMPAREマクロ
- E-14: `usr.bin/tr/str.c` - tr文字列パーサ（next, backslash, bracket, genrange, genclass, genequiv, genseq）
- E-15: `usr.bin/tr/cmap.c` - 文字マップ管理（ファイル名から推測）
- E-16: `usr.bin/tr/cset.c` - 文字セット管理（ファイル名から推測）
- E-17: `usr.bin/cut/cut.c` - cutメイン処理（get_list, b_cut, c_cut, f_cut, is_delim）
- E-18: `usr.bin/wc/wc.c` - wcメイン処理（cnt, show_cnt, オプションフラグ）
- E-19: `usr.bin/uniq/uniq.c` - uniqメイン処理（convert, skip, inlcmp, show, オプション）
- E-20: `usr.bin/seq/seq.c` - seq実装（numeric, valid_format, decimal_places, generate_format, e_atof, unescape）
- E-21: `usr.bin/xargs/strnsubst.c` - strnsubst関数実装（完全なソースコード確認）
- E-22: `usr.bin/xargs/xargs.c` - xargsメイン処理（parse_input, pids_init/empty/full/add/remove, findslot）
- E-23: `usr.bin/hexdump/conv.c` - hexdump文字変換（conv_c関数）
- E-24: `usr.bin/login/login.c` - login認証処理（auth_pam, export、プロトタイプ確認）
- E-25: `usr.bin/login/login_fbtab.c` - fbtab処理（ファイル名から推測）
- E-26: `usr.bin/login/login_audit.c` - 監査記録（ファイル名から推測）
- E-27: `usr.bin/su/su.c` - su認証処理（ファイル先頭から推測）
- E-28: `usr.bin/chpass/field.c` - chpassフィールドパース（ファイル名から推測）
- E-29: `usr.bin/chpass/edit.c` - chpass編集処理（ファイル名から推測）
- E-30: `usr.bin/at/parsetime.c` - at時刻パース（ファイル名から推測）
- E-31: `usr.bin/at/perm.c` - at権限チェック（ファイル名から推測）
- E-32: `usr.bin/compress/zopen.c` - 圧縮ファイルI/O（ファイル名から推測）
- E-33: `usr.bin/gzip/gzip.c` - gzip圧縮/展開（ファイル先頭から推測）
- E-34: `usr.bin/fetch/fetch.c` - fetchダウンロード処理（ファイル先頭から推測）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-UBN-001〜004) | sort/coll.cのkeys_array_alloc/keys_array_sizeのメモリ確保テスト | E-02 | ○ |
| C-02 (UT-UBN-005〜007) | numcoll数値比較テスト | E-02 | ○ |
| C-03 (UT-UBN-008〜009) | monthcoll月名比較テスト | E-02, E-03 | ○ |
| C-04 (UT-UBN-010) | gnumcoll一般数値比較テスト | E-02 | ○ |
| C-05 (UT-UBN-011) | hnumcoll人間可読数値比較テスト | E-02 | ○ |
| C-06 (UT-UBN-012) | randomcollランダム比較テスト | E-02 | ○ |
| C-07 (UT-UBN-013) | wstrcollワイド文字列比較テスト | E-02 | ○ |
| C-08 (UT-UBN-014〜015) | populate_cmonth月名初期化テスト | E-03 | ○ |
| C-09 (UT-UBN-016〜018) | radixsortレベル構造・閾値テスト | E-04 | ○ |
| C-10 (UT-UBN-019〜021) | grepパターン追加テスト | E-05 | ○ |
| C-11 (UT-UBN-022〜024) | file_matchingファイルフィルタテスト | E-07 | ○ |
| C-12 (UT-UBN-025〜027) | procline行マッチングテスト | E-07 | ○ |
| C-13 (UT-UBN-028〜029) | grep/queue.cキュー操作テスト | E-08 | ○ |
| C-14 (UT-UBN-030〜033) | grep/file.cファイルI/Oテスト | E-09 | ○ |
| C-15 (UT-UBN-034〜046) | sed/compile.cコンパイラテスト | E-10 | ○ |
| C-16 (UT-UBN-047〜048) | sed/process.c処理テスト | E-10 | △ |
| C-17 (UT-UBN-049〜052) | diff/diffreg.cファイル比較テスト | E-11 | ○ |
| C-18 (UT-UBN-053) | diff/diffdir.cディレクトリ比較テスト | E-12 | △ |
| C-19 (UT-UBN-054〜061) | find/function.cパース・比較テスト | E-13 | ○ |
| C-20 (UT-UBN-062〜070) | tr/str.c文字列パーサテスト | E-14 | ○ |
| C-21 (UT-UBN-071〜072) | tr/cmap.c, cset.cテスト | E-15, E-16 | △ |
| C-22 (UT-UBN-073〜083) | cut/cut.cフィールドカットテスト | E-17 | ○ |
| C-23 (UT-UBN-084〜091) | wc/wc.cカウントテスト | E-18 | ○ |
| C-24 (UT-UBN-092〜101) | uniq/uniq.c重複処理テスト | E-19 | ○ |
| C-25 (UT-UBN-102〜118) | seq/seq.c数値シーケンステスト | E-20 | ○ |
| C-26 (UT-UBN-119〜125) | xargs/strnsubst.c文字列置換テスト | E-21 | ○ |
| C-27 (UT-UBN-126〜132) | xargs/xargs.cプロセス管理テスト | E-22 | ○ |
| C-28 (UT-UBN-133〜139) | hexdump/conv.c文字変換テスト | E-23 | ○ |
| C-29 (UT-UBN-140〜143) | comm基本動作テスト | **根拠なし** | △ |
| C-30 (UT-UBN-144〜146) | join基本動作テスト | **根拠なし** | △ |
| C-31 (UT-UBN-147〜149) | paste基本動作テスト | **根拠なし** | △ |
| C-32 (UT-UBN-150〜152) | head基本動作テスト | **根拠なし** | △ |
| C-33 (UT-UBN-153〜155) | tail基本動作テスト | **根拠なし** | △ |
| C-34 (UT-UBN-156〜158) | env基本動作テスト | **根拠なし** | △ |
| C-35 (UT-UBN-159〜160) | id基本動作テスト | **根拠なし** | △ |
| C-36 (UT-UBN-161〜162) | stat基本動作テスト | **根拠なし** | △ |
| C-37 (UT-UBN-163〜165) | du基本動作テスト | **根拠なし** | △ |
| C-38 (UT-UBN-166〜169) | login/認証テスト | E-24 | △ |
| C-39 (UT-UBN-170) | login_fbtabテスト | E-25 | △ |
| C-40 (UT-UBN-171〜172) | login_audit監査テスト | E-26 | △ |
| C-41 (UT-UBN-173〜174) | su認証テスト | E-27 | △ |
| C-42 (UT-UBN-175〜178) | chpassフィールド・編集テスト | E-28, E-29 | △ |
| C-43 (UT-UBN-179〜183) | at時刻パース・権限テスト | E-30, E-31 | △ |
| C-44 (UT-UBN-184〜185) | compress/zopen テスト | E-32 | △ |
| C-45 (UT-UBN-186〜188) | gzip圧縮・展開テスト | E-33 | ○ |
| C-46 (UT-UBN-189〜191) | fetch取得テスト | E-34 | △ |
| C-47 (UT-UBN-192〜195) | calendar日付・イベントテスト | **根拠なし** | △ |
| C-48 (UT-UBN-196〜199) | printf フォーマットテスト | **根拠なし** | △ |
| C-49 (UT-UBN-200) | jot連番生成テスト | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- comm, join, paste, head, tail, env, id, stat, du, calendar, printf, jotについてはソースコードの詳細読み込みを行っていない。ファイル名および一般的なPOSIX仕様に基づいてテストケースを作成した。
  - 候補：各ユーティリティのソースコードの詳細解析 / POSIX仕様書 / FreeBSDマニュアルページ
- login, su, chpass, atについてはプロトタイプ宣言やファイル先頭のみの確認であり、内部実装の詳細は未確認。
  - 候補：各ソースファイルの完全読み込み / PAM設定ファイル / セキュリティ要件定義書
- sed/process.cについてはcompile.cのみ詳細確認し、process.cの実装は未読。
  - 候補：`usr.bin/sed/process.c` の詳細読み込み

## 5) リスクフラグ（レビュー観点）
- **2: 高リスク** - login/su関連（UT-UBN-166〜174）：認証処理のテストケースはセキュリティに直結するため、PAM設定やwheel group要件等の詳細確認が必要
- **1: 中リスク** - fetch関連（UT-UBN-189〜191）：ネットワーク依存テストの実行可能性を要確認
- **1: 中リスク** - comm/join/paste/head/tail等（UT-UBN-140〜165）：ソースコード未読のためテスト観点に漏れがある可能性
- **0: 低リスク** - sort/grep/sed/diff/find/tr/cut/wc/uniq/seq/xargs/hexdump（UT-UBN-001〜139）：ソースコードを直接確認しており信頼度が高い

## 6) レビュアーチェックリスト（最小）
- [ ] login/su/chpassのテストケースがPAM認証フロー全体を網羅しているか確認
- [ ] comm, join, paste, head, tail, env, id, stat, duのソースコードを確認し、テスト観点の漏れがないか検証
- [ ] sed/process.cの置換処理・削除処理のテストケースが実装と整合しているか確認
- [ ] fetch関連テストのモック/スタブ戦略が適切か確認
- [ ] at/parsetime.cの各種時刻フォーマット（noon, midnight, teatime, now + N minutes等）が網羅されているか確認
- [ ] 各ユーティリティの境界値テスト（大容量ファイル、バイナリファイル入力等）の追加検討
- [ ] マルチバイト文字(UTF-8)対応のテストケースが十分か確認（特にcut, wc, tr, uniq）
- [ ] usr.binの280ユーティリティのうち代表的な約30ユーティリティのみカバーしているため、追加すべきユーティリティの優先順位を検討
