---
generated_at: 2026-02-01 00:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **UAT-032 bhyve仮想マシン操作**：bhyveのコマンドライン引数はバージョンにより変動する可能性がある
  2. **UAT-042 freebsd-update**：freebsd-updateはシェルスクリプトであり、ソースツリー外の動作に依存
  3. **UAT-033 ワールドビルド**：ビルド手順の正確性はMakefile構成に依存し、環境差異の影響を受ける

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `usr.sbin/bsdinstall/scripts/` - インストーラスクリプト群（adduser, auto, bootconfig, config, docsinstall, entropy, hardening, hostname, keymap, mirrorselect, mount, netconfig, rootpass, time, wlanconfig, zfsboot）
- E-02: `usr.sbin/pw/` - ユーザー・グループ管理コマンドソース（pw.c, pw_user.c, pw_group.c等）
- E-03: `usr.sbin/bsdconfig/usermgmt/` - bsdconfig対話的ユーザー管理
- E-04: `sbin/ifconfig/` - ネットワークインタフェース設定（ifconfig.c, af_inet.c, af_inet6.c, ifbridge.c, carp.c等）
- E-05: `sbin/ipfw/` - ipfwファイアウォール
- E-06: `sbin/pfctl/` - pfファイアウォール制御（ソースツリーにpfctl存在を確認）
- E-07: `usr.sbin/pkg/` - パッケージ管理コマンド（pkg.c, config.c等）
- E-08: `sbin/newfs/`, `sbin/mount/`, `sbin/fsck_ffs/` - UFSファイルシステム操作
- E-09: `sbin/zfs/`, `sbin/zpool/`（cddl配下） - ZFSプール・データセット管理
- E-10: `usr.sbin/jail/` - Jail管理（jail.c, command.c, config.c, state.c）
- E-11: `stand/` - ブートローダソース
- E-12: `sbin/kldload/`, `sbin/kldunload/`, `sbin/kldstat/` - カーネルモジュール管理
- E-13: `usr.sbin/bsdconfig/timezone/`, `bsdinstall/scripts/time` - タイムゾーン設定
- E-14: `usr.sbin/bsdconfig/` - bsdconfig TUI設定ツール（console, diskmgmt, mouse, networking, password, security, startup, timezone, usermgmt）
- E-15: `bsdinstall/scripts/hardening`, `usr.sbin/bsdconfig/security/` - セキュリティハードニング
- E-16: `usr.sbin/auditd/`, `usr.sbin/auditreduce/` - 監査デーモンと監査ログ解析
- E-17: `bin/ps`, `bin/pkill` - プロセス管理コマンド
- E-18: `bin/ls`, `bin/cp`, `bin/mv`, `bin/rm`, `bin/mkdir`, `bin/chmod` - 基本ファイル操作コマンド
- E-19: `bin/setfacl`, `bin/getfacl` - ACL制御コマンド
- E-20: `bin/sh/` - Bourneシェル
- E-21: `sbin/geom/` - GEOMフレームワーク（ディスク管理）
- E-22: `libexec/rc/` - rcスクリプトフレームワーク
- E-23: `sbin/ping/` - ネットワーク診断
- E-24: `secure/usr.sbin/sshd/`, `secure/usr.bin/ssh/` - SSH関連
- E-25: `sbin/bectl/` - ブート環境管理
- E-26: `tests/` - Kyuaテストスイート
- E-27: `usr.sbin/bhyve/`, `usr.sbin/bhyvectl/`, `usr.sbin/bhyveload/` - bhyve仮想化
- E-28: `Makefile`, `Makefile.inc1` - ビルドシステム
- E-29: `sbin/dmesg/` - カーネルメッセージ表示
- E-30: `sbin/dump/`, `sbin/restore/` - バックアップ・リストア
- E-31: `sys/fs/nfs*` - NFSファイルシステム
- E-32: `sbin/sysctl/` - カーネルパラメータ制御
- E-33: `bin/freebsd-version` - バージョン確認コマンド
- E-34: `sys/kern/` - カーネルコアソース（プロセス管理、ファイルシステム等の基盤）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001: 基本インストールの実施 | E-01 | ○ |
| C-02 | UAT-002: ZFSブートパーティションでのインストール | E-01, E-09 | ○ |
| C-03 | UAT-003: ユーザーの追加・変更・削除 | E-02 | ○ |
| C-04 | UAT-004: グループの追加・変更・削除 | E-02 | ○ |
| C-05 | UAT-005: 対話的ユーザー管理 | E-03 | ○ |
| C-06 | UAT-006: ネットワークインタフェースのIPアドレス設定 | E-04 | ○ |
| C-07 | UAT-007: インストール時のネットワーク設定 | E-01 | ○ |
| C-08 | UAT-008: 無線LAN接続の設定 | E-01, E-04 | ○ |
| C-09 | UAT-009: ipfwによるパケットフィルタリング | E-05 | ○ |
| C-10 | UAT-010: pfによるパケットフィルタリング | E-06 | ○ |
| C-11 | UAT-011: パッケージのインストール・更新・削除 | E-07 | ○ |
| C-12 | UAT-012: パッケージリポジトリの設定と検索 | E-07 | ○ |
| C-13 | UAT-013: UFS2ファイルシステムの作成とマウント | E-08 | ○ |
| C-14 | UAT-014: ZFSプール・データセットの管理 | E-09 | ○ |
| C-15 | UAT-015: Jailの作成・起動・停止 | E-10 | ○ |
| C-16 | UAT-016: Jailのネットワーク設定 | E-10 | ○ |
| C-17 | UAT-017: ブートローダからの起動オプション選択 | E-11 | ○ |
| C-18 | UAT-018: カーネルモジュールのロード・アンロード | E-12 | ○ |
| C-19 | UAT-019: タイムゾーン・ロケールの設定 | E-13 | ○ |
| C-20 | UAT-020: bsdconfigによるシステム設定 | E-14 | ○ |
| C-21 | UAT-021: セキュリティハードニングの適用 | E-15 | ○ |
| C-22 | UAT-022: 監査の設定と確認 | E-16 | ○ |
| C-23 | UAT-023: プロセスの確認と管理 | E-17 | ○ |
| C-24 | UAT-024: 基本的なファイル操作 | E-18 | ○ |
| C-25 | UAT-025: ACLの設定 | E-19 | ○ |
| C-26 | UAT-026: shシェルの基本操作 | E-20 | ○ |
| C-27 | UAT-027: GEOMフレームワークによるディスク管理 | E-21 | ○ |
| C-28 | UAT-028: GEOMミラーの構成 | E-21 | ○ |
| C-29 | UAT-029: rcスクリプトによるサービス管理 | E-22 | ○ |
| C-30 | UAT-030: ネットワーク診断ツールの利用 | E-23 | ○ |
| C-31 | UAT-031: ディスク暗号化（GELI） | E-21 | ○ |
| C-32 | UAT-032: bhyveによる仮想マシンの作成と起動 | E-27 | ○ |
| C-33 | UAT-033: ワールドビルド（make buildworld） | E-28 | ○ |
| C-34 | UAT-034: カーネルビルド（make buildkernel） | E-28, E-34 | ○ |
| C-35 | UAT-035: システムログの確認と管理 | E-29 | ○ |
| C-36 | UAT-036: suおよびsudoによる権限昇格 | E-18 | ○ |
| C-37 | UAT-037: VLANインタフェースの設定 | E-04 | ○ |
| C-38 | UAT-038: NFSの設定とマウント | E-31 | ○ |
| C-39 | UAT-039: sysctlによるカーネルパラメータの変更 | E-32 | ○ |
| C-40 | UAT-040: dump/restoreによるバックアップとリストア | E-30 | ○ |
| C-41 | UAT-041: ZFSスナップショットによるバックアップ | E-09 | ○ |
| C-42 | UAT-042: freebsd-updateによるシステム更新 | **根拠不足** | △ |
| C-43 | UAT-043: SSH接続 | E-24 | ○ |
| C-44 | UAT-044: ブート環境の管理（bectl） | E-25 | ○ |
| C-45 | UAT-045: Kyuaテストスイートの実行 | E-26 | ○ |

## 4) 不足情報（Unknown / Missing）
- **freebsd-update（C-42）**：freebsd-updateはシェルスクリプトとしてusr.sbin/freebsd-updateに存在するが、実際の更新サーバーとの通信やバイナリパッチの適用ロジックはソースツリー内のコードだけでは完全に検証できない。テスト手順はFreeBSDハンドブックに基づく一般的な手順であり、バージョン固有の差異がある可能性がある。
  - 候補：FreeBSD Handbook / freebsd-update(8)マニュアル / リリースノート
- **sudoコマンド（C-36内）**：sudoはFreeBSD基本システムには含まれず、pkg経由でインストールするサードパーティソフトウェアである。テストケース内でsudoに言及しているが、ソースツリーには含まれない。
  - 候補：security/sudoポート / pkg install sudo
- **bhyveコマンドライン引数（C-32）**：bhyveのオプション体系はバージョンにより変化する可能性があり、記載した手順が最新のインタフェースと一致するかは要確認。
  - 候補：usr.sbin/bhyve/bhyve.8マニュアル / FreeBSD Wiki bhyve

## 5) リスクフラグ（レビュー観点）
- **リスク1（中リスク）**：UAT-042のfreebsd-updateテスト手順は実際のネットワーク接続とFreeBSDアップデートサーバーの可用性に依存する。テスト環境でのネットワーク断絶や旧バージョンの更新終了により、テストが実施不能になる可能性がある。
- **リスク1（中リスク）**：UAT-036でsudoに言及しているが、sudoは基本システムに含まれないため、別途インストールが必要。テスト前提条件の見直しが必要。
- **リスク0（低リスク）**：UAT-032のbhyve手順はハードウェア仮想化支援（Intel VT-x/AMD-V）が必要であり、テスト環境の制約を受ける。
- **リスク0（低リスク）**：テストケースの多くはCLI操作であり、UIの見た目に関する検証は限定的。bsdinstallやbsdconfigのTUI画面の表示崩れなどは本テストケースではカバーされない。

## 6) レビュアーチェックリスト（最小）
- [ ] 全テストケースのユーザーロール（root/一般ユーザー）が適切に設定されているか
- [ ] テスト手順の各ステップが実際のFreeBSDコマンドとして正しく実行可能か
- [ ] 前提条件が現実的で、テスト環境で再現可能か
- [ ] 期待結果が具体的かつ検証可能な記述になっているか
- [ ] sudoに関するテストケース（UAT-036）の前提条件にpkgインストールが含まれているか確認
- [ ] bhyve関連テスト（UAT-032）のハードウェア要件が明記されているか確認
- [ ] 優先度の高いテストケースが主要機能（インストール、ユーザー管理、ネットワーク、ファイルシステム、セキュリティ）をカバーしているか
- [ ] ZFS関連テスト（UAT-002, UAT-014, UAT-041, UAT-044）の整合性を確認
