---
generated_at: 2026-02-01 00:00:00
metrics:
  claims_total: 38
  claims_with_evidence: 38
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された帳票一覧.csvの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：38 / 38、根拠なし：0
- 優先レビュー（高）
  1. **帳票の定義範囲**：FreeBSD-srcはOSソースコードであり業務アプリケーションではないため、「帳票」の定義をレポート/統計出力コマンドとして解釈している。この解釈の妥当性は要確認。
  2. **網羅性**：追加のレポート生成コマンドが存在する可能性がある（contrib/配下やcddl/配下のツール等）
  3. **カテゴリ分類**：カテゴリの分類基準が厳密に定義されていないため、分類の妥当性は要確認。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `usr.sbin/ac/ac.8` - acコマンドのマニュアルページ（.Nd connect time accounting）
- E-02: `usr.sbin/sa/sa.8` - saコマンドのマニュアルページ（.Nd print system accounting statistics）
- E-03: `usr.sbin/iostat/iostat.8` - iostatコマンドのマニュアルページ（.Nd report I/O statistics）
- E-04: `usr.bin/vmstat/` - vmstatコマンドのソースディレクトリ（.Nd report virtual memory statistics）
- E-05: `usr.bin/netstat/` - netstatコマンドのソースディレクトリ（.Nd show network status and statistics）
- E-06: `usr.sbin/pstat/` - pstatコマンドのソースディレクトリ（.Nd display system data structures）
- E-07: `usr.sbin/gstat/` - gstatコマンドのソースディレクトリ（.Nd print statistics about GEOM disks）
- E-08: `usr.sbin/pmcstat/` - pmcstatコマンドのソースディレクトリ（.Nd performance measurement with performance monitoring hardware）
- E-09: `usr.bin/systat/` - systatコマンドのソースディレクトリ（.Nd display system statistics）
- E-10: `usr.sbin/lastlogin/` - lastloginコマンドのソースディレクトリ（.Nd indicate last login time of users）
- E-11: `usr.bin/lastcomm/` - lastcommコマンドのソースディレクトリ（.Nd show last commands executed）
- E-12: `usr.sbin/repquota/` - repquotaコマンドのソースディレクトリ（.Nd summarize quotas for a file system）
- E-13: `usr.sbin/quot/` - quotコマンドのソースディレクトリ（.Nd display disk space occupied by each user）
- E-14: `usr.bin/top/` - topコマンドのソースディレクトリ（.Nd display and update information about the top cpu processes）
- E-15: `usr.sbin/crashinfo/` - crashinfoコマンドのソースディレクトリ（.Nd analyze a core dump of the operating system）
- E-16: `usr.sbin/praudit/` - prauditコマンドのソースディレクトリ
- E-17: `usr.sbin/mailstats/` - mailstatsコマンドのソースディレクトリ
- E-18: `usr.bin/nfsstat/nfsstat.1` - nfsstatコマンドのマニュアルページ（.Nd display NFS statistics）
- E-19: `usr.bin/ctlstat/` - ctlstatコマンドのソースディレクトリ（.Nd CAM Target Layer statistics utility）
- E-20: `usr.bin/ministat/` - ministatコマンドのソースディレクトリ（.Nd statistics utility）
- E-21: `usr.bin/fstat/` - fstatコマンドのソースディレクトリ
- E-22: `usr.bin/procstat/` - procstatコマンドのソースディレクトリ（.Nd get detailed process information）
- E-23: `usr.bin/sockstat/` - sockstatコマンドのソースディレクトリ（.Nd list open sockets）
- E-24: `usr.bin/lsvfs/` - lsvfsコマンドのソースディレクトリ（.Nd list installed virtual file systems）
- E-25: `usr.bin/du/` - duコマンドのソースディレクトリ（.Nd display disk usage statistics）
- E-26: `usr.bin/ipcs/` - ipcsコマンドのソースディレクトリ（.Nd report System V interprocess communication facilities status）
- E-27: `usr.sbin/ifmcstat/` - ifmcstatコマンドのソースディレクトリ（.Nd dump multicast group management statistics per interface）
- E-28: `usr.sbin/wlanstat/` - wlanstatコマンドのソースディレクトリ
- E-29: `usr.sbin/prometheus_sysctl_exporter/` - prometheus_sysctl_exporterコマンドのソースディレクトリ（.Nd print kernel state as Prometheus metrics）
- E-30: `usr.bin/last/` - lastコマンドのソースディレクトリ
- E-31: `usr.bin/rpcinfo/` - rpcinfoコマンドのソースディレクトリ（.Nd report RPC information）
- E-32: `usr.bin/stat/` - statコマンドのソースディレクトリ（.Nd display file status）
- E-33: `usr.bin/w/` - wコマンドのソースディレクトリ（.Nd display who is logged in and what they are doing）
- E-34: `usr.bin/ruptime/` - ruptimeコマンドのソースディレクトリ（.Nd show host status of local machines）
- E-35: `usr.sbin/usbdump/` - usbdumpコマンドのソースディレクトリ（.Nd dump traffic on USB host controller）
- E-36: `usr.sbin/efitable/` - efitableコマンドのソースディレクトリ（.Nd dump UEFI tables）
- E-37: `sbin/dumpfs/` - dumpfsコマンドのソースディレクトリ（.Nd dump UFS file system information）
- E-38: `sbin/ffsinfo/` - ffsinfoコマンドのソースディレクトリ（.Nd dump all meta information of an existing ufs file system）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ac: 接続時間アカウンティングレポート | E-01 | ○ |
| C-02 | sa: システムアカウンティング統計レポート | E-02 | ○ |
| C-03 | iostat: I/O統計レポート | E-03 | ○ |
| C-04 | vmstat: 仮想メモリ統計レポート | E-04 | ○ |
| C-05 | netstat: ネットワークステータス・統計レポート | E-05 | ○ |
| C-06 | pstat: システムデータ構造表示レポート | E-06 | ○ |
| C-07 | gstat: GEOMディスク統計レポート | E-07 | ○ |
| C-08 | pmcstat: ハードウェアパフォーマンス監視レポート | E-08 | ○ |
| C-09 | systat: システム統計表示レポート | E-09 | ○ |
| C-10 | lastlogin: 最終ログインレポート | E-10 | ○ |
| C-11 | lastcomm: 最終実行コマンドレポート | E-11 | ○ |
| C-12 | repquota: ファイルシステムクォータ要約レポート | E-12 | ○ |
| C-13 | quot: ディスク使用量ユーザー別レポート | E-13 | ○ |
| C-14 | top: CPU使用率上位プロセスレポート | E-14 | ○ |
| C-15 | crashinfo: OSコアダンプ解析レポート | E-15 | ○ |
| C-16 | praudit: 監査証跡レポート | E-16 | ○ |
| C-17 | mailstats: メール統計レポート | E-17 | ○ |
| C-18 | nfsstat: NFS統計レポート | E-18 | ○ |
| C-19 | ctlstat: CAMターゲット層統計レポート | E-19 | ○ |
| C-20 | ministat: 統計解析ユーティリティレポート | E-20 | ○ |
| C-21 | fstat: オープンファイルレポート | E-21 | ○ |
| C-22 | procstat: プロセス詳細情報レポート | E-22 | ○ |
| C-23 | sockstat: オープンソケットレポート | E-23 | ○ |
| C-24 | lsvfs: 仮想ファイルシステム一覧レポート | E-24 | ○ |
| C-25 | du: ディスク使用量統計レポート | E-25 | ○ |
| C-26 | ipcs: System V IPC施設ステータスレポート | E-26 | ○ |
| C-27 | ifmcstat: マルチキャスト統計レポート | E-27 | ○ |
| C-28 | wlanstat: 802.11無線ネットワーク統計レポート | E-28 | ○ |
| C-29 | prometheus_sysctl_exporter: Prometheusメトリクスレポート | E-29 | ○ |
| C-30 | last: ユーザーログイン履歴レポート | E-30 | ○ |
| C-31 | rpcinfo: RPC情報レポート | E-31 | ○ |
| C-32 | stat: ファイルステータスレポート | E-32 | ○ |
| C-33 | w: ログインユーザー・実行内容レポート | E-33 | ○ |
| C-34 | ruptime: ローカルマシンホスト稼働状態レポート | E-34 | ○ |
| C-35 | usbdump: USBトラフィックダンプレポート | E-35 | ○ |
| C-36 | efitable: UEFIテーブルダンプレポート | E-36 | ○ |
| C-37 | dumpfs: UFSファイルシステム情報レポート | E-37 | ○ |
| C-38 | ffsinfo: UFSファイルシステムメタ情報レポート | E-38 | ○ |

## 4) 不足情報（Unknown / Missing）
- 本プロジェクト（FreeBSD-src）はオペレーティングシステムのソースコードであり、業務アプリケーションではないため、「帳票」の概念を「レポート/統計情報を出力するコマンド」として解釈した。この解釈が要件と合致しているか確認が必要。
  - 候補：業務アプリケーション的な帳票定義 / PDF/CSV生成機能 / 印刷用フォーマット出力
- contrib/配下のサードパーティツール（dtrace等）にもレポート生成機能が存在する可能性があるが、本一覧ではFreeBSD固有のコマンドに限定した。
  - 候補：cddl/contrib/opensolaris/cmd/dtrace / contrib/配下のツール

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 「帳票」の定義がOSソースコードのコンテキストでは曖昧であり、レポート/統計出力コマンドとして解釈しているが、要件との齟齬が生じる可能性がある。
- 0: 低リスク - 各コマンドの説明はマニュアルページ（.Ndディレクティブ）およびソースコードに基づいており、記述内容の正確性は高い。
- 1: 中リスク - contrib/やcddl/配下のサードパーティツールを含めていないため、網羅性に改善の余地がある。

## 6) レビュアーチェックリスト（最小）
- [ ] 「帳票」の定義をレポート/統計出力コマンドとして解釈していることが妥当か確認する
- [ ] 各コマンドの説明がマニュアルページの記述と一致しているか抽出確認する
- [ ] カテゴリの分類が適切か確認する
- [ ] contrib/やcddl/配下のサードパーティ製レポートツールを含める必要があるか確認する
- [ ] 出力形式（CSV列構成）が要件に合致しているか確認する
