# 帳票設計書 16-praudit - 監査証跡レポート

## 概要

本ドキュメントは、FreeBSD の `praudit` コマンドが出力する監査証跡レポートの設計仕様を記述する。

### 本帳票の処理概要

praudit は、BSM（Basic Security Module）監査証跡レコードを人間が読める形式のレポートとして出力するユーティリティである。バイナリ形式の監査トレイルファイルをパースし、各監査トークンをフォーマット済みテキストとして表示する。

**業務上の目的・背景**：FreeBSDのBSM監査フレームワークで記録されたセキュリティ監査イベントを可読形式で表示するために使用される。セキュリティ監査の実施、コンプライアンス要件の充足、不正アクセスの検出と分析などの課題を解決する。

**帳票の利用シーン**：セキュリティ監査ログの確認、インシデント対応時の操作履歴分析、コンプライアンス監査報告書の作成、監査ポリシーの検証などの場面で利用される。

**主要な出力内容**：
1. 監査レコードヘッダー（イベントタイプ、時刻、レコード長）
2. 監査トークン（主体、対象、引数、戻り値、パス等）
3. 各トークンの属性値（UID、GID、PID、アドレス、パーミッション等）

**帳票の出力タイミング**：管理者がコマンドラインから `praudit` コマンドを実行した際に標準出力に出力される。パイプ経由でリアルタイム表示も可能（tail -f | praudit -p）。

**帳票の利用者**：セキュリティ管理者、監査担当者、コンプライアンス担当者

## 帳票種別

一覧表（監査証跡レコード一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | コマンドラインインターフェース | N/A | `praudit` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力）またはXML |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | ロケール依存 |

## 帳票レイアウト

### レイアウト概要

デフォルトでは1トークン1行形式。-l オプションで1レコード1行形式も可能。区切り文字はデフォルトでカンマ。

```
┌──────────────────────────────────────────────────────────────┐
│ header,{record_length},{version},{event},{modifier},{date}    │
│ subject,{audit_uid},{euid},{egid},{uid},{gid},{pid},{sid},...│
│ argument,{arg_no},{value},{text}                             │
│ path,{pathname}                                              │
│ return,{errno},{retval}                                      │
│ trailer,{record_length}                                      │
│ (次のレコード...)                                             │
└──────────────────────────────────────────────────────────────┘
```

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | トークンタイプ | 監査トークンの種別 | au_fetch_tok() | 文字列 |
| 2 | トークン属性 | 各トークン固有の属性値 | tokenstr_t構造体 | 区切り文字区切り |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 入力ファイル | 監査トレイルファイルまたは標準入力 | Yes |
| 出力フォーマット | -r（raw）、-s（short）、-x（XML）、デフォルト | No |
| 区切り文字 | -d オプション（デフォルト: カンマ） | No |
| 部分レコード | -p オプション（不完全レコードの処理） | No |

### ソート順

入力ファイルの順序で出力（ソートなし）

### 改ページ条件

改ページなし。-l オプション未使用時はレコード内のトークンごとに改行。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| BSM監査トレイルファイル | 監査レコード読み取り | au_read_rec() |
| 監査イベントデータベース | イベント名解決 | getauevent() |
| パスワードデータベース | UID→ユーザー名変換 | getpwuid() |
| グループデータベース | GID→グループ名変換 | getgrgid() |

## 計算仕様

特になし（バイナリデータのパースと表示のみ）

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[prauditコマンド実行] --> B[オプション解析]
    B --> C{XMLモード?}
    C -->|Yes| D[XMLヘッダー出力]
    C -->|No| E[ファイルオープン]
    D --> E
    E --> F[print_tokens関数]
    F --> G{-pモード?}
    G -->|Yes| H[ヘッダートークンまでスキップ]
    G -->|No| I[au_read_rec レコード読取り]
    H --> I
    I --> J[au_fetch_tok トークンパース]
    J --> K[au_print_flags_tok トークン出力]
    K --> L{レコード内次トークン?}
    L -->|Yes| J
    L -->|No| M{次レコード?}
    M -->|Yes| I
    M -->|No| N{XMLモード?}
    N -->|Yes| O[XMLフッター出力]
    N -->|No| P[終了]
    O --> P
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ファイルオープン失敗 | 指定ファイルが存在しない | perror(argv[i]) | 次のファイルに進む |
| レコード読み取り失敗 | 不正なBSMレコード | au_read_rec戻り値-1 | 処理終了 |
| 不完全トークン | レコード内のトークンが途切れている | au_fetch_tok戻り値-1 | 当該レコードのパースを中断 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 監査トレイルファイルサイズに依存 |
| 目標出力時間 | ファイルI/O速度に依存 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- 監査トレイルファイルは通常root権限でのみ読み取り可能
- -n オプションで名前解決を無効化可能（AU_OFLAG_NORESOLVE）
- Capsicumサンドボックス対応（HAVE_CAP_ENTER定義時、行128-131, 174-225）
- 各トレイルファイルの処理をfork()で別プロセスに分離してサンドボックス化

## 備考

- ソースコードはOpenBSMプロジェクトのcontribディレクトリに配置（contrib/openbsm/bin/praudit/）
- libbsmライブラリに依存（au_read_rec, au_fetch_tok, au_print_flags_tok等）
- 出力フラグ: AU_OFLAG_RAW（生データ）、AU_OFLAG_SHORT（短縮形）、AU_OFLAG_XML（XML形式）、AU_OFLAG_NORESOLVE（名前解決なし）
- -r と -s は排他的オプション（行153-161）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | libbsm.h | `contrib/openbsm/bsm/libbsm.h` | tokenstr_t構造体、au_read_rec/au_fetch_tok/au_print_flags_tok関数宣言 |

**読解のコツ**: praudit自体は薄いラッパーで、主要なパース・フォーマットロジックはlibbsmに実装されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | praudit.c | `contrib/openbsm/bin/praudit/praudit.c` | main()（行123-237）：オプション解析、Capsicum初期化、ファイル走査 |

**主要処理フロー**:
1. **行134-172**: getoptによるオプション解析（-d, -l, -n, -p, -r, -s, -x）
2. **行174-184**: Capsicum事前初期化（グループ/パスワード/監査イベントDB）
3. **行186-187**: XMLモード時のXMLヘッダー出力
4. **行190-231**: ファイル走査とprint_tokens()呼出し

#### Step 3: トークン出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | praudit.c | `contrib/openbsm/bin/praudit/praudit.c` | print_tokens()（行82-121）：レコード読取りループ、トークンパース・出力 |

**主要処理フロー**:
- **行91-98**: 部分レコードモード時のヘッダートークン検索
- **行100**: au_read_rec()でバイナリレコード読取り
- **行104-106**: au_fetch_tok()でトークンパース
- **行107**: au_print_flags_tok()でトークンフォーマット出力

### プログラム呼び出し階層図

```
main() [praudit.c:123]
    |
    +-- getopt() [オプション解析]
    |
    +-- getgrgid()/setgroupent() [Capsicum事前初期化]
    +-- getpwuid()/setpassent()
    +-- getauevent()
    |
    +-- au_print_xml_header() [XMLヘッダー]
    |
    +-- print_tokens() [praudit.c:82]
    |       |
    |       +-- au_read_rec() [libbsm: レコード読取り]
    |       +-- au_fetch_tok() [libbsm: トークンパース]
    |       +-- au_print_flags_tok() [libbsm: トークン出力]
    |
    +-- au_print_xml_footer() [XMLフッター]
```

### データフロー図

```
[入力]                        [処理]                         [出力]

監査トレイルファイル ──> au_read_rec() ──> au_fetch_tok() ──> stdout
(BSMバイナリ形式)       [レコード読取り]   [トークンパース]    (テキスト/XML)
                                              |
                                        au_print_flags_tok()
                                        [フォーマット出力]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| praudit.c | `contrib/openbsm/bin/praudit/praudit.c` | ソース | メインプログラム |
| libbsm.h | `contrib/openbsm/bsm/libbsm.h` | ヘッダ | BSMライブラリインターフェース |
| Makefile | `usr.sbin/praudit/Makefile` | ビルド | ビルド設定（libbsm依存） |
