# 帳票設計書 22-procstat - プロセス詳細情報レポート

## 概要

本ドキュメントは、FreeBSDのprocstatコマンドが出力するプロセス詳細情報レポートの帳票設計書である。procstatはプロセスの各種詳細情報（スレッド、ファイルディスクリプタ、メモリマッピング、ケイパビリティ等）をテキスト形式で出力する。

### 本帳票の処理概要

procstatコマンドは、libprocstat(3)ライブラリを通じてカーネルからプロセスの詳細情報を取得し、サブコマンドに応じた形式でレポート出力する。libxo(3)を使用しており、テキスト、JSON、XML形式での出力に対応する。

**業務上の目的・背景**：プロセスのデバッグ、パフォーマンス分析、セキュリティ監査において、プロセスの内部状態を詳細に把握する必要がある。procstatは、スレッド状態、メモリマッピング、ファイルディスクリプタ、シグナル設定、ケイパビリティ情報など、多角的なプロセス情報を統一的なインターフェースで提供する。

**帳票の利用シーン**：プロセスのハング調査、メモリリーク分析、ファイルディスクリプタリーク調査、Capsicumケイパビリティの監査、プロセスのリソース使用状況の確認などで使用される。

**主要な出力内容**：
1. 基本情報（-b）: PID、コマンド名、状態、CPU使用率
2. スレッド情報（-t）: スレッドID、スレッド状態、CPU時間
3. ファイルディスクリプタ（-f）: FD番号、ファイルタイプ、パス
4. メモリマッピング（-v）: 仮想アドレス範囲、保護属性、マッピングタイプ
5. 認証情報（-c）: UID、GID、グループ一覧
6. シグナル情報（-i）: シグナルアクション、マスク
7. カーネルスタック（-k）: スタックトレース
8. ケイパビリティ（-C）: Capsicumケイパビリティ
9. リソース制限（-l）: rlimit値

**帳票の出力タイミング**：コマンドラインからprocstatコマンドを実行した時点で即座に出力される。

**帳票の利用者**：システム管理者、アプリケーション開発者、セキュリティ監査担当者、障害対応エンジニア

## 帳票種別

一覧表（テキスト/JSON/XML形式のテーブル出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | コマンドライン | ターミナル | `procstat [サブコマンド] [PID]` 実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト / JSON / XML（libxo経由） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力、リダイレクト可能） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | ロケール依存（通常UTF-8） |

## 帳票レイアウト

### レイアウト概要

procstatの出力はサブコマンドにより異なるレイアウトとなる。基本的にヘッダー行と明細行で構成される。

```
┌─────────────────────────────────────┐
│         ヘッダー行（カラム名）         │
├─────────────────────────────────────┤
│    明細行（サブコマンドに応じた内容）   │
│              ...                    │
└─────────────────────────────────────┘
```

### ヘッダー部（基本情報: -b）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | PID | プロセスID | kinfo_proc.ki_pid | %5d |
| 2 | COMM | コマンド名 | kinfo_proc.ki_comm | %-16s |
| 3 | STATE | プロセス状態 | kinfo_proc.ki_stat | 文字列 |
| 4 | %CPU | CPU使用率 | kinfo_proc.ki_pctcpu | %6.1f |
| 5 | NICE | nice値 | kinfo_proc.ki_nice | %3d |

### 明細部（スレッド情報: -t）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | PID | プロセスID | kinfo_proc | %5d | 5桁 |
| 2 | TID | スレッドID | kinfo_proc.ki_tid | %6d | 6桁 |
| 3 | COMM | コマンド名 | kinfo_proc.ki_comm | %-16s | 16文字 |
| 4 | TDNAME | スレッド名 | kinfo_proc.ki_tdname | %-16s | 16文字 |
| 5 | CPU | CPU番号 | kinfo_proc.ki_lastcpu | %3d | 3桁 |
| 6 | PRI | 優先度 | kinfo_proc.ki_pri | %3d | 3桁 |
| 7 | STATE | スレッド状態 | kinfo_proc.ki_stat | 文字列 | 可変 |
| 8 | WCHAN | 待ちチャネル | kinfo_proc.ki_wmesg | %-8s | 8文字 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | なし | フッターは出力されない | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| PID指定 | 特定プロセスIDのみ表示 | No（全プロセス表示可能） |
| -a | 全プロセスを対象 | No |
| -w | 繰り返し表示（間隔指定） | No |
| --libxo | 出力形式指定（json, xml等） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | PID | 昇順 |

### 改ページ条件

テキスト出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| kern.proc（sysctl） | プロセス基本情報取得 | PIDで指定 |
| kern.proc.filedesc（sysctl） | FD情報取得 | PIDで指定 |
| kern.proc.vmmap（sysctl） | メモリマッピング情報取得 | PIDで指定 |

### テーブル別参照項目詳細

#### kern.proc（sysctl）

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| ki_pid | PID | プロセス単位 | プロセスID |
| ki_comm | COMM | プロセス単位 | コマンド名 |
| ki_stat | STATE | プロセス単位 | プロセス状態 |
| ki_tid | TID | スレッド単位 | スレッドID |
| ki_uid | UID | プロセス単位 | ユーザーID |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| %CPU | ki_pctcpu / fscale * 100 | 小数点1位 | CPU使用率パーセンテージ |
| RUNTIME | ki_runtime / 1000000 | 整数秒 | ランタイム（マイクロ秒→秒変換） |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[コマンド実行] --> B[xo_parse_args - libxo初期化]
    B --> C[getopt - オプション解析]
    C --> D[サブコマンド判定]
    D --> E[procstat_open_sysctl - libprocstat初期化]
    E --> F[procstat_getprocs - プロセス一覧取得]
    F --> G{サブコマンド分岐}
    G -->|基本情報| H[procstat_basic]
    G -->|スレッド| I[procstat_threads]
    G -->|FD| J[procstat_files]
    G -->|VM| K[procstat_vm]
    G -->|その他| L[対応サブコマンド関数]
    H --> M[xo_emit - 出力]
    I --> M
    J --> M
    K --> M
    L --> M
    M --> N[xo_finish - libxo終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 無効なPID | 存在しないPID指定 | xo_err出力 | 正しいPIDを指定 |
| 権限不足 | 他ユーザーのプロセスへのアクセス | 権限エラー | rootで実行 |
| 無効なサブコマンド | 不明なオプション | usage()表示 | ヘルプを参照 |
| sysctl失敗 | カーネル情報取得失敗 | xo_err出力 | システム状態を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1プロセスあたり数十〜数千エントリ |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- root権限がない場合、自プロセスの情報のみ参照可能
- カーネルスタック情報（-k）はセキュリティ上センシティブな情報を含む可能性がある
- Capsicumケイパビリティ情報はセキュリティ監査に有用

## 備考

- procstatは多数のサブコマンドを持ち、各サブコマンドが独立したソースファイル（procstat_*.c）として実装されている
- libxo(3)によりJSON/XML出力に対応しているため、自動化スクリプトとの連携が容易
- procstat.hにPROCSTAT_*定数とProcstatデータ構造が定義されている

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | procstat.h | `usr.bin/procstat/procstat.h` | procstat構造体、各サブコマンドの関数プロトタイプ、オプションフラグ定義を確認。cmdopt列挙型でサブコマンドが定義されている |

**読解のコツ**: procstat.hのcmdopt列挙型を見ることで、全サブコマンドの一覧を把握できる。各サブコマンドに対応するprocstat_*関数が宣言されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | procstat.c | `usr.bin/procstat/procstat.c` | main()関数。xo_parse_args()でlibxo初期化後、getopt()でオプション解析、サブコマンドに応じた関数を呼び出す |

**主要処理フロー**:
1. **行74-75**: xo_parse_args()でlibxo引数を解析
2. **行84-250付近**: getopt()による長大なオプション解析（-b, -c, -f, -i, -k, -l, -t, -v等の各サブコマンド）
3. **行300付近**: procstat_open_sysctl()またはprocstat_open_core()でlibprocstatを初期化
4. **行350付近**: procstat_getprocs()で対象プロセス一覧を取得
5. **行400付近**: switch文でサブコマンドに応じた処理関数を呼び出し

#### Step 3: 各サブコマンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | procstat_basic.c | `usr.bin/procstat/procstat_basic.c` | 基本プロセス情報の表示（PID, COMM, STATE等） |
| 3-2 | procstat_threads.c | `usr.bin/procstat/procstat_threads.c` | スレッド情報の表示 |
| 3-3 | procstat_files.c | `usr.bin/procstat/procstat_files.c` | ファイルディスクリプタ情報の表示 |
| 3-4 | procstat_vm.c | `usr.bin/procstat/procstat_vm.c` | メモリマッピング情報の表示 |
| 3-5 | procstat_cred.c | `usr.bin/procstat/procstat_cred.c` | 認証情報の表示 |
| 3-6 | procstat_sigs.c | `usr.bin/procstat/procstat_sigs.c` | シグナル情報の表示 |
| 3-7 | procstat_kstack.c | `usr.bin/procstat/procstat_kstack.c` | カーネルスタックの表示 |

**主要処理フロー**:
- 各procstat_*.cファイルは共通パターン：libprocstat APIでデータ取得 → xo_emit()で整形出力

### プログラム呼び出し階層図

```
main() [procstat.c]
    │
    ├─ xo_parse_args() - libxo初期化
    ├─ getopt() - オプション解析
    ├─ procstat_open_sysctl() - libprocstat初期化
    ├─ procstat_getprocs() - プロセス一覧取得
    │
    └─ switch(サブコマンド)
           ├─ procstat_basic() [procstat_basic.c]
           ├─ procstat_threads() [procstat_threads.c]
           ├─ procstat_files() [procstat_files.c]
           ├─ procstat_vm() [procstat_vm.c]
           ├─ procstat_cred() [procstat_cred.c]
           ├─ procstat_sigs() [procstat_sigs.c]
           ├─ procstat_kstack() [procstat_kstack.c]
           ├─ procstat_rlimit() [procstat_rlimit.c]
           ├─ procstat_rusage() [procstat_rusage.c]
           ├─ procstat_args() [procstat_args.c]
           ├─ procstat_bin() [procstat_bin.c]
           ├─ procstat_auxv() [procstat_auxv.c]
           └─ procstat_advlock() [procstat_advlock.c]
```

### データフロー図

```
[入力]               [処理]                    [出力]

コマンドライン   ───▶ オプション解析        ───▶ サブコマンド決定
オプション

kern.proc       ───▶ procstat_getprocs()  ───▶ プロセスリスト
(sysctl)

kern.proc.*     ───▶ サブコマンド関数      ───▶ 詳細情報
(sysctl)              │
                      ▼
                 xo_emit()              ───▶ 標準出力
                                             (text/json/xml)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| procstat.c | `usr.bin/procstat/procstat.c` | ソース | エントリーポイント、サブコマンドディスパッチ |
| procstat.h | `usr.bin/procstat/procstat.h` | ヘッダー | 構造体定義、関数プロトタイプ |
| procstat_basic.c | `usr.bin/procstat/procstat_basic.c` | ソース | 基本プロセス情報表示 |
| procstat_threads.c | `usr.bin/procstat/procstat_threads.c` | ソース | スレッド情報表示 |
| procstat_files.c | `usr.bin/procstat/procstat_files.c` | ソース | ファイルディスクリプタ表示 |
| procstat_vm.c | `usr.bin/procstat/procstat_vm.c` | ソース | メモリマッピング表示 |
| procstat_cred.c | `usr.bin/procstat/procstat_cred.c` | ソース | 認証情報表示 |
| procstat_sigs.c | `usr.bin/procstat/procstat_sigs.c` | ソース | シグナル情報表示 |
| procstat_kstack.c | `usr.bin/procstat/procstat_kstack.c` | ソース | カーネルスタック表示 |
| procstat_rlimit.c | `usr.bin/procstat/procstat_rlimit.c` | ソース | リソース制限表示 |
| procstat_rusage.c | `usr.bin/procstat/procstat_rusage.c` | ソース | リソース使用量表示 |
| procstat_args.c | `usr.bin/procstat/procstat_args.c` | ソース | コマンドライン引数表示 |
| procstat_bin.c | `usr.bin/procstat/procstat_bin.c` | ソース | バイナリパス表示 |
| procstat_auxv.c | `usr.bin/procstat/procstat_auxv.c` | ソース | 補助ベクタ表示 |
| procstat_advlock.c | `usr.bin/procstat/procstat_advlock.c` | ソース | アドバイザリロック表示 |
| procstat_kqueue.c | `usr.bin/procstat/procstat_kqueue.c` | ソース | kqueue情報表示 |
| procstat_cs.c | `usr.bin/procstat/procstat_cs.c` | ソース | コンテキストスイッチ表示 |
| procstat_pwdx.c | `usr.bin/procstat/procstat_pwdx.c` | ソース | カレントディレクトリ表示 |
| procstat_penv.c | `usr.bin/procstat/procstat_penv.c` | ソース | 環境変数表示 |
| procstat_ptlwpinfo.c | `usr.bin/procstat/procstat_ptlwpinfo.c` | ソース | LWP情報表示 |
| procstat_rlimitusage.c | `usr.bin/procstat/procstat_rlimitusage.c` | ソース | リソース制限使用状況表示 |
| Makefile | `usr.bin/procstat/Makefile` | ビルド | ビルド設定 |
