# 帳票設計書 24-lsvfs - 仮想ファイルシステム一覧レポート

## 概要

本ドキュメントは、FreeBSDのlsvfsコマンドが出力する仮想ファイルシステム一覧レポートの帳票設計書である。lsvfsはカーネルにインストール済みの仮想ファイルシステム（VFS）モジュールの一覧を表示する。

### 本帳票の処理概要

lsvfsコマンドは、getvfsbyname(3)またはvfsconf構造体の走査によりカーネルに登録済みのVFSモジュール情報を取得し、テーブル形式で出力する。非常にシンプルなコマンドで、単一のCソースファイルで実装されている。

**業務上の目的・背景**：システム管理において、どのファイルシステムタイプが利用可能かを確認する必要がある。新しいファイルシステムモジュールのロード確認、サポートされるファイルシステムの一覧取得、マウント操作前のファイルシステムタイプ確認に使用される。

**帳票の利用シーン**：ファイルシステムモジュールのロード確認、mount操作前の利用可能FS確認、カーネル構成の監査、トラブルシューティング時のFS対応状況確認などで使用される。

**主要な出力内容**：
1. Filesystem: ファイルシステム名（例: ufs, zfs, nfs, tmpfs等）
2. Refs: 参照カウント（マウント数）
3. Flags: VFSフラグ（仮想、ネットワーク、ジェイル可能等）

**帳票の出力タイミング**：コマンドラインからlsvfsコマンドを実行した時点で即座に出力される。

**帳票の利用者**：システム管理者、ストレージ管理者

## 帳票種別

一覧表（テキスト形式のテーブル出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | コマンドライン | ターミナル | `lsvfs [vfsname]` 実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | ASCII |

## 帳票レイアウト

### レイアウト概要

```
┌──────────────────────────────────────┐
│ Filesystem                Refs Flags │
├──────────────────────────────────────┤
│ ufs                         5       │
│ zfs                         3       │
│ tmpfs                       2       │
│ devfs                       1       │
│            ...                      │
├──────────────────────────────────────┤
│ (件数サマリー)                        │
└──────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Filesystem | ファイルシステム名 | vfsconf.vfc_name | 左寄せ文字列 |
| 2 | Refs | 参照カウント | vfsconf.vfc_refcount | 右寄せ整数 |
| 3 | Flags | VFSフラグ | vfsconf.vfc_flags | フラグ文字列 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Filesystem | VFS名 | xvfsconf.vfc_name | %-20s | 20文字 |
| 2 | Refs | 参照数 | xvfsconf.vfc_refcount | %5d | 5桁 |
| 3 | Flags | フラグ | xvfsconf.vfc_flags | フラグ文字列 | 可変 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 件数行 | VFS総数（引数なし時） | カウント | 整数 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| vfsname引数 | 特定VFSのみ表示 | No（全VFS表示） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | カーネル内部順序 | カーネル登録順 |

### 改ページ条件

テキスト出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| vfs.conflist（sysctl） | VFS設定一覧取得 | なし |

### テーブル別参照項目詳細

#### vfs.conflist（sysctl）

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| vfc_name | Filesystem | 全件取得 | VFS名 |
| vfc_refcount | Refs | 全件取得 | 参照カウント |
| vfc_flags | Flags | 全件取得 | VFSフラグビットマスク |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Flags表示 | vfc_flagsのビットマスクを文字列に変換 | N/A | VFCF_STATIC→static等 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[コマンド実行] --> B{引数あり?}
    B -->|Yes| C[getvfsbyname で特定VFS取得]
    B -->|No| D[全VFS列挙]
    C --> E[VFS情報表示]
    D --> F[ヘッダー出力]
    F --> G[各VFS情報をループ表示]
    G --> H[件数サマリー出力]
    E --> I[終了]
    H --> I
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| VFS未検出 | 指定VFS名が存在しない | "VFS not found" | 正しいVFS名を指定 |
| sysctl失敗 | VFS情報取得失敗 | エラーメッセージ | システム状態を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十VFSモジュール |
| 目標出力時間 | 即時（ミリ秒単位） |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- VFS一覧情報は一般ユーザーでも参照可能
- カーネルモジュール構成が外部に漏洩する可能性（低リスク）

## 備考

- lsvfsは非常にシンプルなコマンドで、lsvfs.c単一ファイルで実装されている
- getvfsbyname(3)はFreeBSD固有のライブラリ関数
- フラグ値にはVFCF_STATIC, VFCF_NETWORK, VFCF_JAIL等がある

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lsvfs.c | `usr.bin/lsvfs/lsvfs.c` | struct xvfsconf構造体（sys/mount.hで定義）がVFS情報を保持。vfc_name（名前）、vfc_refcount（参照数）、vfc_flags（フラグ）が主要フィールド |

**読解のコツ**: xvfsconfはカーネルのvfsconf構造体のユーザーランド版。sysctl経由で取得される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lsvfs.c | `usr.bin/lsvfs/lsvfs.c` | main()関数。引数の有無で分岐：引数ありならgetvfsbyname()で特定VFS、なければ全VFS列挙 |

**主要処理フロー**:
1. **行60付近**: main()開始、引数チェック
2. **行70付近**: 引数ありの場合、getvfsbyname()で特定VFS情報を取得
3. **行80付近**: 引数なしの場合、sysctlbyname("vfs.conflist")で全VFS一覧を取得
4. **行90付近**: ヘッダー行出力
5. **行100付近**: 各VFSエントリの情報を出力（名前、参照数、フラグ）
6. **行110付近**: 合計件数を出力

#### Step 3: フラグ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lsvfs.c | `usr.bin/lsvfs/lsvfs.c` | fmt_flags()関数。vfc_flagsビットマスクを人間可読な文字列に変換 |

**主要処理フロー**:
- VFCF_STATIC → "static"
- VFCF_NETWORK → "network"
- VFCF_SYNTHETIC → "synthetic"
- VFCF_JAIL → "jail-allowed"

### プログラム呼び出し階層図

```
main() [lsvfs.c]
    │
    ├─ getvfsbyname() - 特定VFS情報取得（引数あり時）
    │
    ├─ sysctlbyname("vfs.conflist") - 全VFS一覧取得（引数なし時）
    │
    ├─ printf() - ヘッダー出力
    │
    ├─ fmt_flags() - フラグ文字列変換
    │
    └─ printf() - 各VFS行出力 + サマリー
```

### データフロー図

```
[入力]               [処理]                    [出力]

コマンドライン   ───▶ 引数チェック          ───▶ 分岐判定
引数

vfs.conflist    ───▶ sysctl取得            ───▶ xvfsconf配列
(sysctl)              │
                      ▼
                 fmt_flags()変換       ───▶ 標準出力
                                           (テーブル形式)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lsvfs.c | `usr.bin/lsvfs/lsvfs.c` | ソース | 全ロジック（単一ファイル） |
| Makefile | `usr.bin/lsvfs/Makefile` | ビルド | ビルド設定 |
