# 帳票設計書 26-ipcs - System V IPC施設ステータスレポート

## 概要

本ドキュメントは、FreeBSDのipcsコマンドが出力するSystem V IPC施設ステータスレポートの帳票設計書である。ipcsはSystem Vプロセス間通信（IPC）施設の状態を表示する。

### 本帳票の処理概要

ipcsコマンドは、sysctl経由でカーネルから共有メモリセグメント、メッセージキュー、セマフォの情報を取得し、テーブル形式でレポートする。各IPC施設のID、キー、所有者、権限、サイズ等の詳細情報を表示する。

**業務上の目的・背景**：System V IPCリソースの管理と監視は、レガシーアプリケーションの運用やリソースリーク検出に必要である。共有メモリの使用状況、メッセージキューの滞留状況、セマフォの状態を把握することで、アプリケーション間通信の問題を特定できる。

**帳票の利用シーン**：IPCリソースリークの調査、共有メモリの使用状況確認、メッセージキューの滞留監視、セマフォのデッドロック調査、ipcrm実行前のリソース確認などで使用される。

**主要な出力内容**：
1. 共有メモリセグメント: ID、キー、モード、所有者、グループ、サイズ
2. メッセージキュー: ID、キー、モード、所有者、グループ、メッセージ数、バイト数
3. セマフォ: ID、キー、モード、所有者、グループ、セマフォ数

**帳票の出力タイミング**：コマンドラインからipcsコマンドを実行した時点で即座に出力される。

**帳票の利用者**：システム管理者、アプリケーション開発者

## 帳票種別

一覧表（テキスト形式のテーブル出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | コマンドライン | ターミナル | `ipcs [オプション]` 実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | ASCII |

## 帳票レイアウト

### レイアウト概要

```
┌─────────────────────────────────────┐
│     Shared Memory:                  │
│     ヘッダー行                       │
│     明細行...                        │
├─────────────────────────────────────┤
│     Message Queues:                 │
│     ヘッダー行                       │
│     明細行...                        │
├─────────────────────────────────────┤
│     Semaphores:                     │
│     ヘッダー行                       │
│     明細行...                        │
└─────────────────────────────────────┘
```

### ヘッダー部（共有メモリ）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | T | タイプ（m=memory） | 固定値 | 文字 |
| 2 | ID | 共有メモリID | shmid_ds.shm_perm._key | 整数 |
| 3 | KEY | IPCキー | shmid_ds.shm_perm._key | 16進数 |
| 4 | MODE | パーミッションモード | shmid_ds.shm_perm.mode | 8進数 |
| 5 | OWNER | 所有者名 | shmid_ds.shm_perm.uid | 文字列 |
| 6 | GROUP | グループ名 | shmid_ds.shm_perm.gid | 文字列 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | T | タイプ文字 | 固定値 | %c | 1文字 |
| 2 | ID | IPC ID | ipc_perm.seq | %12d | 12桁 |
| 3 | KEY | IPCキー | ipc_perm._key | 0x%08x | 10文字 |
| 4 | MODE | モード | ipc_perm.mode | %s | 11文字 |
| 5 | OWNER | 所有者 | ipc_perm.uid | %-8s | 8文字 |
| 6 | GROUP | グループ | ipc_perm.gid | %-8s | 8文字 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | なし | フッターは出力されない | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| -M | 共有メモリのみ表示 | No |
| -Q | メッセージキューのみ表示 | No |
| -S | セマフォのみ表示 | No |
| -a | 全情報を表示 | No |
| -b | バイト数/サイズ表示 | No |
| -c | 作成者情報表示 | No |
| -o | 未処理情報表示 | No |
| -p | PID情報表示 | No |
| -t | 時刻情報表示 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | IPC ID | 昇順 |

### 改ページ条件

テキスト出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| kern.ipc.shmsegs（sysctl） | 共有メモリセグメント情報 | なし |
| kern.ipc.msqids（sysctl） | メッセージキュー情報 | なし |
| kern.ipc.semakinfo（sysctl） | セマフォ情報 | なし |
| passwd DB | UID→ユーザー名変換 | UIDで検索 |
| group DB | GID→グループ名変換 | GIDで検索 |

### テーブル別参照項目詳細

#### kern.ipc.shmsegs（sysctl）

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| shm_perm._key | KEY | 全件取得 | IPCキー |
| shm_perm.mode | MODE | 全件取得 | パーミッション |
| shm_perm.uid | OWNER | 全件取得 | UID→名前変換 |
| shm_perm.gid | GROUP | 全件取得 | GID→名前変換 |
| shm_segsz | SEGSZ | 全件取得 | セグメントサイズ |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| MODE表示 | ipc_perm.modeをrwxrwxrwx形式に変換 | N/A | cvt_id()関数 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[コマンド実行] --> B[getopt - オプション解析]
    B --> C{表示対象}
    C -->|共有メモリ| D[sysctl kern.ipc.shmsegs]
    C -->|メッセージキュー| E[sysctl kern.ipc.msqids]
    C -->|セマフォ| F[sysctl kern.ipc.semakinfo]
    D --> G[セクションヘッダー出力]
    E --> G
    F --> G
    G --> H[各エントリを表示]
    H --> I[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| sysctl失敗 | カーネルIPC情報取得失敗 | errx()出力 | IPC機能がカーネルで有効か確認 |
| IPCなし | 対象IPC施設が存在しない | 空のセクション | 正常動作 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数百IPC施設 |
| 目標出力時間 | 即時（ミリ秒単位） |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- 一般ユーザーでも全IPC施設の情報を参照可能
- 他ユーザーのIPC施設の情報が漏洩する可能性がある
- ipcrm連携時の確認用途として重要

## 備考

- ipcsはPOSIX標準コマンド
- ipcs.cがメインの処理、ipc.cがIPC権限表示のヘルパー
- System V IPCはPOSIX IPCに置き換わりつつあるが、レガシーアプリケーションで依然使用される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ipcs.c | `usr.bin/ipcs/ipcs.c` | shmid_ds, msqid_ds, semid_ds構造体（sys/shm.h, sys/msg.h, sys/sem.hで定義）がIPC施設情報を保持 |

**読解のコツ**: 各IPC施設はipc_perm構造体を共通で持つ。_key, mode, uid, gidが共通フィールド。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ipcs.c | `usr.bin/ipcs/ipcs.c` | main()関数でgetopt()によるオプション解析後、共有メモリ/メッセージキュー/セマフォの順に情報取得・表示 |

**主要処理フロー**:
1. **行60付近**: getopt()によるオプション解析（-M, -Q, -S, -a, -b, -c, -o, -p, -t）
2. **行100付近**: 共有メモリ情報の取得と表示（sysctlbyname "kern.ipc.shmsegs"）
3. **行150付近**: メッセージキュー情報の取得と表示（sysctlbyname "kern.ipc.msqids"）
4. **行200付近**: セマフォ情報の取得と表示（sysctlbyname "kern.ipc.semakinfo"）

#### Step 3: 権限表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ipc.c | `usr.bin/ipcs/ipc.c` | cvt_id()関数: IPC権限のモード文字列変換。ipc_perm.modeを"--rw-rw-rw-"形式の文字列に変換 |

### プログラム呼び出し階層図

```
main() [ipcs.c]
    │
    ├─ getopt() - オプション解析
    │
    ├─ 共有メモリセクション
    │      ├─ sysctlbyname("kern.ipc.shmsegs")
    │      ├─ セクションヘッダー出力
    │      └─ 各エントリ表示（cvt_id()使用）
    │
    ├─ メッセージキューセクション
    │      ├─ sysctlbyname("kern.ipc.msqids")
    │      ├─ セクションヘッダー出力
    │      └─ 各エントリ表示（cvt_id()使用）
    │
    └─ セマフォセクション
           ├─ sysctlbyname("kern.ipc.semakinfo")
           ├─ セクションヘッダー出力
           └─ 各エントリ表示（cvt_id()使用）
```

### データフロー図

```
[入力]                    [処理]                    [出力]

kern.ipc.shmsegs    ───▶ sysctl取得           ──┐
kern.ipc.msqids     ───▶ sysctl取得           ──┤──▶ セクション別表示
kern.ipc.semakinfo  ───▶ sysctl取得           ──┘
                                                   │
passwd/group DB     ───▶ UID/GID→名前変換     ──▶  │
                                                   ▼
                                              標準出力
                                              (テーブル形式)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ipcs.c | `usr.bin/ipcs/ipcs.c` | ソース | メインロジック、IPC情報取得・表示 |
| ipc.c | `usr.bin/ipcs/ipc.c` | ソース | IPC権限表示ヘルパー |
| Makefile | `usr.bin/ipcs/Makefile` | ビルド | ビルド設定 |
